/*
 * Broadcom chipcommon NAND flash interface
 *
 * Copyright (C) 2012, Broadcom Corporation. All Rights Reserved.
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * $Id:$
 */

#include <typedefs.h>
#include <osl.h>
#include <bcmutils.h>
#include <siutils.h>
#include <hndsoc.h>
#include <sbhndcpu.h>
#include <sbchipc.h>
#include <bcmdevs.h>
#include <hndnand.h>
#include <hndpmu.h>

/* Private global state */
static hndnand_t *hndnand = NULL;

extern hndnand_t *nflash_init(si_t *sih);
extern hndnand_t *nandcore_init(si_t *sih);

/* Initialize nand flash access */
hndnand_t *
hndnand_init(si_t *sih)
{
	uint32 origidx;

	ASSERT(sih);

	/* Already initialized ? */
	if (hndnand)
		return hndnand;

	origidx = si_coreidx(sih);

#ifdef	__mips__
	if (!hndnand)
		hndnand = nflash_init(sih);
#endif
#ifdef __ARM_ARCH_7A__
	if (!hndnand)
		hndnand = nandcore_init(sih);
#endif

	si_setcoreidx(sih, origidx);
	return hndnand;
}

void
hndnand_enable(hndnand_t *nfl, int enable)
{
	ASSERT(nfl);

	if (nfl->enable) {
		/* Should spinlock here */
		(nfl->enable)(nfl, enable);
	}

	return;
}

/* Read len bytes starting at offset into buf. Returns number of bytes read. */
int
hndnand_read(hndnand_t *nfl, uint offset, uint len, uchar *buf)
{
	ASSERT(nfl);
	ASSERT(nfl->read);

	return (nfl->read)(nfl, offset, len, buf);
}

/* Write len bytes starting at offset into buf. Returns number of bytes
 * written.
 */
int
hndnand_write(hndnand_t *nfl, uint offset, uint len, const uchar *buf)
{
	ASSERT(nfl);
	ASSERT(nfl->write);

	return (nfl->write)(nfl, offset, len, buf);
}

/* Erase a region. Returns number of bytes scheduled for erasure.
 * Caller should poll for completion.
 */
int
hndnand_erase(hndnand_t *nfl, uint offset)
{
	ASSERT(nfl);
	ASSERT(nfl->erase);

	return (nfl->erase)(nfl, offset);
}

int
hndnand_checkbadb(hndnand_t *nfl, uint offset)
{
	ASSERT(nfl);
	ASSERT(nfl->checkbadb);

	return (nfl->checkbadb)(nfl, offset);
}

int
hndnand_mark_badb(hndnand_t *nfl, uint offset)
{
	ASSERT(nfl);
	ASSERT(nfl->markbadb);

	return (nfl->markbadb)(nfl, offset);
}
