/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_eventlog.h"

#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_eventlogReadFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlogReadFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlogReadFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "EVENTLOG_SEQUENTIAL_READ", EVENTLOG_SEQUENTIAL_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "EVENTLOG_SEEK_READ", EVENTLOG_SEEK_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "EVENTLOG_FORWARDS_READ", EVENTLOG_FORWARDS_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "EVENTLOG_BACKWARDS_READ", EVENTLOG_BACKWARDS_READ, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_eventlogEventTypes(struct ndr_push *ndr, int ndr_flags, enum eventlogEventTypes r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_eventlogEventTypes(struct ndr_pull *ndr, int ndr_flags, enum eventlogEventTypes *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlogEventTypes(struct ndr_print *ndr, const char *name, enum eventlogEventTypes r)
{
	const char *val = NULL;

	switch (r) {
		case EVENTLOG_SUCCESS: val = "EVENTLOG_SUCCESS"; break;
		case EVENTLOG_ERROR_TYPE: val = "EVENTLOG_ERROR_TYPE"; break;
		case EVENTLOG_WARNING_TYPE: val = "EVENTLOG_WARNING_TYPE"; break;
		case EVENTLOG_INFORMATION_TYPE: val = "EVENTLOG_INFORMATION_TYPE"; break;
		case EVENTLOG_AUDIT_SUCCESS: val = "EVENTLOG_AUDIT_SUCCESS"; break;
		case EVENTLOG_AUDIT_FAILURE: val = "EVENTLOG_AUDIT_FAILURE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_eventlog_OpenUnknown0(struct ndr_push *ndr, int ndr_flags, const struct eventlog_OpenUnknown0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenUnknown0(struct ndr_pull *ndr, int ndr_flags, struct eventlog_OpenUnknown0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenUnknown0(struct ndr_print *ndr, const char *name, const struct eventlog_OpenUnknown0 *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenUnknown0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "unknown0", r->unknown0);
	ndr_print_uint16(ndr, "unknown1", r->unknown1);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_eventlog_Record_tdb(struct ndr_push *ndr, int ndr_flags, const struct eventlog_Record_tdb *r)
{
	uint32_t cntr_strings_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "eLfL", 4, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->record_number));
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->time_generated));
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->time_written));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->event_id));
			NDR_CHECK(ndr_push_eventlogEventTypes(ndr, NDR_SCALARS, r->event_type));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_of_strings));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->event_category));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved_flags));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->closing_record_number));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->stringoffset));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid.length));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_offset));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data.length));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data_offset));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m_term(r->source_name)));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->source_name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m_term(r->computer_name)));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->computer_name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sid_padding));
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->sid));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_size_string_array(r->strings, r->num_of_strings, LIBNDR_FLAG_STR_NULLTERM)));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				for (cntr_strings_0 = 0; cntr_strings_0 < r->num_of_strings; cntr_strings_0++) {
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->strings[cntr_strings_0]));
				}
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->padding));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_eventlog_Record_tdb(struct ndr_pull *ndr, int ndr_flags, struct eventlog_Record_tdb *r)
{
	uint32_t size_reserved_0 = 0;
	uint32_t size_strings_0 = 0;
	uint32_t cntr_strings_0;
	TALLOC_CTX *_mem_save_strings_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
			size_reserved_0 = 4;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->reserved, size_reserved_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->record_number));
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->time_generated));
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->time_written));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->event_id));
			NDR_CHECK(ndr_pull_eventlogEventTypes(ndr, NDR_SCALARS, &r->event_type));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_of_strings));
			if (r->num_of_strings > 256) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->event_category));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved_flags));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->closing_record_number));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->stringoffset));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_length));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_offset));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_length));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_offset));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->source_name_len));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->source_name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->computer_name_len));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->computer_name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sid_padding));
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->sid));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->strings_len));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				size_strings_0 = r->num_of_strings;
				NDR_PULL_ALLOC_N(ndr, r->strings, size_strings_0);
				_mem_save_strings_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->strings, 0);
				for (cntr_strings_0 = 0; cntr_strings_0 < size_strings_0; cntr_strings_0++) {
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->strings[cntr_strings_0]));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_0, 0);
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->padding));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_Record_tdb(struct ndr_print *ndr, const char *name, const struct eventlog_Record_tdb *r)
{
	uint32_t cntr_strings_0;
	ndr_print_struct(ndr, name, "eventlog_Record_tdb");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "size", r->size);
		ndr_print_string(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"eLfL":r->reserved);
		ndr_print_uint32(ndr, "record_number", r->record_number);
		ndr_print_time_t(ndr, "time_generated", r->time_generated);
		ndr_print_time_t(ndr, "time_written", r->time_written);
		ndr_print_uint32(ndr, "event_id", r->event_id);
		ndr_print_eventlogEventTypes(ndr, "event_type", r->event_type);
		ndr_print_uint16(ndr, "num_of_strings", r->num_of_strings);
		ndr_print_uint16(ndr, "event_category", r->event_category);
		ndr_print_uint16(ndr, "reserved_flags", r->reserved_flags);
		ndr_print_uint32(ndr, "closing_record_number", r->closing_record_number);
		ndr_print_uint32(ndr, "stringoffset", r->stringoffset);
		ndr_print_uint32(ndr, "sid_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->sid.length:r->sid_length);
		ndr_print_uint32(ndr, "sid_offset", r->sid_offset);
		ndr_print_uint32(ndr, "data_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->data.length:r->data_length);
		ndr_print_uint32(ndr, "data_offset", r->data_offset);
		ndr_print_uint32(ndr, "source_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m_term(r->source_name):r->source_name_len);
		ndr_print_string(ndr, "source_name", r->source_name);
		ndr_print_uint32(ndr, "computer_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m_term(r->computer_name):r->computer_name_len);
		ndr_print_string(ndr, "computer_name", r->computer_name);
		ndr_print_uint32(ndr, "sid_padding", r->sid_padding);
		ndr_print_DATA_BLOB(ndr, "sid", r->sid);
		ndr_print_uint32(ndr, "strings_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_size_string_array(r->strings, r->num_of_strings, LIBNDR_FLAG_STR_NULLTERM):r->strings_len);
		ndr->print(ndr, "%s: ARRAY(%d)", "strings", (int)r->num_of_strings);
		ndr->depth++;
		for (cntr_strings_0=0;cntr_strings_0<r->num_of_strings;cntr_strings_0++) {
			ndr_print_string(ndr, "strings", r->strings[cntr_strings_0]);
		}
		ndr->depth--;
		ndr_print_DATA_BLOB(ndr, "data", r->data);
		ndr_print_uint32(ndr, "padding", r->padding);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_EVENTLOG_HEADER_FLAGS(struct ndr_push *ndr, int ndr_flags, enum EVENTLOG_HEADER_FLAGS r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EVENTLOG_HEADER_FLAGS(struct ndr_pull *ndr, int ndr_flags, enum EVENTLOG_HEADER_FLAGS *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOG_HEADER_FLAGS(struct ndr_print *ndr, const char *name, enum EVENTLOG_HEADER_FLAGS r)
{
	const char *val = NULL;

	switch (r) {
		case ELF_LOGFILE_HEADER_DIRTY: val = "ELF_LOGFILE_HEADER_DIRTY"; break;
		case ELF_LOGFILE_HEADER_WRAP: val = "ELF_LOGFILE_HEADER_WRAP"; break;
		case ELF_LOGFILE_LOGFULL_WRITTEN: val = "ELF_LOGFILE_LOGFULL_WRITTEN"; break;
		case ELF_LOGFILE_ARCHIVE_SET: val = "ELF_LOGFILE_ARCHIVE_SET"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_EVENTLOGHEADER(struct ndr_push *ndr, int ndr_flags, const struct EVENTLOGHEADER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x30));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "LfLe", 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->StartOffset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EndOffset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->CurrentRecordNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->OldestRecordNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MaxSize));
		NDR_CHECK(ndr_push_EVENTLOG_HEADER_FLAGS(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Retention));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x30));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EVENTLOGHEADER(struct ndr_pull *ndr, int ndr_flags, struct EVENTLOGHEADER *r)
{
	uint32_t size_Signature_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->HeaderSize));
		size_Signature_0 = 4;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Signature, size_Signature_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MajorVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MinorVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->StartOffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EndOffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->CurrentRecordNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->OldestRecordNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MaxSize));
		NDR_CHECK(ndr_pull_EVENTLOG_HEADER_FLAGS(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Retention));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EndHeaderSize));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOGHEADER(struct ndr_print *ndr, const char *name, const struct EVENTLOGHEADER *r)
{
	ndr_print_struct(ndr, name, "EVENTLOGHEADER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "HeaderSize", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x30:r->HeaderSize);
	ndr_print_string(ndr, "Signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"LfLe":r->Signature);
	ndr_print_uint32(ndr, "MajorVersion", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->MajorVersion);
	ndr_print_uint32(ndr, "MinorVersion", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->MinorVersion);
	ndr_print_uint32(ndr, "StartOffset", r->StartOffset);
	ndr_print_uint32(ndr, "EndOffset", r->EndOffset);
	ndr_print_uint32(ndr, "CurrentRecordNumber", r->CurrentRecordNumber);
	ndr_print_uint32(ndr, "OldestRecordNumber", r->OldestRecordNumber);
	ndr_print_uint32(ndr, "MaxSize", r->MaxSize);
	ndr_print_EVENTLOG_HEADER_FLAGS(ndr, "Flags", r->Flags);
	ndr_print_uint32(ndr, "Retention", r->Retention);
	ndr_print_uint32(ndr, "EndHeaderSize", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x30:r->EndHeaderSize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_EVENTLOGRECORD(struct ndr_push *ndr, int ndr_flags, const struct EVENTLOGRECORD *r)
{
	uint32_t cntr_Strings_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Length));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "LfLe", 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->RecordNumber));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->TimeGenerated));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->TimeWritten));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EventID));
		NDR_CHECK(ndr_push_eventlogEventTypes(ndr, NDR_SCALARS, r->EventType));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NumStrings));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->EventCategory));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ReservedFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ClosingRecordNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername)) + ndr_size_dom_sid0(&r->UserSid, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid0(&r->UserSid, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername))));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->DataLength));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername)) + ndr_size_dom_sid0(&r->UserSid, ndr->flags) + (2 * ndr_size_string_array(r->Strings, r->NumStrings, LIBNDR_FLAG_STR_NULLTERM))));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->SourceName));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Computername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_dom_sid0 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			{
				struct ndr_push *_ndr_UserSid;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_UserSid, 0, ndr_size_dom_sid0(&r->UserSid, ndr->flags)));
				NDR_CHECK(ndr_push_dom_sid0(_ndr_UserSid, NDR_SCALARS|NDR_BUFFERS, &r->UserSid));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_UserSid, 0, ndr_size_dom_sid0(&r->UserSid, ndr->flags)));
			}
			ndr->flags = _flags_save_dom_sid0;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			for (cntr_Strings_0 = 0; cntr_Strings_0 < r->NumStrings; cntr_Strings_0++) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Strings[cntr_Strings_0]));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Data, r->DataLength));
			ndr->flags = _flags_save_uint8;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Pad));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_dom_sid0 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			ndr->flags = _flags_save_dom_sid0;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EVENTLOGRECORD(struct ndr_pull *ndr, int ndr_flags, struct EVENTLOGRECORD *r)
{
	uint32_t size_Reserved_0 = 0;
	uint32_t size_Strings_0 = 0;
	uint32_t cntr_Strings_0;
	TALLOC_CTX *_mem_save_Strings_0;
	uint32_t size_Data_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Length));
		size_Reserved_0 = 4;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Reserved, size_Reserved_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->RecordNumber));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->TimeGenerated));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->TimeWritten));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EventID));
		NDR_CHECK(ndr_pull_eventlogEventTypes(ndr, NDR_SCALARS, &r->EventType));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NumStrings));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->EventCategory));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ReservedFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ClosingRecordNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->StringOffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->UserSidLength));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->UserSidOffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->DataLength));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->DataOffset));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->SourceName));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Computername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_dom_sid0 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			{
				struct ndr_pull *_ndr_UserSid;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_UserSid, 0, r->UserSidLength));
				NDR_CHECK(ndr_pull_dom_sid0(_ndr_UserSid, NDR_SCALARS|NDR_BUFFERS, &r->UserSid));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_UserSid, 0, r->UserSidLength));
			}
			ndr->flags = _flags_save_dom_sid0;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			size_Strings_0 = r->NumStrings;
			NDR_PULL_ALLOC_N(ndr, r->Strings, size_Strings_0);
			_mem_save_Strings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Strings, 0);
			for (cntr_Strings_0 = 0; cntr_Strings_0 < size_Strings_0; cntr_Strings_0++) {
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Strings[cntr_Strings_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Strings_0, 0);
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			size_Data_0 = r->DataLength;
			NDR_PULL_ALLOC_N(ndr, r->Data, size_Data_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Data, size_Data_0));
			ndr->flags = _flags_save_uint8;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Pad));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Length2));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_dom_sid0 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			ndr->flags = _flags_save_dom_sid0;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOGRECORD(struct ndr_print *ndr, const char *name, const struct EVENTLOGRECORD *r)
{
	uint32_t cntr_Strings_0;
	ndr_print_struct(ndr, name, "EVENTLOGRECORD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "Length", r->Length);
	ndr_print_string(ndr, "Reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"LfLe":r->Reserved);
	ndr_print_uint32(ndr, "RecordNumber", r->RecordNumber);
	ndr_print_time_t(ndr, "TimeGenerated", r->TimeGenerated);
	ndr_print_time_t(ndr, "TimeWritten", r->TimeWritten);
	ndr_print_uint32(ndr, "EventID", r->EventID);
	ndr_print_eventlogEventTypes(ndr, "EventType", r->EventType);
	ndr_print_uint16(ndr, "NumStrings", r->NumStrings);
	ndr_print_uint16(ndr, "EventCategory", r->EventCategory);
	ndr_print_uint16(ndr, "ReservedFlags", r->ReservedFlags);
	ndr_print_uint32(ndr, "ClosingRecordNumber", r->ClosingRecordNumber);
	ndr_print_uint32(ndr, "StringOffset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername)) + r->UserSidLength:r->StringOffset);
	ndr_print_uint32(ndr, "UserSidLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid0(&r->UserSid, ndr->flags):r->UserSidLength);
	ndr_print_uint32(ndr, "UserSidOffset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername)):r->UserSidOffset);
	ndr_print_uint32(ndr, "DataLength", r->DataLength);
	ndr_print_uint32(ndr, "DataOffset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?56 + 2 * (strlen_m_term(r->SourceName) + strlen_m_term(r->Computername)) + r->UserSidLength + (2 * ndr_size_string_array(r->Strings, r->NumStrings, LIBNDR_FLAG_STR_NULLTERM)):r->DataOffset);
	ndr_print_string(ndr, "SourceName", r->SourceName);
	ndr_print_string(ndr, "Computername", r->Computername);
	ndr_print_dom_sid0(ndr, "UserSid", &r->UserSid);
	ndr->print(ndr, "%s: ARRAY(%d)", "Strings", (int)r->NumStrings);
	ndr->depth++;
	for (cntr_Strings_0=0;cntr_Strings_0<r->NumStrings;cntr_Strings_0++) {
		ndr_print_string(ndr, "Strings", r->Strings[cntr_Strings_0]);
	}
	ndr->depth--;
	ndr_print_array_uint8(ndr, "Data", r->Data, r->DataLength);
	ndr_print_string(ndr, "Pad", r->Pad);
	ndr_print_uint32(ndr, "Length2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->Length:r->Length2);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_EVENTLOGRECORD(const struct EVENTLOGRECORD *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_EVENTLOGRECORD);
}

_PUBLIC_ enum ndr_err_code ndr_push_EVENTLOGEOF(struct ndr_push *ndr, int ndr_flags, const struct EVENTLOGEOF *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x28));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x11111111));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x22222222));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x33333333));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x44444444));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->BeginRecord));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->EndRecord));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->CurrentRecordNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->OldestRecordNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x28));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EVENTLOGEOF(struct ndr_pull *ndr, int ndr_flags, struct EVENTLOGEOF *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->RecordSizeBeginning));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->One));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Two));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Three));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Four));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->BeginRecord));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->EndRecord));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->CurrentRecordNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->OldestRecordNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->RecordSizeEnd));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOGEOF(struct ndr_print *ndr, const char *name, const struct EVENTLOGEOF *r)
{
	ndr_print_struct(ndr, name, "EVENTLOGEOF");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "RecordSizeBeginning", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x28:r->RecordSizeBeginning);
	ndr_print_uint32(ndr, "One", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x11111111:r->One);
	ndr_print_uint32(ndr, "Two", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x22222222:r->Two);
	ndr_print_uint32(ndr, "Three", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x33333333:r->Three);
	ndr_print_uint32(ndr, "Four", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x44444444:r->Four);
	ndr_print_uint32(ndr, "BeginRecord", r->BeginRecord);
	ndr_print_uint32(ndr, "EndRecord", r->EndRecord);
	ndr_print_uint32(ndr, "CurrentRecordNumber", r->CurrentRecordNumber);
	ndr_print_uint32(ndr, "OldestRecordNumber", r->OldestRecordNumber);
	ndr_print_uint32(ndr, "RecordSizeEnd", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x28:r->RecordSizeEnd);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_EVENTLOG_EVT_FILE(struct ndr_push *ndr, int ndr_flags, const struct EVENTLOG_EVT_FILE *r)
{
	uint32_t cntr_records_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_EVENTLOGHEADER(ndr, NDR_SCALARS, &r->hdr));
		for (cntr_records_0 = 0; cntr_records_0 < r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber; cntr_records_0++) {
			NDR_CHECK(ndr_push_EVENTLOGRECORD(ndr, NDR_SCALARS, &r->records[cntr_records_0]));
		}
		NDR_CHECK(ndr_push_EVENTLOGEOF(ndr, NDR_SCALARS, &r->eof));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_records_0 = 0; cntr_records_0 < r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber; cntr_records_0++) {
			NDR_CHECK(ndr_push_EVENTLOGRECORD(ndr, NDR_BUFFERS, &r->records[cntr_records_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EVENTLOG_EVT_FILE(struct ndr_pull *ndr, int ndr_flags, struct EVENTLOG_EVT_FILE *r)
{
	uint32_t size_records_0 = 0;
	uint32_t cntr_records_0;
	TALLOC_CTX *_mem_save_records_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_EVENTLOGHEADER(ndr, NDR_SCALARS, &r->hdr));
		size_records_0 = r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber;
		NDR_PULL_ALLOC_N(ndr, r->records, size_records_0);
		_mem_save_records_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->records, 0);
		for (cntr_records_0 = 0; cntr_records_0 < size_records_0; cntr_records_0++) {
			NDR_CHECK(ndr_pull_EVENTLOGRECORD(ndr, NDR_SCALARS, &r->records[cntr_records_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_records_0, 0);
		NDR_CHECK(ndr_pull_EVENTLOGEOF(ndr, NDR_SCALARS, &r->eof));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_records_0 = r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber;
		_mem_save_records_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->records, 0);
		for (cntr_records_0 = 0; cntr_records_0 < size_records_0; cntr_records_0++) {
			NDR_CHECK(ndr_pull_EVENTLOGRECORD(ndr, NDR_BUFFERS, &r->records[cntr_records_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_records_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOG_EVT_FILE(struct ndr_print *ndr, const char *name, const struct EVENTLOG_EVT_FILE *r)
{
	uint32_t cntr_records_0;
	ndr_print_struct(ndr, name, "EVENTLOG_EVT_FILE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_EVENTLOGHEADER(ndr, "hdr", &r->hdr);
	ndr->print(ndr, "%s: ARRAY(%d)", "records", (int)r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber);
	ndr->depth++;
	for (cntr_records_0=0;cntr_records_0<r->hdr.CurrentRecordNumber - r->hdr.OldestRecordNumber;cntr_records_0++) {
		ndr_print_EVENTLOGRECORD(ndr, "records", &r->records[cntr_records_0]);
	}
	ndr->depth--;
	ndr_print_EVENTLOGEOF(ndr, "eof", &r->eof);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_EVENTLOG_FULL_INFORMATION(struct ndr_push *ndr, int ndr_flags, const struct EVENTLOG_FULL_INFORMATION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->full));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_EVENTLOG_FULL_INFORMATION(struct ndr_pull *ndr, int ndr_flags, struct EVENTLOG_FULL_INFORMATION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->full));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EVENTLOG_FULL_INFORMATION(struct ndr_print *ndr, const char *name, const struct EVENTLOG_FULL_INFORMATION *r)
{
	ndr_print_struct(ndr, name, "EVENTLOG_FULL_INFORMATION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "full", r->full);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ClearEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_ClearEventLogW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.backupfile));
		if (r->in.backupfile) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backupfile));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ClearEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_ClearEventLogW *r)
{
	uint32_t _ptr_backupfile;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_backupfile_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_backupfile));
		if (_ptr_backupfile) {
			NDR_PULL_ALLOC(ndr, r->in.backupfile);
		} else {
			r->in.backupfile = NULL;
		}
		if (r->in.backupfile) {
			_mem_save_backupfile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.backupfile, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backupfile));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_backupfile_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ClearEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ClearEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_ClearEventLogW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ClearEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "backupfile", r->in.backupfile);
		ndr->depth++;
		if (r->in.backupfile) {
			ndr_print_lsa_String(ndr, "backupfile", r->in.backupfile);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ClearEventLogW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_BackupEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_BackupEventLogW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		if (r->in.backup_filename == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backup_filename));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_BackupEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_BackupEventLogW *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_backup_filename_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.backup_filename);
		}
		_mem_save_backup_filename_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.backup_filename, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backup_filename));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_backup_filename_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_BackupEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_BackupEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_BackupEventLogW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_BackupEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "backup_filename", r->in.backup_filename);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "backup_filename", r->in.backup_filename);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_BackupEventLogW");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_CloseEventLog(struct ndr_push *ndr, int flags, const struct eventlog_CloseEventLog *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_CloseEventLog(struct ndr_pull *ndr, int flags, struct eventlog_CloseEventLog *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_CloseEventLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_CloseEventLog *r)
{
	ndr_print_struct(ndr, name, "eventlog_CloseEventLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_CloseEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_CloseEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_DeregisterEventSource(struct ndr_push *ndr, int flags, const struct eventlog_DeregisterEventSource *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_DeregisterEventSource(struct ndr_pull *ndr, int flags, struct eventlog_DeregisterEventSource *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_DeregisterEventSource(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_DeregisterEventSource *r)
{
	ndr_print_struct(ndr, name, "eventlog_DeregisterEventSource");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_DeregisterEventSource");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_DeregisterEventSource");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetNumRecords(struct ndr_push *ndr, int flags, const struct eventlog_GetNumRecords *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.number == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.number));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetNumRecords(struct ndr_pull *ndr, int flags, struct eventlog_GetNumRecords *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_number_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.number);
		ZERO_STRUCTP(r->out.number);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.number);
		}
		_mem_save_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.number, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.number));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_number_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetNumRecords(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetNumRecords *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetNumRecords");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetNumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetNumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "number", r->out.number);
		ndr->depth++;
		ndr_print_uint32(ndr, "number", *r->out.number);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetOldestRecord(struct ndr_push *ndr, int flags, const struct eventlog_GetOldestRecord *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.oldest_entry == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.oldest_entry));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetOldestRecord(struct ndr_pull *ndr, int flags, struct eventlog_GetOldestRecord *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_oldest_entry_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.oldest_entry);
		ZERO_STRUCTP(r->out.oldest_entry);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.oldest_entry);
		}
		_mem_save_oldest_entry_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.oldest_entry, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.oldest_entry));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_oldest_entry_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetOldestRecord(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetOldestRecord *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetOldestRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetOldestRecord");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetOldestRecord");
		ndr->depth++;
		ndr_print_ptr(ndr, "oldest_entry", r->out.oldest_entry);
		ndr->depth++;
		ndr_print_uint32(ndr, "oldest_entry", *r->out.oldest_entry);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ChangeNotify(struct ndr_push *ndr, int flags, const struct eventlog_ChangeNotify *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ChangeNotify(struct ndr_pull *ndr, int flags, struct eventlog_ChangeNotify *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ChangeNotify(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ChangeNotify *r)
{
	ndr_print_struct(ndr, name, "eventlog_ChangeNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ChangeNotify");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ChangeNotify");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_OpenEventLogW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown0));
		if (r->in.unknown0) {
			NDR_CHECK(ndr_push_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
		}
		if (r->in.logname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logname));
		if (r->in.servername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.major_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.minor_version));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_OpenEventLogW *r)
{
	uint32_t _ptr_unknown0;
	TALLOC_CTX *_mem_save_unknown0_0;
	TALLOC_CTX *_mem_save_logname_0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown0));
		if (_ptr_unknown0) {
			NDR_PULL_ALLOC(ndr, r->in.unknown0);
		} else {
			r->in.unknown0 = NULL;
		}
		if (r->in.unknown0) {
			_mem_save_unknown0_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown0, 0);
			NDR_CHECK(ndr_pull_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown0_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logname);
		}
		_mem_save_logname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logname));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logname_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		}
		_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.major_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.minor_version));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenEventLogW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown0", r->in.unknown0);
		ndr->depth++;
		if (r->in.unknown0) {
			ndr_print_eventlog_OpenUnknown0(ndr, "unknown0", r->in.unknown0);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "logname", r->in.logname);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "logname", r->in.logname);
		ndr->depth--;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "servername", r->in.servername);
		ndr->depth--;
		ndr_print_uint32(ndr, "major_version", r->in.major_version);
		ndr_print_uint32(ndr, "minor_version", r->in.minor_version);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterEventSourceW(struct ndr_push *ndr, int flags, const struct eventlog_RegisterEventSourceW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown0));
		if (r->in.unknown0) {
			NDR_CHECK(ndr_push_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
		}
		if (r->in.module_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.module_name));
		if (r->in.reg_module_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.reg_module_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.major_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.minor_version));
	}
	if (flags & NDR_OUT) {
		if (r->out.log_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.log_handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterEventSourceW(struct ndr_pull *ndr, int flags, struct eventlog_RegisterEventSourceW *r)
{
	uint32_t _ptr_unknown0;
	TALLOC_CTX *_mem_save_unknown0_0;
	TALLOC_CTX *_mem_save_module_name_0;
	TALLOC_CTX *_mem_save_reg_module_name_0;
	TALLOC_CTX *_mem_save_log_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown0));
		if (_ptr_unknown0) {
			NDR_PULL_ALLOC(ndr, r->in.unknown0);
		} else {
			r->in.unknown0 = NULL;
		}
		if (r->in.unknown0) {
			_mem_save_unknown0_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown0, 0);
			NDR_CHECK(ndr_pull_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown0_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.module_name);
		}
		_mem_save_module_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.module_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.module_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_module_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.reg_module_name);
		}
		_mem_save_reg_module_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.reg_module_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.reg_module_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reg_module_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.major_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.minor_version));
		NDR_PULL_ALLOC(ndr, r->out.log_handle);
		ZERO_STRUCTP(r->out.log_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.log_handle);
		}
		_mem_save_log_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.log_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.log_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_log_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterEventSourceW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterEventSourceW *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterEventSourceW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterEventSourceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown0", r->in.unknown0);
		ndr->depth++;
		if (r->in.unknown0) {
			ndr_print_eventlog_OpenUnknown0(ndr, "unknown0", r->in.unknown0);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "module_name", r->in.module_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "module_name", r->in.module_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "reg_module_name", r->in.reg_module_name);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "reg_module_name", r->in.reg_module_name);
		ndr->depth--;
		ndr_print_uint32(ndr, "major_version", r->in.major_version);
		ndr_print_uint32(ndr, "minor_version", r->in.minor_version);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterEventSourceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "log_handle", r->out.log_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "log_handle", r->out.log_handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenBackupEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_OpenBackupEventLogW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown0));
		if (r->in.unknown0) {
			NDR_CHECK(ndr_push_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
		}
		if (r->in.backup_logname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backup_logname));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.major_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.minor_version));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenBackupEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_OpenBackupEventLogW *r)
{
	uint32_t _ptr_unknown0;
	TALLOC_CTX *_mem_save_unknown0_0;
	TALLOC_CTX *_mem_save_backup_logname_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown0));
		if (_ptr_unknown0) {
			NDR_PULL_ALLOC(ndr, r->in.unknown0);
		} else {
			r->in.unknown0 = NULL;
		}
		if (r->in.unknown0) {
			_mem_save_unknown0_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown0, 0);
			NDR_CHECK(ndr_pull_eventlog_OpenUnknown0(ndr, NDR_SCALARS, r->in.unknown0));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown0_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.backup_logname);
		}
		_mem_save_backup_logname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.backup_logname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.backup_logname));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_backup_logname_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.major_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.minor_version));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenBackupEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenBackupEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenBackupEventLogW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenBackupEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown0", r->in.unknown0);
		ndr->depth++;
		if (r->in.unknown0) {
			ndr_print_eventlog_OpenUnknown0(ndr, "unknown0", r->in.unknown0);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "backup_logname", r->in.backup_logname);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "backup_logname", r->in.backup_logname);
		ndr->depth--;
		ndr_print_uint32(ndr, "major_version", r->in.major_version);
		ndr_print_uint32(ndr, "minor_version", r->in.minor_version);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenBackupEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReadEventLogW(struct ndr_push *ndr, int flags, const struct eventlog_ReadEventLogW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_eventlogReadFlags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.number_of_bytes));
	}
	if (flags & NDR_OUT) {
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.number_of_bytes));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data, r->in.number_of_bytes));
		if (r->out.sent_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sent_size));
		if (r->out.real_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.real_size));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReadEventLogW(struct ndr_pull *ndr, int flags, struct eventlog_ReadEventLogW *r)
{
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sent_size_0;
	TALLOC_CTX *_mem_save_real_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_eventlogReadFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.number_of_bytes));
		if (r->in.number_of_bytes > 0x7FFFF) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.data, r->in.number_of_bytes);
		memset(r->out.data, 0, (r->in.number_of_bytes) * sizeof(*r->out.data));
		NDR_PULL_ALLOC(ndr, r->out.sent_size);
		ZERO_STRUCTP(r->out.sent_size);
		NDR_PULL_ALLOC(ndr, r->out.real_size);
		ZERO_STRUCTP(r->out.real_size);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data));
		size_data_1 = ndr_get_array_size(ndr, &r->out.data);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.data, size_data_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data, size_data_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sent_size);
		}
		_mem_save_sent_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sent_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sent_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sent_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.real_size);
		}
		_mem_save_real_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.real_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.real_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_real_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.data, r->in.number_of_bytes));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReadEventLogW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReadEventLogW *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReadEventLogW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReadEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_eventlogReadFlags(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "offset", r->in.offset);
		ndr_print_uint32(ndr, "number_of_bytes", r->in.number_of_bytes);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReadEventLogW");
		ndr->depth++;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->out.data, r->in.number_of_bytes);
		ndr->depth--;
		ndr_print_ptr(ndr, "sent_size", r->out.sent_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "sent_size", *r->out.sent_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "real_size", r->out.real_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "real_size", *r->out.real_size);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReportEventW(struct ndr_push *ndr, int flags, const struct eventlog_ReportEventW *r)
{
	uint32_t cntr_strings_1;
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->in.timestamp));
		NDR_CHECK(ndr_push_eventlogEventTypes(ndr, NDR_SCALARS, r->in.event_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.event_category));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.event_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.num_of_strings));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_size));
		if (r->in.servername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user_sid));
		if (r->in.user_sid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.user_sid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.strings));
		if (r->in.strings) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_of_strings));
			for (cntr_strings_1 = 0; cntr_strings_1 < r->in.num_of_strings; cntr_strings_1++) {
			}
			for (cntr_strings_1 = 0; cntr_strings_1 < r->in.num_of_strings; cntr_strings_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.strings[cntr_strings_1]));
				if (r->in.strings[cntr_strings_1]) {
					NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.strings[cntr_strings_1]));
				}
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data));
		if (r->in.data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.data_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data, r->in.data_size));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.record_number));
		if (r->in.record_number) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.record_number));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.time_written));
		if (r->in.time_written) {
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, *r->in.time_written));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.record_number));
		if (r->out.record_number) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.record_number));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.time_written));
		if (r->out.time_written) {
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, *r->out.time_written));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReportEventW(struct ndr_pull *ndr, int flags, struct eventlog_ReportEventW *r)
{
	uint32_t _ptr_user_sid;
	uint32_t _ptr_strings;
	uint32_t size_strings_1 = 0;
	uint32_t cntr_strings_1;
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	uint32_t _ptr_record_number;
	uint32_t _ptr_time_written;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_user_sid_0;
	TALLOC_CTX *_mem_save_strings_0;
	TALLOC_CTX *_mem_save_strings_1;
	TALLOC_CTX *_mem_save_strings_2;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_record_number_0;
	TALLOC_CTX *_mem_save_time_written_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->in.timestamp));
		NDR_CHECK(ndr_pull_eventlogEventTypes(ndr, NDR_SCALARS, &r->in.event_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.event_category));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.event_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.num_of_strings));
		if (r->in.num_of_strings > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.data_size));
		if (r->in.data_size > 0x3FFFF) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		}
		_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_sid));
		if (_ptr_user_sid) {
			NDR_PULL_ALLOC(ndr, r->in.user_sid);
		} else {
			r->in.user_sid = NULL;
		}
		if (r->in.user_sid) {
			_mem_save_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_strings));
		if (_ptr_strings) {
			NDR_PULL_ALLOC(ndr, r->in.strings);
		} else {
			r->in.strings = NULL;
		}
		if (r->in.strings) {
			_mem_save_strings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.strings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.strings));
			size_strings_1 = ndr_get_array_size(ndr, &r->in.strings);
			NDR_PULL_ALLOC_N(ndr, r->in.strings, size_strings_1);
			_mem_save_strings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.strings, 0);
			for (cntr_strings_1 = 0; cntr_strings_1 < size_strings_1; cntr_strings_1++) {
			}
			for (cntr_strings_1 = 0; cntr_strings_1 < size_strings_1; cntr_strings_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_strings));
				if (_ptr_strings) {
					NDR_PULL_ALLOC(ndr, r->in.strings[cntr_strings_1]);
				} else {
					r->in.strings[cntr_strings_1] = NULL;
				}
				if (r->in.strings[cntr_strings_1]) {
					_mem_save_strings_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->in.strings[cntr_strings_1], 0);
					NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.strings[cntr_strings_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		} else {
			r->in.data = NULL;
		}
		if (r->in.data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data));
			size_data_1 = ndr_get_array_size(ndr, &r->in.data);
			NDR_PULL_ALLOC_N(ndr, r->in.data, size_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data, size_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_number));
		if (_ptr_record_number) {
			NDR_PULL_ALLOC(ndr, r->in.record_number);
		} else {
			r->in.record_number = NULL;
		}
		if (r->in.record_number) {
			_mem_save_record_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.record_number, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.record_number));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_number_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_time_written));
		if (_ptr_time_written) {
			NDR_PULL_ALLOC(ndr, r->in.time_written);
		} else {
			r->in.time_written = NULL;
		}
		if (r->in.time_written) {
			_mem_save_time_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.time_written, 0);
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, r->in.time_written));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_time_written_0, 0);
		}
		if (r->in.strings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.strings, r->in.num_of_strings));
		}
		if (r->in.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.data, r->in.data_size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_number));
		if (_ptr_record_number) {
			NDR_PULL_ALLOC(ndr, r->out.record_number);
		} else {
			r->out.record_number = NULL;
		}
		if (r->out.record_number) {
			_mem_save_record_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.record_number, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.record_number));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_number_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_time_written));
		if (_ptr_time_written) {
			NDR_PULL_ALLOC(ndr, r->out.time_written);
		} else {
			r->out.time_written = NULL;
		}
		if (r->out.time_written) {
			_mem_save_time_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.time_written, 0);
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, r->out.time_written));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_time_written_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReportEventW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReportEventW *r)
{
	uint32_t cntr_strings_1;
	ndr_print_struct(ndr, name, "eventlog_ReportEventW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReportEventW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_time_t(ndr, "timestamp", r->in.timestamp);
		ndr_print_eventlogEventTypes(ndr, "event_type", r->in.event_type);
		ndr_print_uint16(ndr, "event_category", r->in.event_category);
		ndr_print_uint32(ndr, "event_id", r->in.event_id);
		ndr_print_uint16(ndr, "num_of_strings", r->in.num_of_strings);
		ndr_print_uint32(ndr, "data_size", r->in.data_size);
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "servername", r->in.servername);
		ndr->depth--;
		ndr_print_ptr(ndr, "user_sid", r->in.user_sid);
		ndr->depth++;
		if (r->in.user_sid) {
			ndr_print_dom_sid(ndr, "user_sid", r->in.user_sid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "strings", r->in.strings);
		ndr->depth++;
		if (r->in.strings) {
			ndr->print(ndr, "%s: ARRAY(%d)", "strings", (int)r->in.num_of_strings);
			ndr->depth++;
			for (cntr_strings_1=0;cntr_strings_1<r->in.num_of_strings;cntr_strings_1++) {
				ndr_print_ptr(ndr, "strings", r->in.strings[cntr_strings_1]);
				ndr->depth++;
				if (r->in.strings[cntr_strings_1]) {
					ndr_print_lsa_String(ndr, "strings", r->in.strings[cntr_strings_1]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		if (r->in.data) {
			ndr_print_array_uint8(ndr, "data", r->in.data, r->in.data_size);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "record_number", r->in.record_number);
		ndr->depth++;
		if (r->in.record_number) {
			ndr_print_uint32(ndr, "record_number", *r->in.record_number);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "time_written", r->in.time_written);
		ndr->depth++;
		if (r->in.time_written) {
			ndr_print_time_t(ndr, "time_written", *r->in.time_written);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReportEventW");
		ndr->depth++;
		ndr_print_ptr(ndr, "record_number", r->out.record_number);
		ndr->depth++;
		if (r->out.record_number) {
			ndr_print_uint32(ndr, "record_number", *r->out.record_number);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "time_written", r->out.time_written);
		ndr->depth++;
		if (r->out.time_written) {
			ndr_print_time_t(ndr, "time_written", *r->out.time_written);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ClearEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_ClearEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ClearEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_ClearEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ClearEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ClearEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ClearEventLogA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ClearEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ClearEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_BackupEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_BackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_BackupEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_BackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_BackupEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_BackupEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_BackupEventLogA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_BackupEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_BackupEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_OpenEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_OpenEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenEventLogA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterEventSourceA(struct ndr_push *ndr, int flags, const struct eventlog_RegisterEventSourceA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterEventSourceA(struct ndr_pull *ndr, int flags, struct eventlog_RegisterEventSourceA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterEventSourceA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterEventSourceA *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterEventSourceA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterEventSourceA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterEventSourceA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_OpenBackupEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_OpenBackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_OpenBackupEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_OpenBackupEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_OpenBackupEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_OpenBackupEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_OpenBackupEventLogA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_OpenBackupEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_OpenBackupEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReadEventLogA(struct ndr_push *ndr, int flags, const struct eventlog_ReadEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReadEventLogA(struct ndr_pull *ndr, int flags, struct eventlog_ReadEventLogA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReadEventLogA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReadEventLogA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReadEventLogA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReadEventLogA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReadEventLogA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReportEventA(struct ndr_push *ndr, int flags, const struct eventlog_ReportEventA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReportEventA(struct ndr_pull *ndr, int flags, struct eventlog_ReportEventA *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReportEventA(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReportEventA *r)
{
	ndr_print_struct(ndr, name, "eventlog_ReportEventA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReportEventA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReportEventA");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_RegisterClusterSvc(struct ndr_push *ndr, int flags, const struct eventlog_RegisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_RegisterClusterSvc(struct ndr_pull *ndr, int flags, struct eventlog_RegisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_RegisterClusterSvc(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_RegisterClusterSvc *r)
{
	ndr_print_struct(ndr, name, "eventlog_RegisterClusterSvc");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_RegisterClusterSvc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_RegisterClusterSvc");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_DeregisterClusterSvc(struct ndr_push *ndr, int flags, const struct eventlog_DeregisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_DeregisterClusterSvc(struct ndr_pull *ndr, int flags, struct eventlog_DeregisterClusterSvc *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_DeregisterClusterSvc(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_DeregisterClusterSvc *r)
{
	ndr_print_struct(ndr, name, "eventlog_DeregisterClusterSvc");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_DeregisterClusterSvc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_DeregisterClusterSvc");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_WriteClusterEvents(struct ndr_push *ndr, int flags, const struct eventlog_WriteClusterEvents *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_WriteClusterEvents(struct ndr_pull *ndr, int flags, struct eventlog_WriteClusterEvents *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_WriteClusterEvents(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_WriteClusterEvents *r)
{
	ndr_print_struct(ndr, name, "eventlog_WriteClusterEvents");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_WriteClusterEvents");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_WriteClusterEvents");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_GetLogInformation(struct ndr_push *ndr, int flags, const struct eventlog_GetLogInformation *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_GetLogInformation(struct ndr_pull *ndr, int flags, struct eventlog_GetLogInformation *r)
{
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		if (r->in.buf_size > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.buf_size);
		memset(r->out.buffer, 0, (r->in.buf_size) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		size_buffer_1 = ndr_get_array_size(ndr, &r->out.buffer);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, r->in.buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_GetLogInformation(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_GetLogInformation *r)
{
	ndr_print_struct(ndr, name, "eventlog_GetLogInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_GetLogInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_GetLogInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.buf_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_FlushEventLog(struct ndr_push *ndr, int flags, const struct eventlog_FlushEventLog *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_FlushEventLog(struct ndr_pull *ndr, int flags, struct eventlog_FlushEventLog *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_FlushEventLog(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_FlushEventLog *r)
{
	ndr_print_struct(ndr, name, "eventlog_FlushEventLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_FlushEventLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_FlushEventLog");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_eventlog_ReportEventAndSourceW(struct ndr_push *ndr, int flags, const struct eventlog_ReportEventAndSourceW *r)
{
	uint32_t cntr_strings_1;
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->in.timestamp));
		NDR_CHECK(ndr_push_eventlogEventTypes(ndr, NDR_SCALARS, r->in.event_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.event_category));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.event_id));
		if (r->in.sourcename == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sourcename));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.num_of_strings));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_size));
		if (r->in.servername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.user_sid));
		if (r->in.user_sid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.user_sid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.strings));
		if (r->in.strings) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_of_strings));
			for (cntr_strings_1 = 0; cntr_strings_1 < r->in.num_of_strings; cntr_strings_1++) {
			}
			for (cntr_strings_1 = 0; cntr_strings_1 < r->in.num_of_strings; cntr_strings_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.strings[cntr_strings_1]));
				if (r->in.strings[cntr_strings_1]) {
					NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.strings[cntr_strings_1]));
				}
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data));
		if (r->in.data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.data_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data, r->in.data_size));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.record_number));
		if (r->in.record_number) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.record_number));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.time_written));
		if (r->in.time_written) {
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, *r->in.time_written));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.record_number));
		if (r->out.record_number) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.record_number));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.time_written));
		if (r->out.time_written) {
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, *r->out.time_written));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_eventlog_ReportEventAndSourceW(struct ndr_pull *ndr, int flags, struct eventlog_ReportEventAndSourceW *r)
{
	uint32_t _ptr_user_sid;
	uint32_t _ptr_strings;
	uint32_t size_strings_1 = 0;
	uint32_t cntr_strings_1;
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	uint32_t _ptr_record_number;
	uint32_t _ptr_time_written;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sourcename_0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_user_sid_0;
	TALLOC_CTX *_mem_save_strings_0;
	TALLOC_CTX *_mem_save_strings_1;
	TALLOC_CTX *_mem_save_strings_2;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_record_number_0;
	TALLOC_CTX *_mem_save_time_written_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->in.timestamp));
		NDR_CHECK(ndr_pull_eventlogEventTypes(ndr, NDR_SCALARS, &r->in.event_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.event_category));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.event_id));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sourcename);
		}
		_mem_save_sourcename_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sourcename, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sourcename));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sourcename_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.num_of_strings));
		if (r->in.num_of_strings > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.data_size));
		if (r->in.data_size > 0x3FFFF) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		}
		_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.servername));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_sid));
		if (_ptr_user_sid) {
			NDR_PULL_ALLOC(ndr, r->in.user_sid);
		} else {
			r->in.user_sid = NULL;
		}
		if (r->in.user_sid) {
			_mem_save_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.user_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_strings));
		if (_ptr_strings) {
			NDR_PULL_ALLOC(ndr, r->in.strings);
		} else {
			r->in.strings = NULL;
		}
		if (r->in.strings) {
			_mem_save_strings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.strings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.strings));
			size_strings_1 = ndr_get_array_size(ndr, &r->in.strings);
			NDR_PULL_ALLOC_N(ndr, r->in.strings, size_strings_1);
			_mem_save_strings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.strings, 0);
			for (cntr_strings_1 = 0; cntr_strings_1 < size_strings_1; cntr_strings_1++) {
			}
			for (cntr_strings_1 = 0; cntr_strings_1 < size_strings_1; cntr_strings_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_strings));
				if (_ptr_strings) {
					NDR_PULL_ALLOC(ndr, r->in.strings[cntr_strings_1]);
				} else {
					r->in.strings[cntr_strings_1] = NULL;
				}
				if (r->in.strings[cntr_strings_1]) {
					_mem_save_strings_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->in.strings[cntr_strings_1], 0);
					NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.strings[cntr_strings_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_strings_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		} else {
			r->in.data = NULL;
		}
		if (r->in.data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data));
			size_data_1 = ndr_get_array_size(ndr, &r->in.data);
			NDR_PULL_ALLOC_N(ndr, r->in.data, size_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data, size_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_number));
		if (_ptr_record_number) {
			NDR_PULL_ALLOC(ndr, r->in.record_number);
		} else {
			r->in.record_number = NULL;
		}
		if (r->in.record_number) {
			_mem_save_record_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.record_number, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.record_number));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_number_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_time_written));
		if (_ptr_time_written) {
			NDR_PULL_ALLOC(ndr, r->in.time_written);
		} else {
			r->in.time_written = NULL;
		}
		if (r->in.time_written) {
			_mem_save_time_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.time_written, 0);
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, r->in.time_written));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_time_written_0, 0);
		}
		if (r->in.strings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.strings, r->in.num_of_strings));
		}
		if (r->in.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.data, r->in.data_size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_record_number));
		if (_ptr_record_number) {
			NDR_PULL_ALLOC(ndr, r->out.record_number);
		} else {
			r->out.record_number = NULL;
		}
		if (r->out.record_number) {
			_mem_save_record_number_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.record_number, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.record_number));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_record_number_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_time_written));
		if (_ptr_time_written) {
			NDR_PULL_ALLOC(ndr, r->out.time_written);
		} else {
			r->out.time_written = NULL;
		}
		if (r->out.time_written) {
			_mem_save_time_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.time_written, 0);
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, r->out.time_written));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_time_written_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_eventlog_ReportEventAndSourceW(struct ndr_print *ndr, const char *name, int flags, const struct eventlog_ReportEventAndSourceW *r)
{
	uint32_t cntr_strings_1;
	ndr_print_struct(ndr, name, "eventlog_ReportEventAndSourceW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "eventlog_ReportEventAndSourceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_time_t(ndr, "timestamp", r->in.timestamp);
		ndr_print_eventlogEventTypes(ndr, "event_type", r->in.event_type);
		ndr_print_uint16(ndr, "event_category", r->in.event_category);
		ndr_print_uint32(ndr, "event_id", r->in.event_id);
		ndr_print_ptr(ndr, "sourcename", r->in.sourcename);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "sourcename", r->in.sourcename);
		ndr->depth--;
		ndr_print_uint16(ndr, "num_of_strings", r->in.num_of_strings);
		ndr_print_uint32(ndr, "data_size", r->in.data_size);
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		ndr_print_lsa_String(ndr, "servername", r->in.servername);
		ndr->depth--;
		ndr_print_ptr(ndr, "user_sid", r->in.user_sid);
		ndr->depth++;
		if (r->in.user_sid) {
			ndr_print_dom_sid(ndr, "user_sid", r->in.user_sid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "strings", r->in.strings);
		ndr->depth++;
		if (r->in.strings) {
			ndr->print(ndr, "%s: ARRAY(%d)", "strings", (int)r->in.num_of_strings);
			ndr->depth++;
			for (cntr_strings_1=0;cntr_strings_1<r->in.num_of_strings;cntr_strings_1++) {
				ndr_print_ptr(ndr, "strings", r->in.strings[cntr_strings_1]);
				ndr->depth++;
				if (r->in.strings[cntr_strings_1]) {
					ndr_print_lsa_String(ndr, "strings", r->in.strings[cntr_strings_1]);
				}
				ndr->depth--;
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		if (r->in.data) {
			ndr_print_array_uint8(ndr, "data", r->in.data, r->in.data_size);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "record_number", r->in.record_number);
		ndr->depth++;
		if (r->in.record_number) {
			ndr_print_uint32(ndr, "record_number", *r->in.record_number);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "time_written", r->in.time_written);
		ndr->depth++;
		if (r->in.time_written) {
			ndr_print_time_t(ndr, "time_written", *r->in.time_written);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "eventlog_ReportEventAndSourceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "record_number", r->out.record_number);
		ndr->depth++;
		if (r->out.record_number) {
			ndr_print_uint32(ndr, "record_number", *r->out.record_number);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "time_written", r->out.time_written);
		ndr->depth++;
		if (r->out.time_written) {
			ndr_print_time_t(ndr, "time_written", *r->out.time_written);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call eventlog_calls[] = {
	{
		"eventlog_ClearEventLogW",
		sizeof(struct eventlog_ClearEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ClearEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ClearEventLogW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_BackupEventLogW",
		sizeof(struct eventlog_BackupEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_BackupEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_BackupEventLogW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_CloseEventLog",
		sizeof(struct eventlog_CloseEventLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog_CloseEventLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_CloseEventLog,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_DeregisterEventSource",
		sizeof(struct eventlog_DeregisterEventSource),
		(ndr_push_flags_fn_t) ndr_push_eventlog_DeregisterEventSource,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_DeregisterEventSource,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_GetNumRecords",
		sizeof(struct eventlog_GetNumRecords),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetNumRecords,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetNumRecords,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_GetOldestRecord",
		sizeof(struct eventlog_GetOldestRecord),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetOldestRecord,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetOldestRecord,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ChangeNotify",
		sizeof(struct eventlog_ChangeNotify),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ChangeNotify,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ChangeNotify,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_OpenEventLogW",
		sizeof(struct eventlog_OpenEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenEventLogW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_RegisterEventSourceW",
		sizeof(struct eventlog_RegisterEventSourceW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterEventSourceW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterEventSourceW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_OpenBackupEventLogW",
		sizeof(struct eventlog_OpenBackupEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenBackupEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenBackupEventLogW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ReadEventLogW",
		sizeof(struct eventlog_ReadEventLogW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReadEventLogW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReadEventLogW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ReportEventW",
		sizeof(struct eventlog_ReportEventW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReportEventW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReportEventW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ClearEventLogA",
		sizeof(struct eventlog_ClearEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ClearEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ClearEventLogA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_BackupEventLogA",
		sizeof(struct eventlog_BackupEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_BackupEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_BackupEventLogA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_OpenEventLogA",
		sizeof(struct eventlog_OpenEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenEventLogA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_RegisterEventSourceA",
		sizeof(struct eventlog_RegisterEventSourceA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterEventSourceA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterEventSourceA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_OpenBackupEventLogA",
		sizeof(struct eventlog_OpenBackupEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_OpenBackupEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_OpenBackupEventLogA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ReadEventLogA",
		sizeof(struct eventlog_ReadEventLogA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReadEventLogA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReadEventLogA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ReportEventA",
		sizeof(struct eventlog_ReportEventA),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReportEventA,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReportEventA,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_RegisterClusterSvc",
		sizeof(struct eventlog_RegisterClusterSvc),
		(ndr_push_flags_fn_t) ndr_push_eventlog_RegisterClusterSvc,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_RegisterClusterSvc,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_DeregisterClusterSvc",
		sizeof(struct eventlog_DeregisterClusterSvc),
		(ndr_push_flags_fn_t) ndr_push_eventlog_DeregisterClusterSvc,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_DeregisterClusterSvc,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_WriteClusterEvents",
		sizeof(struct eventlog_WriteClusterEvents),
		(ndr_push_flags_fn_t) ndr_push_eventlog_WriteClusterEvents,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_WriteClusterEvents,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_GetLogInformation",
		sizeof(struct eventlog_GetLogInformation),
		(ndr_push_flags_fn_t) ndr_push_eventlog_GetLogInformation,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_GetLogInformation,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_FlushEventLog",
		sizeof(struct eventlog_FlushEventLog),
		(ndr_push_flags_fn_t) ndr_push_eventlog_FlushEventLog,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_FlushEventLog,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"eventlog_ReportEventAndSourceW",
		sizeof(struct eventlog_ReportEventAndSourceW),
		(ndr_push_flags_fn_t) ndr_push_eventlog_ReportEventAndSourceW,
		(ndr_pull_flags_fn_t) ndr_pull_eventlog_ReportEventAndSourceW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const eventlog_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\eventlog]", 
};

static const struct ndr_interface_string_array eventlog_endpoints = {
	.count	= 1,
	.names	= eventlog_endpoint_strings
};

static const char * const eventlog_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array eventlog_authservices = {
	.count	= 1,
	.names	= eventlog_authservice_strings
};


const struct ndr_interface_table ndr_table_eventlog = {
	.name		= "eventlog",
	.syntax_id	= {
		{0x82273fdc,0xe32a,0x18c3,{0x3f,0x78},{0x82,0x79,0x29,0xdc,0x23,0xea}},
		NDR_EVENTLOG_VERSION
	},
	.helpstring	= NDR_EVENTLOG_HELPSTRING,
	.num_calls	= 25,
	.calls		= eventlog_calls,
	.endpoints	= &eventlog_endpoints,
	.authservices	= &eventlog_authservices
};

