/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_netlogon.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_netr_UasInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_UasInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->account_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priv));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bad_pw_count));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->logoff_time));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->kickoff_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->password_age));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->pw_can_change));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->pw_must_change));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer, ndr_charset_length(r->computer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->script_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->script_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->script_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->script_path, ndr_charset_length(r->script_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_UasInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_UasInfo *r)
{
	uint32_t _ptr_account_name;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	TALLOC_CTX *_mem_save_account_name_0;
	uint32_t _ptr_computer;
	uint32_t size_computer_1 = 0;
	uint32_t length_computer_1 = 0;
	TALLOC_CTX *_mem_save_computer_0;
	uint32_t _ptr_domain;
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	TALLOC_CTX *_mem_save_domain_0;
	uint32_t _ptr_script_path;
	uint32_t size_script_path_1 = 0;
	uint32_t length_script_path_1 = 0;
	TALLOC_CTX *_mem_save_script_path_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->account_name);
		} else {
			r->account_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priv));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bad_pw_count));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->logoff_time));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->kickoff_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->password_age));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->pw_can_change));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->pw_must_change));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer));
		if (_ptr_computer) {
			NDR_PULL_ALLOC(ndr, r->computer);
		} else {
			r->computer = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_script_path));
		if (_ptr_script_path) {
			NDR_PULL_ALLOC(ndr, r->script_path);
		} else {
			r->script_path = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->account_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
			size_account_name_1 = ndr_get_array_size(ndr, &r->account_name);
			length_account_name_1 = ndr_get_array_length(ndr, &r->account_name);
			if (length_account_name_1 > size_account_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		if (r->computer) {
			_mem_save_computer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer));
			size_computer_1 = ndr_get_array_size(ndr, &r->computer);
			length_computer_1 = ndr_get_array_length(ndr, &r->computer);
			if (length_computer_1 > size_computer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_1, length_computer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer, length_computer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
			size_domain_1 = ndr_get_array_size(ndr, &r->domain);
			length_domain_1 = ndr_get_array_length(ndr, &r->domain);
			if (length_domain_1 > size_domain_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->script_path) {
			_mem_save_script_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->script_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->script_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->script_path));
			size_script_path_1 = ndr_get_array_size(ndr, &r->script_path);
			length_script_path_1 = ndr_get_array_length(ndr, &r->script_path);
			if (length_script_path_1 > size_script_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_script_path_1, length_script_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_script_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->script_path, length_script_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_script_path_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_UasInfo(struct ndr_print *ndr, const char *name, const struct netr_UasInfo *r)
{
	ndr_print_struct(ndr, name, "netr_UasInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "account_name", r->account_name);
	ndr->depth++;
	if (r->account_name) {
		ndr_print_string(ndr, "account_name", r->account_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "priv", r->priv);
	ndr_print_uint32(ndr, "auth_flags", r->auth_flags);
	ndr_print_uint32(ndr, "logon_count", r->logon_count);
	ndr_print_uint32(ndr, "bad_pw_count", r->bad_pw_count);
	ndr_print_time_t(ndr, "last_logon", r->last_logon);
	ndr_print_time_t(ndr, "last_logoff", r->last_logoff);
	ndr_print_time_t(ndr, "logoff_time", r->logoff_time);
	ndr_print_time_t(ndr, "kickoff_time", r->kickoff_time);
	ndr_print_uint32(ndr, "password_age", r->password_age);
	ndr_print_time_t(ndr, "pw_can_change", r->pw_can_change);
	ndr_print_time_t(ndr, "pw_must_change", r->pw_must_change);
	ndr_print_ptr(ndr, "computer", r->computer);
	ndr->depth++;
	if (r->computer) {
		ndr_print_string(ndr, "computer", r->computer);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_string(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "script_path", r->script_path);
	ndr->depth++;
	if (r->script_path) {
		ndr_print_string(ndr, "script_path", r->script_path);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_UasLogoffInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_UasLogoffInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->duration));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_UasLogoffInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_UasLogoffInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->duration));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_UasLogoffInfo(struct ndr_print *ndr, const char *name, const struct netr_UasLogoffInfo *r)
{
	ndr_print_struct(ndr, name, "netr_UasLogoffInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "duration", r->duration);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_AcctLockStr(struct ndr_push *ndr, int ndr_flags, const struct netr_AcctLockStr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->lockout_duration));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->reset_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bad_attempt_lockout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_AcctLockStr(struct ndr_pull *ndr, int ndr_flags, struct netr_AcctLockStr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->lockout_duration));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->reset_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bad_attempt_lockout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_AcctLockStr(struct ndr_print *ndr, const char *name, const struct netr_AcctLockStr *r)
{
	ndr_print_struct(ndr, name, "netr_AcctLockStr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dlong(ndr, "lockout_duration", r->lockout_duration);
	ndr_print_udlong(ndr, "reset_count", r->reset_count);
	ndr_print_uint32(ndr, "bad_attempt_lockout", r->bad_attempt_lockout);
	ndr_print_uint32(ndr, "dummy", r->dummy);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_LogonParameterControl(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_LogonParameterControl(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonParameterControl(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_CLEARTEXT_PASSWORD_ALLOWED", MSV1_0_CLEARTEXT_PASSWORD_ALLOWED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_UPDATE_LOGON_STATISTICS", MSV1_0_UPDATE_LOGON_STATISTICS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_RETURN_USER_PARAMETERS", MSV1_0_RETURN_USER_PARAMETERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_DONT_TRY_GUEST_ACCOUNT", MSV1_0_DONT_TRY_GUEST_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT", MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_RETURN_PASSWORD_EXPIRY", MSV1_0_RETURN_PASSWORD_EXPIRY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_USE_CLIENT_CHALLENGE", MSV1_0_USE_CLIENT_CHALLENGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_TRY_GUEST_ACCOUNT_ONLY", MSV1_0_TRY_GUEST_ACCOUNT_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_RETURN_PROFILE_PATH", MSV1_0_RETURN_PROFILE_PATH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY", MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT", MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_DISABLE_PERSONAL_FALLBACK", MSV1_0_DISABLE_PERSONAL_FALLBACK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_ALLOW_FORCE_GUEST", MSV1_0_ALLOW_FORCE_GUEST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED", MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY", MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_ALLOW_MSVCHAPV2", MSV1_0_ALLOW_MSVCHAPV2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_S4U2SELF", MSV1_0_S4U2SELF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_CHECK_LOGONHOURS_FOR_S4U", MSV1_0_CHECK_LOGONHOURS_FOR_S4U, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "MSV1_0_SUBAUTHENTICATION_DLL_EX", MSV1_0_SUBAUTHENTICATION_DLL_EX, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_IdentityInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_IdentityInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_netr_LogonParameterControl(ndr, NDR_SCALARS, r->parameter_control));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logon_id_low));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logon_id_high));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstation));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstation));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_IdentityInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_IdentityInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_netr_LogonParameterControl(ndr, NDR_SCALARS, &r->parameter_control));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logon_id_low));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logon_id_high));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstation));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstation));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_IdentityInfo(struct ndr_print *ndr, const char *name, const struct netr_IdentityInfo *r)
{
	ndr_print_struct(ndr, name, "netr_IdentityInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "domain_name", &r->domain_name);
	ndr_print_netr_LogonParameterControl(ndr, "parameter_control", r->parameter_control);
	ndr_print_uint32(ndr, "logon_id_low", r->logon_id_low);
	ndr_print_uint32(ndr, "logon_id_high", r->logon_id_high);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "workstation", &r->workstation);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_PasswordInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_PasswordInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_PasswordInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_PasswordInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_PasswordInfo(struct ndr_print *ndr, const char *name, const struct netr_PasswordInfo *r)
{
	ndr_print_struct(ndr, name, "netr_PasswordInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_IdentityInfo(ndr, "identity_info", &r->identity_info);
	ndr_print_samr_Password(ndr, "lmpassword", &r->lmpassword);
	ndr_print_samr_Password(ndr, "ntpassword", &r->ntpassword);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ChallengeResponse(struct ndr_push *ndr, int ndr_flags, const struct netr_ChallengeResponse *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ChallengeResponse(struct ndr_pull *ndr, int ndr_flags, struct netr_ChallengeResponse *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	uint32_t length_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->data));
				size_data_1 = ndr_get_array_size(ndr, &r->data);
				length_data_1 = ndr_get_array_length(ndr, &r->data);
				if (length_data_1 > size_data_1) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_data_1, length_data_1);
				}
				NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, length_data_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ChallengeResponse(struct ndr_print *ndr, const char *name, const struct netr_ChallengeResponse *r)
{
	ndr_print_struct(ndr, name, "netr_ChallengeResponse");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint16(ndr, "length", r->length);
		ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->length:r->size);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->length);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_netr_NetworkInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_NetworkInfo *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->challenge, 8));
			NDR_CHECK(ndr_push_netr_ChallengeResponse(ndr, NDR_SCALARS, &r->nt));
			NDR_CHECK(ndr_push_netr_ChallengeResponse(ndr, NDR_SCALARS, &r->lm));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
			NDR_CHECK(ndr_push_netr_ChallengeResponse(ndr, NDR_BUFFERS, &r->nt));
			NDR_CHECK(ndr_push_netr_ChallengeResponse(ndr, NDR_BUFFERS, &r->lm));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NetworkInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_NetworkInfo *r)
{
	uint32_t size_challenge_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
			size_challenge_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->challenge, size_challenge_0));
			NDR_CHECK(ndr_pull_netr_ChallengeResponse(ndr, NDR_SCALARS, &r->nt));
			NDR_CHECK(ndr_pull_netr_ChallengeResponse(ndr, NDR_SCALARS, &r->lm));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
			NDR_CHECK(ndr_pull_netr_ChallengeResponse(ndr, NDR_BUFFERS, &r->nt));
			NDR_CHECK(ndr_pull_netr_ChallengeResponse(ndr, NDR_BUFFERS, &r->lm));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NetworkInfo(struct ndr_print *ndr, const char *name, const struct netr_NetworkInfo *r)
{
	ndr_print_struct(ndr, name, "netr_NetworkInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_netr_IdentityInfo(ndr, "identity_info", &r->identity_info);
		ndr_print_array_uint8(ndr, "challenge", r->challenge, 8);
		ndr_print_netr_ChallengeResponse(ndr, "nt", &r->nt);
		ndr_print_netr_ChallengeResponse(ndr, "lm", &r->lm);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_netr_GenericInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_GenericInfo *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->package_name));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->package_name));
			if (r->data) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_GenericInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_GenericInfo *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_SCALARS, &r->identity_info));
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->package_name));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_netr_IdentityInfo(ndr, NDR_BUFFERS, &r->identity_info));
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->package_name));
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				size_data_1 = ndr_get_array_size(ndr, &r->data);
				NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_GenericInfo(struct ndr_print *ndr, const char *name, const struct netr_GenericInfo *r)
{
	ndr_print_struct(ndr, name, "netr_GenericInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_netr_IdentityInfo(ndr, "identity_info", &r->identity_info);
		ndr_print_lsa_String(ndr, "package_name", &r->package_name);
		ndr_print_uint32(ndr, "length", r->length);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->length);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_netr_LogonInfoClass(struct ndr_push *ndr, int ndr_flags, enum netr_LogonInfoClass r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonInfoClass(struct ndr_pull *ndr, int ndr_flags, enum netr_LogonInfoClass *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonInfoClass(struct ndr_print *ndr, const char *name, enum netr_LogonInfoClass r)
{
	const char *val = NULL;

	switch (r) {
		case NetlogonInteractiveInformation: val = "NetlogonInteractiveInformation"; break;
		case NetlogonNetworkInformation: val = "NetlogonNetworkInformation"; break;
		case NetlogonServiceInformation: val = "NetlogonServiceInformation"; break;
		case NetlogonGenericInformation: val = "NetlogonGenericInformation"; break;
		case NetlogonInteractiveTransitiveInformation: val = "NetlogonInteractiveTransitiveInformation"; break;
		case NetlogonNetworkTransitiveInformation: val = "NetlogonNetworkTransitiveInformation"; break;
		case NetlogonServiceTransitiveInformation: val = "NetlogonServiceTransitiveInformation"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_LogonLevel(struct ndr_push *ndr, int ndr_flags, const union netr_LogonLevel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_LogonInfoClass(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case NetlogonInteractiveInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
			break; }

			case NetlogonNetworkInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->network));
			break; }

			case NetlogonServiceInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
			break; }

			case NetlogonGenericInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->generic));
			break; }

			case NetlogonInteractiveTransitiveInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
			break; }

			case NetlogonNetworkTransitiveInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->network));
			break; }

			case NetlogonServiceTransitiveInformation: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NetlogonInteractiveInformation:
				if (r->password) {
					NDR_CHECK(ndr_push_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
				}
			break;

			case NetlogonNetworkInformation:
				if (r->network) {
					NDR_CHECK(ndr_push_netr_NetworkInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->network));
				}
			break;

			case NetlogonServiceInformation:
				if (r->password) {
					NDR_CHECK(ndr_push_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
				}
			break;

			case NetlogonGenericInformation:
				if (r->generic) {
					NDR_CHECK(ndr_push_netr_GenericInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->generic));
				}
			break;

			case NetlogonInteractiveTransitiveInformation:
				if (r->password) {
					NDR_CHECK(ndr_push_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
				}
			break;

			case NetlogonNetworkTransitiveInformation:
				if (r->network) {
					NDR_CHECK(ndr_push_netr_NetworkInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->network));
				}
			break;

			case NetlogonServiceTransitiveInformation:
				if (r->password) {
					NDR_CHECK(ndr_push_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_LogonLevel(struct ndr_pull *ndr, int ndr_flags, union netr_LogonLevel *r)
{
	uint32_t level;
	uint16_t _level;
	TALLOC_CTX *_mem_save_password_0;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_network_0;
	uint32_t _ptr_network;
	TALLOC_CTX *_mem_save_generic_0;
	uint32_t _ptr_generic;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case NetlogonInteractiveInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
				if (_ptr_password) {
					NDR_PULL_ALLOC(ndr, r->password);
				} else {
					r->password = NULL;
				}
			break; }

			case NetlogonNetworkInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_network));
				if (_ptr_network) {
					NDR_PULL_ALLOC(ndr, r->network);
				} else {
					r->network = NULL;
				}
			break; }

			case NetlogonServiceInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
				if (_ptr_password) {
					NDR_PULL_ALLOC(ndr, r->password);
				} else {
					r->password = NULL;
				}
			break; }

			case NetlogonGenericInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_generic));
				if (_ptr_generic) {
					NDR_PULL_ALLOC(ndr, r->generic);
				} else {
					r->generic = NULL;
				}
			break; }

			case NetlogonInteractiveTransitiveInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
				if (_ptr_password) {
					NDR_PULL_ALLOC(ndr, r->password);
				} else {
					r->password = NULL;
				}
			break; }

			case NetlogonNetworkTransitiveInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_network));
				if (_ptr_network) {
					NDR_PULL_ALLOC(ndr, r->network);
				} else {
					r->network = NULL;
				}
			break; }

			case NetlogonServiceTransitiveInformation: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
				if (_ptr_password) {
					NDR_PULL_ALLOC(ndr, r->password);
				} else {
					r->password = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NetlogonInteractiveInformation:
				if (r->password) {
					_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
					NDR_CHECK(ndr_pull_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
				}
			break;

			case NetlogonNetworkInformation:
				if (r->network) {
					_mem_save_network_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->network, 0);
					NDR_CHECK(ndr_pull_netr_NetworkInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->network));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_network_0, 0);
				}
			break;

			case NetlogonServiceInformation:
				if (r->password) {
					_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
					NDR_CHECK(ndr_pull_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
				}
			break;

			case NetlogonGenericInformation:
				if (r->generic) {
					_mem_save_generic_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->generic, 0);
					NDR_CHECK(ndr_pull_netr_GenericInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->generic));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_generic_0, 0);
				}
			break;

			case NetlogonInteractiveTransitiveInformation:
				if (r->password) {
					_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
					NDR_CHECK(ndr_pull_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
				}
			break;

			case NetlogonNetworkTransitiveInformation:
				if (r->network) {
					_mem_save_network_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->network, 0);
					NDR_CHECK(ndr_pull_netr_NetworkInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->network));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_network_0, 0);
				}
			break;

			case NetlogonServiceTransitiveInformation:
				if (r->password) {
					_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
					NDR_CHECK(ndr_pull_netr_PasswordInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->password));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonLevel(struct ndr_print *ndr, const char *name, const union netr_LogonLevel *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_LogonLevel");
	switch (level) {
		case NetlogonInteractiveInformation:
			ndr_print_ptr(ndr, "password", r->password);
			ndr->depth++;
			if (r->password) {
				ndr_print_netr_PasswordInfo(ndr, "password", r->password);
			}
			ndr->depth--;
		break;

		case NetlogonNetworkInformation:
			ndr_print_ptr(ndr, "network", r->network);
			ndr->depth++;
			if (r->network) {
				ndr_print_netr_NetworkInfo(ndr, "network", r->network);
			}
			ndr->depth--;
		break;

		case NetlogonServiceInformation:
			ndr_print_ptr(ndr, "password", r->password);
			ndr->depth++;
			if (r->password) {
				ndr_print_netr_PasswordInfo(ndr, "password", r->password);
			}
			ndr->depth--;
		break;

		case NetlogonGenericInformation:
			ndr_print_ptr(ndr, "generic", r->generic);
			ndr->depth++;
			if (r->generic) {
				ndr_print_netr_GenericInfo(ndr, "generic", r->generic);
			}
			ndr->depth--;
		break;

		case NetlogonInteractiveTransitiveInformation:
			ndr_print_ptr(ndr, "password", r->password);
			ndr->depth++;
			if (r->password) {
				ndr_print_netr_PasswordInfo(ndr, "password", r->password);
			}
			ndr->depth--;
		break;

		case NetlogonNetworkTransitiveInformation:
			ndr_print_ptr(ndr, "network", r->network);
			ndr->depth++;
			if (r->network) {
				ndr_print_netr_NetworkInfo(ndr, "network", r->network);
			}
			ndr->depth--;
		break;

		case NetlogonServiceTransitiveInformation:
			ndr_print_ptr(ndr, "password", r->password);
			ndr->depth++;
			if (r->password) {
				ndr_print_netr_PasswordInfo(ndr, "password", r->password);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_UserSessionKey(struct ndr_push *ndr, int ndr_flags, const struct netr_UserSessionKey *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->key, 16));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_UserSessionKey(struct ndr_pull *ndr, int ndr_flags, struct netr_UserSessionKey *r)
{
	uint32_t size_key_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_key_0 = 16;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->key, size_key_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_UserSessionKey(struct ndr_print *ndr, const char *name, const struct netr_UserSessionKey *r)
{
	ndr_print_struct(ndr, name, "netr_UserSessionKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "key", r->key, 16);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_LMSessionKey(struct ndr_push *ndr, int ndr_flags, const struct netr_LMSessionKey *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->key, 8));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_LMSessionKey(struct ndr_pull *ndr, int ndr_flags, struct netr_LMSessionKey *r)
{
	uint32_t size_key_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_key_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->key, size_key_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LMSessionKey(struct ndr_print *ndr, const char *name, const struct netr_LMSessionKey *r)
{
	ndr_print_struct(ndr, name, "netr_LMSessionKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "key", r->key, 8);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_UserFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_UserFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_UserFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_GUEST", NETLOGON_GUEST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NOENCRYPTION", NETLOGON_NOENCRYPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_CACHED_ACCOUNT", NETLOGON_CACHED_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_USED_LM_PASSWORD", NETLOGON_USED_LM_PASSWORD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_EXTRA_SIDS", NETLOGON_EXTRA_SIDS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_SUBAUTH_SESSION_KEY", NETLOGON_SUBAUTH_SESSION_KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_SERVER_TRUST_ACCOUNT", NETLOGON_SERVER_TRUST_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NTLMV2_ENABLED", NETLOGON_NTLMV2_ENABLED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_RESOURCE_GROUPS", NETLOGON_RESOURCE_GROUPS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_PROFILE_PATH_RETURNED", NETLOGON_PROFILE_PATH_RETURNED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_GRACE_LOGON", NETLOGON_GRACE_LOGON, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_SamBaseInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_SamBaseInfo *r)
{
	uint32_t cntr_unknown_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->allow_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_password_change));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_push_netr_UserFlags(ndr, NDR_SCALARS, r->user_flags));
		NDR_CHECK(ndr_push_netr_UserSessionKey(ndr, NDR_SCALARS, &r->key));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->logon_server));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_sid));
		NDR_CHECK(ndr_push_netr_LMSessionKey(ndr, NDR_SCALARS, &r->LMSessKey));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		for (cntr_unknown_0 = 0; cntr_unknown_0 < 7; cntr_unknown_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown[cntr_unknown_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->logon_server));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain));
		if (r->domain_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_SamBaseInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_SamBaseInfo *r)
{
	uint32_t _ptr_domain_sid;
	TALLOC_CTX *_mem_save_domain_sid_0;
	uint32_t size_unknown_0 = 0;
	uint32_t cntr_unknown_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->allow_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_password_change));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->groups));
		NDR_CHECK(ndr_pull_netr_UserFlags(ndr, NDR_SCALARS, &r->user_flags));
		NDR_CHECK(ndr_pull_netr_UserSessionKey(ndr, NDR_SCALARS, &r->key));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->logon_server));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->domain));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_sid));
		if (_ptr_domain_sid) {
			NDR_PULL_ALLOC(ndr, r->domain_sid);
		} else {
			r->domain_sid = NULL;
		}
		NDR_CHECK(ndr_pull_netr_LMSessionKey(ndr, NDR_SCALARS, &r->LMSessKey));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		size_unknown_0 = 7;
		for (cntr_unknown_0 = 0; cntr_unknown_0 < size_unknown_0; cntr_unknown_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown[cntr_unknown_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->groups));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->logon_server));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domain));
		if (r->domain_sid) {
			_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamBaseInfo(struct ndr_print *ndr, const char *name, const struct netr_SamBaseInfo *r)
{
	uint32_t cntr_unknown_0;
	ndr_print_struct(ndr, name, "netr_SamBaseInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "allow_password_change", r->allow_password_change);
	ndr_print_NTTIME(ndr, "force_password_change", r->force_password_change);
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_samr_RidWithAttributeArray(ndr, "groups", &r->groups);
	ndr_print_netr_UserFlags(ndr, "user_flags", r->user_flags);
	ndr_print_netr_UserSessionKey(ndr, "key", &r->key);
	ndr_print_lsa_StringLarge(ndr, "logon_server", &r->logon_server);
	ndr_print_lsa_StringLarge(ndr, "domain", &r->domain);
	ndr_print_ptr(ndr, "domain_sid", r->domain_sid);
	ndr->depth++;
	if (r->domain_sid) {
		ndr_print_dom_sid2(ndr, "domain_sid", r->domain_sid);
	}
	ndr->depth--;
	ndr_print_netr_LMSessionKey(ndr, "LMSessKey", &r->LMSessKey);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr->print(ndr, "%s: ARRAY(%d)", "unknown", (int)7);
	ndr->depth++;
	for (cntr_unknown_0=0;cntr_unknown_0<7;cntr_unknown_0++) {
		ndr_print_uint32(ndr, "unknown", r->unknown[cntr_unknown_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_SamInfo2(struct ndr_push *ndr, int ndr_flags, const struct netr_SamInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_SamInfo2(struct ndr_pull *ndr, int ndr_flags, struct netr_SamInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamInfo2(struct ndr_print *ndr, const char *name, const struct netr_SamInfo2 *r)
{
	ndr_print_struct(ndr, name, "netr_SamInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_SamBaseInfo(ndr, "base", &r->base);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_SidAttr(struct ndr_push *ndr, int ndr_flags, const struct netr_SidAttr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_samr_GroupAttrs(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_SidAttr(struct ndr_pull *ndr, int ndr_flags, struct netr_SidAttr *r)
{
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_samr_GroupAttrs(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SidAttr(struct ndr_print *ndr, const char *name, const struct netr_SidAttr *r)
{
	ndr_print_struct(ndr, name, "netr_SidAttr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_samr_GroupAttrs(ndr, "attributes", r->attributes);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_SamInfo3(struct ndr_push *ndr, int ndr_flags, const struct netr_SamInfo3 *r)
{
	uint32_t cntr_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sidcount));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->sidcount));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->sidcount; cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->sidcount; cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_SamInfo3(struct ndr_pull *ndr, int ndr_flags, struct netr_SamInfo3 *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sidcount));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			size_sids_1 = ndr_get_array_size(ndr, &r->sids);
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < size_sids_1; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < size_sids_1; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->sidcount));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamInfo3(struct ndr_print *ndr, const char *name, const struct netr_SamInfo3 *r)
{
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "netr_SamInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_SamBaseInfo(ndr, "base", &r->base);
	ndr_print_uint32(ndr, "sidcount", r->sidcount);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", (int)r->sidcount);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->sidcount;cntr_sids_1++) {
			ndr_print_netr_SidAttr(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_SamInfo6(struct ndr_push *ndr, int ndr_flags, const struct netr_SamInfo6 *r)
{
	uint32_t cntr_sids_1;
	uint32_t cntr_unknown4_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sidcount));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->dns_domainname));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->principle));
		for (cntr_unknown4_0 = 0; cntr_unknown4_0 < 20; cntr_unknown4_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4[cntr_unknown4_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->sidcount));
			for (cntr_sids_1 = 0; cntr_sids_1 < r->sidcount; cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < r->sidcount; cntr_sids_1++) {
				NDR_CHECK(ndr_push_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->dns_domainname));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->principle));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_SamInfo6(struct ndr_pull *ndr, int ndr_flags, struct netr_SamInfo6 *r)
{
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0;
	TALLOC_CTX *_mem_save_sids_1;
	uint32_t size_unknown4_0 = 0;
	uint32_t cntr_unknown4_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sidcount));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->dns_domainname));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->principle));
		size_unknown4_0 = 20;
		for (cntr_unknown4_0 = 0; cntr_unknown4_0 < size_unknown4_0; cntr_unknown4_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4[cntr_unknown4_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamBaseInfo(ndr, NDR_BUFFERS, &r->base));
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			size_sids_1 = ndr_get_array_size(ndr, &r->sids);
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < size_sids_1; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < size_sids_1; cntr_sids_1++) {
				NDR_CHECK(ndr_pull_netr_SidAttr(ndr, NDR_BUFFERS, &r->sids[cntr_sids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->dns_domainname));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->principle));
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->sidcount));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamInfo6(struct ndr_print *ndr, const char *name, const struct netr_SamInfo6 *r)
{
	uint32_t cntr_sids_1;
	uint32_t cntr_unknown4_0;
	ndr_print_struct(ndr, name, "netr_SamInfo6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_SamBaseInfo(ndr, "base", &r->base);
	ndr_print_uint32(ndr, "sidcount", r->sidcount);
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sids", (int)r->sidcount);
		ndr->depth++;
		for (cntr_sids_1=0;cntr_sids_1<r->sidcount;cntr_sids_1++) {
			ndr_print_netr_SidAttr(ndr, "sids", &r->sids[cntr_sids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_lsa_String(ndr, "dns_domainname", &r->dns_domainname);
	ndr_print_lsa_String(ndr, "principle", &r->principle);
	ndr->print(ndr, "%s: ARRAY(%d)", "unknown4", (int)20);
	ndr->depth++;
	for (cntr_unknown4_0=0;cntr_unknown4_0<20;cntr_unknown4_0++) {
		ndr_print_uint32(ndr, "unknown4", r->unknown4[cntr_unknown4_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_PacInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_PacInfo *r)
{
	uint32_t cntr_expansionroom_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pac_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pac));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_domain));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_server));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->principal_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->auth));
		NDR_CHECK(ndr_push_netr_UserSessionKey(ndr, NDR_SCALARS, &r->user_session_key));
		for (cntr_expansionroom_0 = 0; cntr_expansionroom_0 < 10; cntr_expansionroom_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->expansionroom[cntr_expansionroom_0]));
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pac) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->pac_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pac, r->pac_size));
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_domain));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_server));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->principal_name));
		if (r->auth) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->auth_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->auth, r->auth_size));
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_PacInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_PacInfo *r)
{
	uint32_t _ptr_pac;
	uint32_t size_pac_1 = 0;
	TALLOC_CTX *_mem_save_pac_0;
	uint32_t _ptr_auth;
	uint32_t size_auth_1 = 0;
	TALLOC_CTX *_mem_save_auth_0;
	uint32_t size_expansionroom_0 = 0;
	uint32_t cntr_expansionroom_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pac_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pac));
		if (_ptr_pac) {
			NDR_PULL_ALLOC(ndr, r->pac);
		} else {
			r->pac = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_domain));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_server));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->principal_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_auth));
		if (_ptr_auth) {
			NDR_PULL_ALLOC(ndr, r->auth);
		} else {
			r->auth = NULL;
		}
		NDR_CHECK(ndr_pull_netr_UserSessionKey(ndr, NDR_SCALARS, &r->user_session_key));
		size_expansionroom_0 = 10;
		for (cntr_expansionroom_0 = 0; cntr_expansionroom_0 < size_expansionroom_0; cntr_expansionroom_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->expansionroom[cntr_expansionroom_0]));
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pac) {
			_mem_save_pac_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pac, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pac));
			size_pac_1 = ndr_get_array_size(ndr, &r->pac);
			NDR_PULL_ALLOC_N(ndr, r->pac, size_pac_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pac, size_pac_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pac_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_domain));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_server));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->principal_name));
		if (r->auth) {
			_mem_save_auth_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->auth, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->auth));
			size_auth_1 = ndr_get_array_size(ndr, &r->auth);
			NDR_PULL_ALLOC_N(ndr, r->auth, size_auth_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->auth, size_auth_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
		if (r->pac) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pac, r->pac_size));
		}
		if (r->auth) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->auth, r->auth_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_PacInfo(struct ndr_print *ndr, const char *name, const struct netr_PacInfo *r)
{
	uint32_t cntr_expansionroom_0;
	ndr_print_struct(ndr, name, "netr_PacInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "pac_size", r->pac_size);
	ndr_print_ptr(ndr, "pac", r->pac);
	ndr->depth++;
	if (r->pac) {
		ndr_print_array_uint8(ndr, "pac", r->pac, r->pac_size);
	}
	ndr->depth--;
	ndr_print_lsa_String(ndr, "logon_domain", &r->logon_domain);
	ndr_print_lsa_String(ndr, "logon_server", &r->logon_server);
	ndr_print_lsa_String(ndr, "principal_name", &r->principal_name);
	ndr_print_uint32(ndr, "auth_size", r->auth_size);
	ndr_print_ptr(ndr, "auth", r->auth);
	ndr->depth++;
	if (r->auth) {
		ndr_print_array_uint8(ndr, "auth", r->auth, r->auth_size);
	}
	ndr->depth--;
	ndr_print_netr_UserSessionKey(ndr, "user_session_key", &r->user_session_key);
	ndr->print(ndr, "%s: ARRAY(%d)", "expansionroom", (int)10);
	ndr->depth++;
	for (cntr_expansionroom_0=0;cntr_expansionroom_0<10;cntr_expansionroom_0++) {
		ndr_print_uint32(ndr, "expansionroom", r->expansionroom[cntr_expansionroom_0]);
	}
	ndr->depth--;
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_GenericInfo2(struct ndr_push *ndr, int ndr_flags, const struct netr_GenericInfo2 *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_GenericInfo2(struct ndr_pull *ndr, int ndr_flags, struct netr_GenericInfo2 *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
			if (_ptr_data) {
				NDR_PULL_ALLOC(ndr, r->data);
			} else {
				r->data = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->data) {
				_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
				size_data_1 = ndr_get_array_size(ndr, &r->data);
				NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			}
			if (r->data) {
				NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_GenericInfo2(struct ndr_print *ndr, const char *name, const struct netr_GenericInfo2 *r)
{
	ndr_print_struct(ndr, name, "netr_GenericInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", r->length);
		ndr_print_ptr(ndr, "data", r->data);
		ndr->depth++;
		if (r->data) {
			ndr_print_array_uint8(ndr, "data", r->data, r->length);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_Validation(struct ndr_push *ndr, int ndr_flags, const union netr_Validation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case NetlogonValidationSamInfo: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sam2));
			break; }

			case NetlogonValidationSamInfo2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sam3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pac));
			break; }

			case NetlogonValidationGenericInfo2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->generic));
			break; }

			case NetlogonValidationSamInfo4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sam6));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NetlogonValidationSamInfo:
				if (r->sam2) {
					NDR_CHECK(ndr_push_netr_SamInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam2));
				}
			break;

			case NetlogonValidationSamInfo2:
				if (r->sam3) {
					NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam3));
				}
			break;

			case 4:
				if (r->pac) {
					NDR_CHECK(ndr_push_netr_PacInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->pac));
				}
			break;

			case NetlogonValidationGenericInfo2:
				if (r->generic) {
					NDR_CHECK(ndr_push_netr_GenericInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->generic));
				}
			break;

			case NetlogonValidationSamInfo4:
				if (r->sam6) {
					NDR_CHECK(ndr_push_netr_SamInfo6(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam6));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_Validation(struct ndr_pull *ndr, int ndr_flags, union netr_Validation *r)
{
	uint32_t level;
	uint16_t _level;
	TALLOC_CTX *_mem_save_sam2_0;
	uint32_t _ptr_sam2;
	TALLOC_CTX *_mem_save_sam3_0;
	uint32_t _ptr_sam3;
	TALLOC_CTX *_mem_save_pac_0;
	uint32_t _ptr_pac;
	TALLOC_CTX *_mem_save_generic_0;
	uint32_t _ptr_generic;
	TALLOC_CTX *_mem_save_sam6_0;
	uint32_t _ptr_sam6;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case NetlogonValidationSamInfo: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam2));
				if (_ptr_sam2) {
					NDR_PULL_ALLOC(ndr, r->sam2);
				} else {
					r->sam2 = NULL;
				}
			break; }

			case NetlogonValidationSamInfo2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam3));
				if (_ptr_sam3) {
					NDR_PULL_ALLOC(ndr, r->sam3);
				} else {
					r->sam3 = NULL;
				}
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pac));
				if (_ptr_pac) {
					NDR_PULL_ALLOC(ndr, r->pac);
				} else {
					r->pac = NULL;
				}
			break; }

			case NetlogonValidationGenericInfo2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_generic));
				if (_ptr_generic) {
					NDR_PULL_ALLOC(ndr, r->generic);
				} else {
					r->generic = NULL;
				}
			break; }

			case NetlogonValidationSamInfo4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam6));
				if (_ptr_sam6) {
					NDR_PULL_ALLOC(ndr, r->sam6);
				} else {
					r->sam6 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NetlogonValidationSamInfo:
				if (r->sam2) {
					_mem_save_sam2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sam2, 0);
					NDR_CHECK(ndr_pull_netr_SamInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam2_0, 0);
				}
			break;

			case NetlogonValidationSamInfo2:
				if (r->sam3) {
					_mem_save_sam3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sam3, 0);
					NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam3_0, 0);
				}
			break;

			case 4:
				if (r->pac) {
					_mem_save_pac_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pac, 0);
					NDR_CHECK(ndr_pull_netr_PacInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->pac));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pac_0, 0);
				}
			break;

			case NetlogonValidationGenericInfo2:
				if (r->generic) {
					_mem_save_generic_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->generic, 0);
					NDR_CHECK(ndr_pull_netr_GenericInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->generic));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_generic_0, 0);
				}
			break;

			case NetlogonValidationSamInfo4:
				if (r->sam6) {
					_mem_save_sam6_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sam6, 0);
					NDR_CHECK(ndr_pull_netr_SamInfo6(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam6));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam6_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Validation(struct ndr_print *ndr, const char *name, const union netr_Validation *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_Validation");
	switch (level) {
		case NetlogonValidationSamInfo:
			ndr_print_ptr(ndr, "sam2", r->sam2);
			ndr->depth++;
			if (r->sam2) {
				ndr_print_netr_SamInfo2(ndr, "sam2", r->sam2);
			}
			ndr->depth--;
		break;

		case NetlogonValidationSamInfo2:
			ndr_print_ptr(ndr, "sam3", r->sam3);
			ndr->depth++;
			if (r->sam3) {
				ndr_print_netr_SamInfo3(ndr, "sam3", r->sam3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "pac", r->pac);
			ndr->depth++;
			if (r->pac) {
				ndr_print_netr_PacInfo(ndr, "pac", r->pac);
			}
			ndr->depth--;
		break;

		case NetlogonValidationGenericInfo2:
			ndr_print_ptr(ndr, "generic", r->generic);
			ndr->depth++;
			if (r->generic) {
				ndr_print_netr_GenericInfo2(ndr, "generic", r->generic);
			}
			ndr->depth--;
		break;

		case NetlogonValidationSamInfo4:
			ndr_print_ptr(ndr, "sam6", r->sam6);
			ndr->depth++;
			if (r->sam6) {
				ndr_print_netr_SamInfo6(ndr, "sam6", r->sam6);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_Credential(struct ndr_push *ndr, int ndr_flags, const struct netr_Credential *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 8));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_Credential(struct ndr_pull *ndr, int ndr_flags, struct netr_Credential *r)
{
	uint32_t size_data_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_data_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Credential(struct ndr_print *ndr, const char *name, const struct netr_Credential *r)
{
	ndr_print_struct(ndr, name, "netr_Credential");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->data, 8);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_Authenticator(struct ndr_push *ndr, int ndr_flags, const struct netr_Authenticator *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->cred));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->timestamp));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_Authenticator(struct ndr_pull *ndr, int ndr_flags, struct netr_Authenticator *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->cred));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->timestamp));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Authenticator(struct ndr_print *ndr, const char *name, const struct netr_Authenticator *r)
{
	ndr_print_struct(ndr, name, "netr_Authenticator");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_Credential(ndr, "cred", &r->cred);
	ndr_print_time_t(ndr, "timestamp", r->timestamp);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_DELETE_USER(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_DELETE_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_DELETE_USER(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_DELETE_USER *r)
{
	uint32_t _ptr_account_name;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	TALLOC_CTX *_mem_save_account_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->account_name);
		} else {
			r->account_name = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->account_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
			size_account_name_1 = ndr_get_array_size(ndr, &r->account_name);
			length_account_name_1 = ndr_get_array_length(ndr, &r->account_name);
			if (length_account_name_1 > size_account_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_DELETE_USER(struct ndr_print *ndr, const char *name, const struct netr_DELTA_DELETE_USER *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_DELETE_USER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "account_name", r->account_name);
	ndr->depth++;
	if (r->account_name) {
		ndr_print_string(ndr, "account_name", r->account_name);
	}
	ndr->depth--;
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_USER_KEY16(struct ndr_push *ndr, int ndr_flags, const struct netr_USER_KEY16 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->pwd));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_USER_KEY16(struct ndr_pull *ndr, int ndr_flags, struct netr_USER_KEY16 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->pwd));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_USER_KEY16(struct ndr_print *ndr, const char *name, const struct netr_USER_KEY16 *r)
{
	ndr_print_struct(ndr, name, "netr_USER_KEY16");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->length:r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_samr_Password(ndr, "pwd", &r->pwd);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_PasswordHistory(struct ndr_push *ndr, int ndr_flags, const struct netr_PasswordHistory *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nt_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nt_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nt_flags));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->lm_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lm_flags));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->nt_history, r->nt_length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->lm_history, r->lm_length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_PasswordHistory(struct ndr_pull *ndr, int ndr_flags, struct netr_PasswordHistory *r)
{
	uint32_t size_nt_history_0 = 0;
	uint32_t size_lm_history_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nt_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nt_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nt_flags));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->lm_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lm_flags));
		size_nt_history_0 = r->nt_length;
		NDR_PULL_ALLOC_N(ndr, r->nt_history, size_nt_history_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->nt_history, size_nt_history_0));
		size_lm_history_0 = r->lm_length;
		NDR_PULL_ALLOC_N(ndr, r->lm_history, size_lm_history_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->lm_history, size_lm_history_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_PasswordHistory(struct ndr_print *ndr, const char *name, const struct netr_PasswordHistory *r)
{
	ndr_print_struct(ndr, name, "netr_PasswordHistory");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "nt_length", r->nt_length);
	ndr_print_uint16(ndr, "nt_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->nt_length:r->nt_size);
	ndr_print_uint32(ndr, "nt_flags", r->nt_flags);
	ndr_print_uint16(ndr, "lm_length", r->lm_length);
	ndr_print_uint16(ndr, "lm_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->lm_length:r->lm_size);
	ndr_print_uint32(ndr, "lm_flags", r->lm_flags);
	ndr_print_array_uint8(ndr, "nt_history", r->nt_history, r->nt_length);
	ndr_print_array_uint8(ndr, "lm_history", r->lm_history, r->lm_length);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_USER_KEYS2(struct ndr_push *ndr, int ndr_flags, const struct netr_USER_KEYS2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_USER_KEY16(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_push_netr_USER_KEY16(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_push_netr_PasswordHistory(ndr, NDR_SCALARS, &r->history));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_USER_KEYS2(struct ndr_pull *ndr, int ndr_flags, struct netr_USER_KEYS2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_USER_KEY16(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_pull_netr_USER_KEY16(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_pull_netr_PasswordHistory(ndr, NDR_SCALARS, &r->history));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_USER_KEYS2(struct ndr_print *ndr, const char *name, const struct netr_USER_KEYS2 *r)
{
	ndr_print_struct(ndr, name, "netr_USER_KEYS2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_USER_KEY16(ndr, "lmpassword", &r->lmpassword);
	ndr_print_netr_USER_KEY16(ndr, "ntpassword", &r->ntpassword);
	ndr_print_netr_PasswordHistory(ndr, "history", &r->history);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_USER_KEY_UNION(struct ndr_push *ndr, int ndr_flags, const struct netr_USER_KEY_UNION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_USER_KEYS2(ndr, NDR_SCALARS, &r->keys2));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_USER_KEY_UNION(struct ndr_pull *ndr, int ndr_flags, struct netr_USER_KEY_UNION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_USER_KEYS2(ndr, NDR_SCALARS, &r->keys2));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_USER_KEY_UNION(struct ndr_print *ndr, const char *name, const struct netr_USER_KEY_UNION *r)
{
	ndr_print_struct(ndr, name, "netr_USER_KEY_UNION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_USER_KEYS2(ndr, "keys2", &r->keys2);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_USER_KEYS(struct ndr_push *ndr, int ndr_flags, const struct netr_USER_KEYS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_netr_USER_KEY_UNION(ndr, NDR_SCALARS, &r->keys));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_USER_KEYS(struct ndr_pull *ndr, int ndr_flags, struct netr_USER_KEYS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_netr_USER_KEY_UNION(ndr, NDR_SCALARS, &r->keys));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_USER_KEYS(struct ndr_print *ndr, const char *name, const struct netr_USER_KEYS *r)
{
	ndr_print_struct(ndr, name, "netr_USER_KEYS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_netr_USER_KEY_UNION(ndr, "keys", &r->keys);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_USER_PRIVATE_INFO(struct ndr_push *ndr, int ndr_flags, const struct netr_USER_PRIVATE_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->SensitiveDataFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->DataLength));
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->SensitiveData));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->SensitiveData) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->DataLength));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->SensitiveData, r->DataLength));
			}
			ndr->flags = _flags_save_uint8;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_USER_PRIVATE_INFO(struct ndr_pull *ndr, int ndr_flags, struct netr_USER_PRIVATE_INFO *r)
{
	uint32_t _ptr_SensitiveData;
	uint32_t size_SensitiveData_1 = 0;
	TALLOC_CTX *_mem_save_SensitiveData_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->SensitiveDataFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->DataLength));
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_SensitiveData));
			if (_ptr_SensitiveData) {
				NDR_PULL_ALLOC(ndr, r->SensitiveData);
			} else {
				r->SensitiveData = NULL;
			}
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->SensitiveData) {
				_mem_save_SensitiveData_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->SensitiveData, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->SensitiveData));
				size_SensitiveData_1 = ndr_get_array_size(ndr, &r->SensitiveData);
				NDR_PULL_ALLOC_N(ndr, r->SensitiveData, size_SensitiveData_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->SensitiveData, size_SensitiveData_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SensitiveData_0, 0);
			}
			ndr->flags = _flags_save_uint8;
		}
		if (r->SensitiveData) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->SensitiveData, r->DataLength));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_USER_PRIVATE_INFO(struct ndr_print *ndr, const char *name, const struct netr_USER_PRIVATE_INFO *r)
{
	ndr_print_struct(ndr, name, "netr_USER_PRIVATE_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "SensitiveDataFlag", r->SensitiveDataFlag);
	ndr_print_uint32(ndr, "DataLength", r->DataLength);
	ndr_print_ptr(ndr, "SensitiveData", r->SensitiveData);
	ndr->depth++;
	if (r->SensitiveData) {
		ndr_print_array_uint8(ndr, "SensitiveData", r->SensitiveData, r->DataLength);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_USER(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->nt_password_present));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->lm_password_present));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->password_expired));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->country_code));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->code_page));
		NDR_CHECK(ndr_push_netr_USER_PRIVATE_INFO(ndr, NDR_SCALARS, &r->user_private_info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_push_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
		NDR_CHECK(ndr_push_netr_USER_PRIVATE_INFO(ndr, NDR_BUFFERS, &r->user_private_info));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_USER(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->workstations));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_SCALARS, &r->logon_hours));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->lmpassword));
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, &r->ntpassword));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->nt_password_present));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->lm_password_present));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->password_expired));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->parameters));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->country_code));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->code_page));
		NDR_CHECK(ndr_pull_netr_USER_PRIVATE_INFO(ndr, NDR_SCALARS, &r->user_private_info));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->account_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->full_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_directory));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->home_drive));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->logon_script));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->workstations));
		NDR_CHECK(ndr_pull_samr_LogonHours(ndr, NDR_BUFFERS, &r->logon_hours));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->comment));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->parameters));
		NDR_CHECK(ndr_pull_netr_USER_PRIVATE_INFO(ndr, NDR_BUFFERS, &r->user_private_info));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->profile_path));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_USER(struct ndr_print *ndr, const char *name, const struct netr_DELTA_USER *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_USER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "account_name", &r->account_name);
	ndr_print_lsa_String(ndr, "full_name", &r->full_name);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "primary_gid", r->primary_gid);
	ndr_print_lsa_String(ndr, "home_directory", &r->home_directory);
	ndr_print_lsa_String(ndr, "home_drive", &r->home_drive);
	ndr_print_lsa_String(ndr, "logon_script", &r->logon_script);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "workstations", &r->workstations);
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_samr_LogonHours(ndr, "logon_hours", &r->logon_hours);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr_print_samr_AcctFlags(ndr, "acct_flags", r->acct_flags);
	ndr_print_samr_Password(ndr, "lmpassword", &r->lmpassword);
	ndr_print_samr_Password(ndr, "ntpassword", &r->ntpassword);
	ndr_print_uint8(ndr, "nt_password_present", r->nt_password_present);
	ndr_print_uint8(ndr, "lm_password_present", r->lm_password_present);
	ndr_print_uint8(ndr, "password_expired", r->password_expired);
	ndr_print_lsa_String(ndr, "comment", &r->comment);
	ndr_print_lsa_BinaryString(ndr, "parameters", &r->parameters);
	ndr_print_uint16(ndr, "country_code", r->country_code);
	ndr_print_uint16(ndr, "code_page", r->code_page);
	ndr_print_netr_USER_PRIVATE_INFO(ndr, "user_private_info", &r->user_private_info);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "profile_path", &r->profile_path);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_DOMAIN(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_DOMAIN *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->force_logoff_time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->min_password_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->password_history_length));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->max_password_age));
		NDR_CHECK(ndr_push_dlong(ndr, NDR_SCALARS, r->min_password_age));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->sequence_num));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->domain_create_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_SCALARS, &r->account_lockout));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logon_to_chgpass));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_BinaryString(ndr, NDR_BUFFERS, &r->account_lockout));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_DOMAIN(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_DOMAIN *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->oem_information));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->force_logoff_time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->min_password_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->password_history_length));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->max_password_age));
		NDR_CHECK(ndr_pull_dlong(ndr, NDR_SCALARS, &r->min_password_age));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->sequence_num));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->domain_create_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_SCALARS, &r->account_lockout));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logon_to_chgpass));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->oem_information));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_BinaryString(ndr, NDR_BUFFERS, &r->account_lockout));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_DOMAIN(struct ndr_print *ndr, const char *name, const struct netr_DELTA_DOMAIN *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_DOMAIN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "domain_name", &r->domain_name);
	ndr_print_lsa_String(ndr, "oem_information", &r->oem_information);
	ndr_print_dlong(ndr, "force_logoff_time", r->force_logoff_time);
	ndr_print_uint16(ndr, "min_password_length", r->min_password_length);
	ndr_print_uint16(ndr, "password_history_length", r->password_history_length);
	ndr_print_dlong(ndr, "max_password_age", r->max_password_age);
	ndr_print_dlong(ndr, "min_password_age", r->min_password_age);
	ndr_print_udlong(ndr, "sequence_num", r->sequence_num);
	ndr_print_NTTIME(ndr, "domain_create_time", r->domain_create_time);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_BinaryString(ndr, "account_lockout", &r->account_lockout);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "logon_to_chgpass", r->logon_to_chgpass);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_GROUP(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->group_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->group_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_GROUP(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->group_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->group_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_GROUP(struct ndr_print *ndr, const char *name, const struct netr_DELTA_GROUP *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_GROUP");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "group_name", &r->group_name);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "attributes", r->attributes);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_RENAME(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_RENAME *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->OldName));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->NewName));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->OldName));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->NewName));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_RENAME(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_RENAME *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->OldName));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->NewName));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->OldName));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->NewName));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_RENAME(struct ndr_print *ndr, const char *name, const struct netr_DELTA_RENAME *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_RENAME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "OldName", &r->OldName);
	ndr_print_lsa_String(ndr, "NewName", &r->NewName);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_GROUP_MEMBER(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_GROUP_MEMBER *r)
{
	uint32_t cntr_rids_1;
	uint32_t cntr_attribs_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->rids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_rids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_rids));
			for (cntr_rids_1 = 0; cntr_rids_1 < r->num_rids; cntr_rids_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rids[cntr_rids_1]));
			}
		}
		if (r->attribs) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_rids));
			for (cntr_attribs_1 = 0; cntr_attribs_1 < r->num_rids; cntr_attribs_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attribs[cntr_attribs_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_GROUP_MEMBER(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_GROUP_MEMBER *r)
{
	uint32_t _ptr_rids;
	uint32_t size_rids_1 = 0;
	uint32_t cntr_rids_1;
	TALLOC_CTX *_mem_save_rids_0;
	TALLOC_CTX *_mem_save_rids_1;
	uint32_t _ptr_attribs;
	uint32_t size_attribs_1 = 0;
	uint32_t cntr_attribs_1;
	TALLOC_CTX *_mem_save_attribs_0;
	TALLOC_CTX *_mem_save_attribs_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rids));
		if (_ptr_rids) {
			NDR_PULL_ALLOC(ndr, r->rids);
		} else {
			r->rids = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribs));
		if (_ptr_attribs) {
			NDR_PULL_ALLOC(ndr, r->attribs);
		} else {
			r->attribs = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_rids));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->rids) {
			_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->rids));
			size_rids_1 = ndr_get_array_size(ndr, &r->rids);
			NDR_PULL_ALLOC_N(ndr, r->rids, size_rids_1);
			_mem_save_rids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
			for (cntr_rids_1 = 0; cntr_rids_1 < size_rids_1; cntr_rids_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rids[cntr_rids_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		}
		if (r->attribs) {
			_mem_save_attribs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribs));
			size_attribs_1 = ndr_get_array_size(ndr, &r->attribs);
			NDR_PULL_ALLOC_N(ndr, r->attribs, size_attribs_1);
			_mem_save_attribs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribs, 0);
			for (cntr_attribs_1 = 0; cntr_attribs_1 < size_attribs_1; cntr_attribs_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attribs[cntr_attribs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribs_0, 0);
		}
		if (r->rids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->rids, r->num_rids));
		}
		if (r->attribs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->attribs, r->num_rids));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_GROUP_MEMBER(struct ndr_print *ndr, const char *name, const struct netr_DELTA_GROUP_MEMBER *r)
{
	uint32_t cntr_rids_1;
	uint32_t cntr_attribs_1;
	ndr_print_struct(ndr, name, "netr_DELTA_GROUP_MEMBER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "rids", r->rids);
	ndr->depth++;
	if (r->rids) {
		ndr->print(ndr, "%s: ARRAY(%d)", "rids", (int)r->num_rids);
		ndr->depth++;
		for (cntr_rids_1=0;cntr_rids_1<r->num_rids;cntr_rids_1++) {
			ndr_print_uint32(ndr, "rids", r->rids[cntr_rids_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "attribs", r->attribs);
	ndr->depth++;
	if (r->attribs) {
		ndr->print(ndr, "%s: ARRAY(%d)", "attribs", (int)r->num_rids);
		ndr->depth++;
		for (cntr_attribs_1=0;cntr_attribs_1<r->num_rids;cntr_attribs_1++) {
			ndr_print_uint32(ndr, "attribs", r->attribs[cntr_attribs_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_rids", r->num_rids);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "unknown3", r->unknown3);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_ALIAS(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_ALIAS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->alias_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->alias_name));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ALIAS(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_ALIAS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->alias_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->alias_name));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->description));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ALIAS(struct ndr_print *ndr, const char *name, const struct netr_DELTA_ALIAS *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_ALIAS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "alias_name", &r->alias_name);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "description", &r->description);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_ALIAS_MEMBER(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_ALIAS_MEMBER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS, &r->sids));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_BUFFERS, &r->sids));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ALIAS_MEMBER(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_ALIAS_MEMBER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS, &r->sids));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_BUFFERS, &r->sids));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ALIAS_MEMBER(struct ndr_print *ndr, const char *name, const struct netr_DELTA_ALIAS_MEMBER *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_ALIAS_MEMBER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_SidArray(ndr, "sids", &r->sids);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "unknown3", r->unknown3);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_QUOTA_LIMITS(struct ndr_push *ndr, int ndr_flags, const struct netr_QUOTA_LIMITS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pagedpoollimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nonpagedpoollimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minimumworkingsetsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximumworkingsetsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pagefilelimit));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->timelimit));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_QUOTA_LIMITS(struct ndr_pull *ndr, int ndr_flags, struct netr_QUOTA_LIMITS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pagedpoollimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nonpagedpoollimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minimumworkingsetsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximumworkingsetsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pagefilelimit));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->timelimit));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_QUOTA_LIMITS(struct ndr_print *ndr, const char *name, const struct netr_QUOTA_LIMITS *r)
{
	ndr_print_struct(ndr, name, "netr_QUOTA_LIMITS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "pagedpoollimit", r->pagedpoollimit);
	ndr_print_uint32(ndr, "nonpagedpoollimit", r->nonpagedpoollimit);
	ndr_print_uint32(ndr, "minimumworkingsetsize", r->minimumworkingsetsize);
	ndr_print_uint32(ndr, "maximumworkingsetsize", r->maximumworkingsetsize);
	ndr_print_uint32(ndr, "pagefilelimit", r->pagefilelimit);
	ndr_print_NTTIME(ndr, "timelimit", r->timelimit);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_POLICY(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_POLICY *r)
{
	uint32_t cntr_eventauditoptions_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxlogsize));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->auditretentionperiod));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auditingmode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxauditeventcount));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->eventauditoptions));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->primary_domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_netr_QUOTA_LIMITS(ndr, NDR_SCALARS, &r->quota_limits));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->sequence_num));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->db_create_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->eventauditoptions) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->maxauditeventcount + 1));
			for (cntr_eventauditoptions_1 = 0; cntr_eventauditoptions_1 < r->maxauditeventcount + 1; cntr_eventauditoptions_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->eventauditoptions[cntr_eventauditoptions_1]));
			}
		}
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->primary_domain_name));
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_POLICY(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_POLICY *r)
{
	uint32_t _ptr_eventauditoptions;
	uint32_t size_eventauditoptions_1 = 0;
	uint32_t cntr_eventauditoptions_1;
	TALLOC_CTX *_mem_save_eventauditoptions_0;
	TALLOC_CTX *_mem_save_eventauditoptions_1;
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxlogsize));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->auditretentionperiod));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auditingmode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxauditeventcount));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_eventauditoptions));
		if (_ptr_eventauditoptions) {
			NDR_PULL_ALLOC(ndr, r->eventauditoptions);
		} else {
			r->eventauditoptions = NULL;
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->primary_domain_name));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_netr_QUOTA_LIMITS(ndr, NDR_SCALARS, &r->quota_limits));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->sequence_num));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->db_create_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->eventauditoptions) {
			_mem_save_eventauditoptions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->eventauditoptions, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->eventauditoptions));
			size_eventauditoptions_1 = ndr_get_array_size(ndr, &r->eventauditoptions);
			NDR_PULL_ALLOC_N(ndr, r->eventauditoptions, size_eventauditoptions_1);
			_mem_save_eventauditoptions_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->eventauditoptions, 0);
			for (cntr_eventauditoptions_1 = 0; cntr_eventauditoptions_1 < size_eventauditoptions_1; cntr_eventauditoptions_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->eventauditoptions[cntr_eventauditoptions_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventauditoptions_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_eventauditoptions_0, 0);
		}
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->primary_domain_name));
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
		if (r->eventauditoptions) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->eventauditoptions, r->maxauditeventcount + 1));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_POLICY(struct ndr_print *ndr, const char *name, const struct netr_DELTA_POLICY *r)
{
	uint32_t cntr_eventauditoptions_1;
	ndr_print_struct(ndr, name, "netr_DELTA_POLICY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "maxlogsize", r->maxlogsize);
	ndr_print_NTTIME(ndr, "auditretentionperiod", r->auditretentionperiod);
	ndr_print_uint8(ndr, "auditingmode", r->auditingmode);
	ndr_print_uint32(ndr, "maxauditeventcount", r->maxauditeventcount);
	ndr_print_ptr(ndr, "eventauditoptions", r->eventauditoptions);
	ndr->depth++;
	if (r->eventauditoptions) {
		ndr->print(ndr, "%s: ARRAY(%d)", "eventauditoptions", (int)r->maxauditeventcount + 1);
		ndr->depth++;
		for (cntr_eventauditoptions_1=0;cntr_eventauditoptions_1<r->maxauditeventcount + 1;cntr_eventauditoptions_1++) {
			ndr_print_uint32(ndr, "eventauditoptions", r->eventauditoptions[cntr_eventauditoptions_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_lsa_String(ndr, "primary_domain_name", &r->primary_domain_name);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_netr_QUOTA_LIMITS(ndr, "quota_limits", &r->quota_limits);
	ndr_print_udlong(ndr, "sequence_num", r->sequence_num);
	ndr_print_NTTIME(ndr, "db_create_time", r->db_create_time);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_TRUSTED_DOMAIN(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_TRUSTED_DOMAIN *r)
{
	uint32_t cntr_controller_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_controllers));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->controller_names));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->posix_offset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		if (r->controller_names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_controllers));
			for (cntr_controller_names_1 = 0; cntr_controller_names_1 < r->num_controllers; cntr_controller_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->controller_names[cntr_controller_names_1]));
			}
			for (cntr_controller_names_1 = 0; cntr_controller_names_1 < r->num_controllers; cntr_controller_names_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->controller_names[cntr_controller_names_1]));
			}
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_TRUSTED_DOMAIN(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_TRUSTED_DOMAIN *r)
{
	uint32_t _ptr_controller_names;
	uint32_t size_controller_names_1 = 0;
	uint32_t cntr_controller_names_1;
	TALLOC_CTX *_mem_save_controller_names_0;
	TALLOC_CTX *_mem_save_controller_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_controllers));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_controller_names));
		if (_ptr_controller_names) {
			NDR_PULL_ALLOC(ndr, r->controller_names);
		} else {
			r->controller_names = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->posix_offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->domain_name));
		if (r->controller_names) {
			_mem_save_controller_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->controller_names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->controller_names));
			size_controller_names_1 = ndr_get_array_size(ndr, &r->controller_names);
			NDR_PULL_ALLOC_N(ndr, r->controller_names, size_controller_names_1);
			_mem_save_controller_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->controller_names, 0);
			for (cntr_controller_names_1 = 0; cntr_controller_names_1 < size_controller_names_1; cntr_controller_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->controller_names[cntr_controller_names_1]));
			}
			for (cntr_controller_names_1 = 0; cntr_controller_names_1 < size_controller_names_1; cntr_controller_names_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->controller_names[cntr_controller_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_controller_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_controller_names_0, 0);
		}
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
		if (r->controller_names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->controller_names, r->num_controllers));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_TRUSTED_DOMAIN(struct ndr_print *ndr, const char *name, const struct netr_DELTA_TRUSTED_DOMAIN *r)
{
	uint32_t cntr_controller_names_1;
	ndr_print_struct(ndr, name, "netr_DELTA_TRUSTED_DOMAIN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_String(ndr, "domain_name", &r->domain_name);
	ndr_print_uint32(ndr, "num_controllers", r->num_controllers);
	ndr_print_ptr(ndr, "controller_names", r->controller_names);
	ndr->depth++;
	if (r->controller_names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "controller_names", (int)r->num_controllers);
		ndr->depth++;
		for (cntr_controller_names_1=0;cntr_controller_names_1<r->num_controllers;cntr_controller_names_1++) {
			ndr_print_lsa_String(ndr, "controller_names", &r->controller_names[cntr_controller_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "posix_offset", r->posix_offset);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_ACCOUNT(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_ACCOUNT *r)
{
	uint32_t cntr_privilege_attrib_1;
	uint32_t cntr_privilege_name_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->privilege_entries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->privilege_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->privilege_attrib));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->privilege_name));
		NDR_CHECK(ndr_push_netr_QUOTA_LIMITS(ndr, NDR_SCALARS, &r->quotalimits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->system_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privilege_attrib) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->privilege_entries));
			for (cntr_privilege_attrib_1 = 0; cntr_privilege_attrib_1 < r->privilege_entries; cntr_privilege_attrib_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->privilege_attrib[cntr_privilege_attrib_1]));
			}
		}
		if (r->privilege_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->privilege_entries));
			for (cntr_privilege_name_1 = 0; cntr_privilege_name_1 < r->privilege_entries; cntr_privilege_name_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->privilege_name[cntr_privilege_name_1]));
			}
			for (cntr_privilege_name_1 = 0; cntr_privilege_name_1 < r->privilege_entries; cntr_privilege_name_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->privilege_name[cntr_privilege_name_1]));
			}
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ACCOUNT(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_ACCOUNT *r)
{
	uint32_t _ptr_privilege_attrib;
	uint32_t size_privilege_attrib_1 = 0;
	uint32_t cntr_privilege_attrib_1;
	TALLOC_CTX *_mem_save_privilege_attrib_0;
	TALLOC_CTX *_mem_save_privilege_attrib_1;
	uint32_t _ptr_privilege_name;
	uint32_t size_privilege_name_1 = 0;
	uint32_t cntr_privilege_name_1;
	TALLOC_CTX *_mem_save_privilege_name_0;
	TALLOC_CTX *_mem_save_privilege_name_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->privilege_entries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->privilege_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privilege_attrib));
		if (_ptr_privilege_attrib) {
			NDR_PULL_ALLOC(ndr, r->privilege_attrib);
		} else {
			r->privilege_attrib = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_privilege_name));
		if (_ptr_privilege_name) {
			NDR_PULL_ALLOC(ndr, r->privilege_name);
		} else {
			r->privilege_name = NULL;
		}
		NDR_CHECK(ndr_pull_netr_QUOTA_LIMITS(ndr, NDR_SCALARS, &r->quotalimits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->system_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->privilege_attrib) {
			_mem_save_privilege_attrib_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privilege_attrib, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->privilege_attrib));
			size_privilege_attrib_1 = ndr_get_array_size(ndr, &r->privilege_attrib);
			NDR_PULL_ALLOC_N(ndr, r->privilege_attrib, size_privilege_attrib_1);
			_mem_save_privilege_attrib_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privilege_attrib, 0);
			for (cntr_privilege_attrib_1 = 0; cntr_privilege_attrib_1 < size_privilege_attrib_1; cntr_privilege_attrib_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->privilege_attrib[cntr_privilege_attrib_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privilege_attrib_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privilege_attrib_0, 0);
		}
		if (r->privilege_name) {
			_mem_save_privilege_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privilege_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->privilege_name));
			size_privilege_name_1 = ndr_get_array_size(ndr, &r->privilege_name);
			NDR_PULL_ALLOC_N(ndr, r->privilege_name, size_privilege_name_1);
			_mem_save_privilege_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->privilege_name, 0);
			for (cntr_privilege_name_1 = 0; cntr_privilege_name_1 < size_privilege_name_1; cntr_privilege_name_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->privilege_name[cntr_privilege_name_1]));
			}
			for (cntr_privilege_name_1 = 0; cntr_privilege_name_1 < size_privilege_name_1; cntr_privilege_name_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->privilege_name[cntr_privilege_name_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privilege_name_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_privilege_name_0, 0);
		}
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
		if (r->privilege_attrib) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->privilege_attrib, r->privilege_entries));
		}
		if (r->privilege_name) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->privilege_name, r->privilege_entries));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ACCOUNT(struct ndr_print *ndr, const char *name, const struct netr_DELTA_ACCOUNT *r)
{
	uint32_t cntr_privilege_attrib_1;
	uint32_t cntr_privilege_name_1;
	ndr_print_struct(ndr, name, "netr_DELTA_ACCOUNT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "privilege_entries", r->privilege_entries);
	ndr_print_uint32(ndr, "privilege_control", r->privilege_control);
	ndr_print_ptr(ndr, "privilege_attrib", r->privilege_attrib);
	ndr->depth++;
	if (r->privilege_attrib) {
		ndr->print(ndr, "%s: ARRAY(%d)", "privilege_attrib", (int)r->privilege_entries);
		ndr->depth++;
		for (cntr_privilege_attrib_1=0;cntr_privilege_attrib_1<r->privilege_entries;cntr_privilege_attrib_1++) {
			ndr_print_uint32(ndr, "privilege_attrib", r->privilege_attrib[cntr_privilege_attrib_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "privilege_name", r->privilege_name);
	ndr->depth++;
	if (r->privilege_name) {
		ndr->print(ndr, "%s: ARRAY(%d)", "privilege_name", (int)r->privilege_entries);
		ndr->depth++;
		for (cntr_privilege_name_1=0;cntr_privilege_name_1<r->privilege_entries;cntr_privilege_name_1++) {
			ndr_print_lsa_String(ndr, "privilege_name", &r->privilege_name[cntr_privilege_name_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_netr_QUOTA_LIMITS(ndr, "quotalimits", &r->quotalimits);
	ndr_print_uint32(ndr, "system_flags", r->system_flags);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_CIPHER_VALUE(struct ndr_push *ndr, int ndr_flags, const struct netr_CIPHER_VALUE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maxlen));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->cipher_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->cipher_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->maxlen));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->cipher_data, r->len));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_CIPHER_VALUE(struct ndr_pull *ndr, int ndr_flags, struct netr_CIPHER_VALUE *r)
{
	uint32_t _ptr_cipher_data;
	uint32_t size_cipher_data_1 = 0;
	uint32_t length_cipher_data_1 = 0;
	TALLOC_CTX *_mem_save_cipher_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maxlen));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cipher_data));
		if (_ptr_cipher_data) {
			NDR_PULL_ALLOC(ndr, r->cipher_data);
		} else {
			r->cipher_data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->cipher_data) {
			_mem_save_cipher_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->cipher_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->cipher_data));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->cipher_data));
			size_cipher_data_1 = ndr_get_array_size(ndr, &r->cipher_data);
			length_cipher_data_1 = ndr_get_array_length(ndr, &r->cipher_data);
			if (length_cipher_data_1 > size_cipher_data_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_cipher_data_1, length_cipher_data_1);
			}
			NDR_PULL_ALLOC_N(ndr, r->cipher_data, size_cipher_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->cipher_data, length_cipher_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cipher_data_0, 0);
		}
		if (r->cipher_data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->cipher_data, r->maxlen));
		}
		if (r->cipher_data) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->cipher_data, r->len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_CIPHER_VALUE(struct ndr_print *ndr, const char *name, const struct netr_CIPHER_VALUE *r)
{
	ndr_print_struct(ndr, name, "netr_CIPHER_VALUE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "len", r->len);
	ndr_print_uint32(ndr, "maxlen", r->maxlen);
	ndr_print_ptr(ndr, "cipher_data", r->cipher_data);
	ndr->depth++;
	if (r->cipher_data) {
		ndr_print_array_uint8(ndr, "cipher_data", r->cipher_data, r->len);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_SECRET(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_SECRET *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_CIPHER_VALUE(ndr, NDR_SCALARS, &r->current_cipher));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->current_cipher_set_time));
		NDR_CHECK(ndr_push_netr_CIPHER_VALUE(ndr, NDR_SCALARS, &r->old_cipher));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->old_cipher_set_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SecurityInformation));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_CIPHER_VALUE(ndr, NDR_BUFFERS, &r->current_cipher));
		NDR_CHECK(ndr_push_netr_CIPHER_VALUE(ndr, NDR_BUFFERS, &r->old_cipher));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_SECRET(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_SECRET *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_CIPHER_VALUE(ndr, NDR_SCALARS, &r->current_cipher));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->current_cipher_set_time));
		NDR_CHECK(ndr_pull_netr_CIPHER_VALUE(ndr, NDR_SCALARS, &r->old_cipher));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->old_cipher_set_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SecurityInformation));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_CIPHER_VALUE(ndr, NDR_BUFFERS, &r->current_cipher));
		NDR_CHECK(ndr_pull_netr_CIPHER_VALUE(ndr, NDR_BUFFERS, &r->old_cipher));
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sdbuf));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown1));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown2));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->unknown4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_SECRET(struct ndr_print *ndr, const char *name, const struct netr_DELTA_SECRET *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_SECRET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_CIPHER_VALUE(ndr, "current_cipher", &r->current_cipher);
	ndr_print_NTTIME(ndr, "current_cipher_set_time", r->current_cipher_set_time);
	ndr_print_netr_CIPHER_VALUE(ndr, "old_cipher", &r->old_cipher);
	ndr_print_NTTIME(ndr, "old_cipher_set_time", r->old_cipher_set_time);
	ndr_print_uint32(ndr, "SecurityInformation", r->SecurityInformation);
	ndr_print_sec_desc_buf(ndr, "sdbuf", &r->sdbuf);
	ndr_print_lsa_String(ndr, "unknown1", &r->unknown1);
	ndr_print_lsa_String(ndr, "unknown2", &r->unknown2);
	ndr_print_lsa_String(ndr, "unknown3", &r->unknown3);
	ndr_print_lsa_String(ndr, "unknown4", &r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_uint32(ndr, "unknown7", r->unknown7);
	ndr_print_uint32(ndr, "unknown8", r->unknown8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DeltaEnum(struct ndr_push *ndr, int ndr_flags, enum netr_DeltaEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DeltaEnum(struct ndr_pull *ndr, int ndr_flags, enum netr_DeltaEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DeltaEnum(struct ndr_print *ndr, const char *name, enum netr_DeltaEnum r)
{
	const char *val = NULL;

	switch (r) {
		case NETR_DELTA_DOMAIN: val = "NETR_DELTA_DOMAIN"; break;
		case NETR_DELTA_GROUP: val = "NETR_DELTA_GROUP"; break;
		case NETR_DELTA_DELETE_GROUP: val = "NETR_DELTA_DELETE_GROUP"; break;
		case NETR_DELTA_RENAME_GROUP: val = "NETR_DELTA_RENAME_GROUP"; break;
		case NETR_DELTA_USER: val = "NETR_DELTA_USER"; break;
		case NETR_DELTA_DELETE_USER: val = "NETR_DELTA_DELETE_USER"; break;
		case NETR_DELTA_RENAME_USER: val = "NETR_DELTA_RENAME_USER"; break;
		case NETR_DELTA_GROUP_MEMBER: val = "NETR_DELTA_GROUP_MEMBER"; break;
		case NETR_DELTA_ALIAS: val = "NETR_DELTA_ALIAS"; break;
		case NETR_DELTA_DELETE_ALIAS: val = "NETR_DELTA_DELETE_ALIAS"; break;
		case NETR_DELTA_RENAME_ALIAS: val = "NETR_DELTA_RENAME_ALIAS"; break;
		case NETR_DELTA_ALIAS_MEMBER: val = "NETR_DELTA_ALIAS_MEMBER"; break;
		case NETR_DELTA_POLICY: val = "NETR_DELTA_POLICY"; break;
		case NETR_DELTA_TRUSTED_DOMAIN: val = "NETR_DELTA_TRUSTED_DOMAIN"; break;
		case NETR_DELTA_DELETE_TRUST: val = "NETR_DELTA_DELETE_TRUST"; break;
		case NETR_DELTA_ACCOUNT: val = "NETR_DELTA_ACCOUNT"; break;
		case NETR_DELTA_DELETE_ACCOUNT: val = "NETR_DELTA_DELETE_ACCOUNT"; break;
		case NETR_DELTA_SECRET: val = "NETR_DELTA_SECRET"; break;
		case NETR_DELTA_DELETE_SECRET: val = "NETR_DELTA_DELETE_SECRET"; break;
		case NETR_DELTA_DELETE_GROUP2: val = "NETR_DELTA_DELETE_GROUP2"; break;
		case NETR_DELTA_DELETE_USER2: val = "NETR_DELTA_DELETE_USER2"; break;
		case NETR_DELTA_MODIFY_COUNT: val = "NETR_DELTA_MODIFY_COUNT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_DELTA_UNION(struct ndr_push *ndr, int ndr_flags, const union netr_DELTA_UNION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_DeltaEnum(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case NETR_DELTA_DOMAIN: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETR_DELTA_GROUP: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->group));
			break; }

			case NETR_DELTA_DELETE_GROUP: {
			break; }

			case NETR_DELTA_RENAME_GROUP: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->rename_group));
			break; }

			case NETR_DELTA_USER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
			break; }

			case NETR_DELTA_DELETE_USER: {
			break; }

			case NETR_DELTA_RENAME_USER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->rename_user));
			break; }

			case NETR_DELTA_GROUP_MEMBER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->group_member));
			break; }

			case NETR_DELTA_ALIAS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->alias));
			break; }

			case NETR_DELTA_DELETE_ALIAS: {
			break; }

			case NETR_DELTA_RENAME_ALIAS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->rename_alias));
			break; }

			case NETR_DELTA_ALIAS_MEMBER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->alias_member));
			break; }

			case NETR_DELTA_POLICY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->policy));
			break; }

			case NETR_DELTA_TRUSTED_DOMAIN: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->trusted_domain));
			break; }

			case NETR_DELTA_DELETE_TRUST: {
			break; }

			case NETR_DELTA_ACCOUNT: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->account));
			break; }

			case NETR_DELTA_DELETE_ACCOUNT: {
			break; }

			case NETR_DELTA_SECRET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->secret));
			break; }

			case NETR_DELTA_DELETE_SECRET: {
			break; }

			case NETR_DELTA_DELETE_GROUP2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->delete_group));
			break; }

			case NETR_DELTA_DELETE_USER2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->delete_user));
			break; }

			case NETR_DELTA_MODIFY_COUNT: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->modified_count));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETR_DELTA_DOMAIN:
				if (r->domain) {
					NDR_CHECK(ndr_push_netr_DELTA_DOMAIN(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
				}
			break;

			case NETR_DELTA_GROUP:
				if (r->group) {
					NDR_CHECK(ndr_push_netr_DELTA_GROUP(ndr, NDR_SCALARS|NDR_BUFFERS, r->group));
				}
			break;

			case NETR_DELTA_DELETE_GROUP:
			break;

			case NETR_DELTA_RENAME_GROUP:
				if (r->rename_group) {
					NDR_CHECK(ndr_push_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_group));
				}
			break;

			case NETR_DELTA_USER:
				if (r->user) {
					NDR_CHECK(ndr_push_netr_DELTA_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user));
				}
			break;

			case NETR_DELTA_DELETE_USER:
			break;

			case NETR_DELTA_RENAME_USER:
				if (r->rename_user) {
					NDR_CHECK(ndr_push_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_user));
				}
			break;

			case NETR_DELTA_GROUP_MEMBER:
				if (r->group_member) {
					NDR_CHECK(ndr_push_netr_DELTA_GROUP_MEMBER(ndr, NDR_SCALARS|NDR_BUFFERS, r->group_member));
				}
			break;

			case NETR_DELTA_ALIAS:
				if (r->alias) {
					NDR_CHECK(ndr_push_netr_DELTA_ALIAS(ndr, NDR_SCALARS|NDR_BUFFERS, r->alias));
				}
			break;

			case NETR_DELTA_DELETE_ALIAS:
			break;

			case NETR_DELTA_RENAME_ALIAS:
				if (r->rename_alias) {
					NDR_CHECK(ndr_push_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_alias));
				}
			break;

			case NETR_DELTA_ALIAS_MEMBER:
				if (r->alias_member) {
					NDR_CHECK(ndr_push_netr_DELTA_ALIAS_MEMBER(ndr, NDR_SCALARS|NDR_BUFFERS, r->alias_member));
				}
			break;

			case NETR_DELTA_POLICY:
				if (r->policy) {
					NDR_CHECK(ndr_push_netr_DELTA_POLICY(ndr, NDR_SCALARS|NDR_BUFFERS, r->policy));
				}
			break;

			case NETR_DELTA_TRUSTED_DOMAIN:
				if (r->trusted_domain) {
					NDR_CHECK(ndr_push_netr_DELTA_TRUSTED_DOMAIN(ndr, NDR_SCALARS|NDR_BUFFERS, r->trusted_domain));
				}
			break;

			case NETR_DELTA_DELETE_TRUST:
			break;

			case NETR_DELTA_ACCOUNT:
				if (r->account) {
					NDR_CHECK(ndr_push_netr_DELTA_ACCOUNT(ndr, NDR_SCALARS|NDR_BUFFERS, r->account));
				}
			break;

			case NETR_DELTA_DELETE_ACCOUNT:
			break;

			case NETR_DELTA_SECRET:
				if (r->secret) {
					NDR_CHECK(ndr_push_netr_DELTA_SECRET(ndr, NDR_SCALARS|NDR_BUFFERS, r->secret));
				}
			break;

			case NETR_DELTA_DELETE_SECRET:
			break;

			case NETR_DELTA_DELETE_GROUP2:
				if (r->delete_group) {
					NDR_CHECK(ndr_push_netr_DELTA_DELETE_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_group));
				}
			break;

			case NETR_DELTA_DELETE_USER2:
				if (r->delete_user) {
					NDR_CHECK(ndr_push_netr_DELTA_DELETE_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_user));
				}
			break;

			case NETR_DELTA_MODIFY_COUNT:
				if (r->modified_count) {
					NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, *r->modified_count));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_UNION(struct ndr_pull *ndr, int ndr_flags, union netr_DELTA_UNION *r)
{
	uint32_t level;
	uint16_t _level;
	TALLOC_CTX *_mem_save_domain_0;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_group_0;
	uint32_t _ptr_group;
	TALLOC_CTX *_mem_save_rename_group_0;
	uint32_t _ptr_rename_group;
	TALLOC_CTX *_mem_save_user_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_rename_user_0;
	uint32_t _ptr_rename_user;
	TALLOC_CTX *_mem_save_group_member_0;
	uint32_t _ptr_group_member;
	TALLOC_CTX *_mem_save_alias_0;
	uint32_t _ptr_alias;
	TALLOC_CTX *_mem_save_rename_alias_0;
	uint32_t _ptr_rename_alias;
	TALLOC_CTX *_mem_save_alias_member_0;
	uint32_t _ptr_alias_member;
	TALLOC_CTX *_mem_save_policy_0;
	uint32_t _ptr_policy;
	TALLOC_CTX *_mem_save_trusted_domain_0;
	uint32_t _ptr_trusted_domain;
	TALLOC_CTX *_mem_save_account_0;
	uint32_t _ptr_account;
	TALLOC_CTX *_mem_save_secret_0;
	uint32_t _ptr_secret;
	TALLOC_CTX *_mem_save_delete_group_0;
	uint32_t _ptr_delete_group;
	TALLOC_CTX *_mem_save_delete_user_0;
	uint32_t _ptr_delete_user;
	TALLOC_CTX *_mem_save_modified_count_0;
	uint32_t _ptr_modified_count;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case NETR_DELTA_DOMAIN: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETR_DELTA_GROUP: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group));
				if (_ptr_group) {
					NDR_PULL_ALLOC(ndr, r->group);
				} else {
					r->group = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_GROUP: {
			break; }

			case NETR_DELTA_RENAME_GROUP: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rename_group));
				if (_ptr_rename_group) {
					NDR_PULL_ALLOC(ndr, r->rename_group);
				} else {
					r->rename_group = NULL;
				}
			break; }

			case NETR_DELTA_USER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
				if (_ptr_user) {
					NDR_PULL_ALLOC(ndr, r->user);
				} else {
					r->user = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_USER: {
			break; }

			case NETR_DELTA_RENAME_USER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rename_user));
				if (_ptr_rename_user) {
					NDR_PULL_ALLOC(ndr, r->rename_user);
				} else {
					r->rename_user = NULL;
				}
			break; }

			case NETR_DELTA_GROUP_MEMBER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_member));
				if (_ptr_group_member) {
					NDR_PULL_ALLOC(ndr, r->group_member);
				} else {
					r->group_member = NULL;
				}
			break; }

			case NETR_DELTA_ALIAS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alias));
				if (_ptr_alias) {
					NDR_PULL_ALLOC(ndr, r->alias);
				} else {
					r->alias = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_ALIAS: {
			break; }

			case NETR_DELTA_RENAME_ALIAS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rename_alias));
				if (_ptr_rename_alias) {
					NDR_PULL_ALLOC(ndr, r->rename_alias);
				} else {
					r->rename_alias = NULL;
				}
			break; }

			case NETR_DELTA_ALIAS_MEMBER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alias_member));
				if (_ptr_alias_member) {
					NDR_PULL_ALLOC(ndr, r->alias_member);
				} else {
					r->alias_member = NULL;
				}
			break; }

			case NETR_DELTA_POLICY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_policy));
				if (_ptr_policy) {
					NDR_PULL_ALLOC(ndr, r->policy);
				} else {
					r->policy = NULL;
				}
			break; }

			case NETR_DELTA_TRUSTED_DOMAIN: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_domain));
				if (_ptr_trusted_domain) {
					NDR_PULL_ALLOC(ndr, r->trusted_domain);
				} else {
					r->trusted_domain = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_TRUST: {
			break; }

			case NETR_DELTA_ACCOUNT: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account));
				if (_ptr_account) {
					NDR_PULL_ALLOC(ndr, r->account);
				} else {
					r->account = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_ACCOUNT: {
			break; }

			case NETR_DELTA_SECRET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secret));
				if (_ptr_secret) {
					NDR_PULL_ALLOC(ndr, r->secret);
				} else {
					r->secret = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_SECRET: {
			break; }

			case NETR_DELTA_DELETE_GROUP2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delete_group));
				if (_ptr_delete_group) {
					NDR_PULL_ALLOC(ndr, r->delete_group);
				} else {
					r->delete_group = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_USER2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delete_user));
				if (_ptr_delete_user) {
					NDR_PULL_ALLOC(ndr, r->delete_user);
				} else {
					r->delete_user = NULL;
				}
			break; }

			case NETR_DELTA_MODIFY_COUNT: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_modified_count));
				if (_ptr_modified_count) {
					NDR_PULL_ALLOC(ndr, r->modified_count);
				} else {
					r->modified_count = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NETR_DELTA_DOMAIN:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_DOMAIN(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETR_DELTA_GROUP:
				if (r->group) {
					_mem_save_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->group, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_GROUP(ndr, NDR_SCALARS|NDR_BUFFERS, r->group));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_GROUP:
			break;

			case NETR_DELTA_RENAME_GROUP:
				if (r->rename_group) {
					_mem_save_rename_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->rename_group, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_group));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rename_group_0, 0);
				}
			break;

			case NETR_DELTA_USER:
				if (r->user) {
					_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->user));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_USER:
			break;

			case NETR_DELTA_RENAME_USER:
				if (r->rename_user) {
					_mem_save_rename_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->rename_user, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_user));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rename_user_0, 0);
				}
			break;

			case NETR_DELTA_GROUP_MEMBER:
				if (r->group_member) {
					_mem_save_group_member_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->group_member, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_GROUP_MEMBER(ndr, NDR_SCALARS|NDR_BUFFERS, r->group_member));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_member_0, 0);
				}
			break;

			case NETR_DELTA_ALIAS:
				if (r->alias) {
					_mem_save_alias_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->alias, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_ALIAS(ndr, NDR_SCALARS|NDR_BUFFERS, r->alias));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_ALIAS:
			break;

			case NETR_DELTA_RENAME_ALIAS:
				if (r->rename_alias) {
					_mem_save_rename_alias_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->rename_alias, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_RENAME(ndr, NDR_SCALARS|NDR_BUFFERS, r->rename_alias));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rename_alias_0, 0);
				}
			break;

			case NETR_DELTA_ALIAS_MEMBER:
				if (r->alias_member) {
					_mem_save_alias_member_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->alias_member, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_ALIAS_MEMBER(ndr, NDR_SCALARS|NDR_BUFFERS, r->alias_member));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alias_member_0, 0);
				}
			break;

			case NETR_DELTA_POLICY:
				if (r->policy) {
					_mem_save_policy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->policy, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_POLICY(ndr, NDR_SCALARS|NDR_BUFFERS, r->policy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_0, 0);
				}
			break;

			case NETR_DELTA_TRUSTED_DOMAIN:
				if (r->trusted_domain) {
					_mem_save_trusted_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->trusted_domain, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_TRUSTED_DOMAIN(ndr, NDR_SCALARS|NDR_BUFFERS, r->trusted_domain));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_TRUST:
			break;

			case NETR_DELTA_ACCOUNT:
				if (r->account) {
					_mem_save_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->account, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_ACCOUNT(ndr, NDR_SCALARS|NDR_BUFFERS, r->account));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_ACCOUNT:
			break;

			case NETR_DELTA_SECRET:
				if (r->secret) {
					_mem_save_secret_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->secret, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_SECRET(ndr, NDR_SCALARS|NDR_BUFFERS, r->secret));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secret_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_SECRET:
			break;

			case NETR_DELTA_DELETE_GROUP2:
				if (r->delete_group) {
					_mem_save_delete_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->delete_group, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_DELETE_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_group));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_group_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_USER2:
				if (r->delete_user) {
					_mem_save_delete_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->delete_user, 0);
					NDR_CHECK(ndr_pull_netr_DELTA_DELETE_USER(ndr, NDR_SCALARS|NDR_BUFFERS, r->delete_user));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delete_user_0, 0);
				}
			break;

			case NETR_DELTA_MODIFY_COUNT:
				if (r->modified_count) {
					_mem_save_modified_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->modified_count, 0);
					NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, r->modified_count));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_modified_count_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_UNION(struct ndr_print *ndr, const char *name, const union netr_DELTA_UNION *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_DELTA_UNION");
	switch (level) {
		case NETR_DELTA_DOMAIN:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_netr_DELTA_DOMAIN(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_GROUP:
			ndr_print_ptr(ndr, "group", r->group);
			ndr->depth++;
			if (r->group) {
				ndr_print_netr_DELTA_GROUP(ndr, "group", r->group);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_GROUP:
		break;

		case NETR_DELTA_RENAME_GROUP:
			ndr_print_ptr(ndr, "rename_group", r->rename_group);
			ndr->depth++;
			if (r->rename_group) {
				ndr_print_netr_DELTA_RENAME(ndr, "rename_group", r->rename_group);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_USER:
			ndr_print_ptr(ndr, "user", r->user);
			ndr->depth++;
			if (r->user) {
				ndr_print_netr_DELTA_USER(ndr, "user", r->user);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_USER:
		break;

		case NETR_DELTA_RENAME_USER:
			ndr_print_ptr(ndr, "rename_user", r->rename_user);
			ndr->depth++;
			if (r->rename_user) {
				ndr_print_netr_DELTA_RENAME(ndr, "rename_user", r->rename_user);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_GROUP_MEMBER:
			ndr_print_ptr(ndr, "group_member", r->group_member);
			ndr->depth++;
			if (r->group_member) {
				ndr_print_netr_DELTA_GROUP_MEMBER(ndr, "group_member", r->group_member);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_ALIAS:
			ndr_print_ptr(ndr, "alias", r->alias);
			ndr->depth++;
			if (r->alias) {
				ndr_print_netr_DELTA_ALIAS(ndr, "alias", r->alias);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_ALIAS:
		break;

		case NETR_DELTA_RENAME_ALIAS:
			ndr_print_ptr(ndr, "rename_alias", r->rename_alias);
			ndr->depth++;
			if (r->rename_alias) {
				ndr_print_netr_DELTA_RENAME(ndr, "rename_alias", r->rename_alias);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_ALIAS_MEMBER:
			ndr_print_ptr(ndr, "alias_member", r->alias_member);
			ndr->depth++;
			if (r->alias_member) {
				ndr_print_netr_DELTA_ALIAS_MEMBER(ndr, "alias_member", r->alias_member);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_POLICY:
			ndr_print_ptr(ndr, "policy", r->policy);
			ndr->depth++;
			if (r->policy) {
				ndr_print_netr_DELTA_POLICY(ndr, "policy", r->policy);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			ndr_print_ptr(ndr, "trusted_domain", r->trusted_domain);
			ndr->depth++;
			if (r->trusted_domain) {
				ndr_print_netr_DELTA_TRUSTED_DOMAIN(ndr, "trusted_domain", r->trusted_domain);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_TRUST:
		break;

		case NETR_DELTA_ACCOUNT:
			ndr_print_ptr(ndr, "account", r->account);
			ndr->depth++;
			if (r->account) {
				ndr_print_netr_DELTA_ACCOUNT(ndr, "account", r->account);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_ACCOUNT:
		break;

		case NETR_DELTA_SECRET:
			ndr_print_ptr(ndr, "secret", r->secret);
			ndr->depth++;
			if (r->secret) {
				ndr_print_netr_DELTA_SECRET(ndr, "secret", r->secret);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_SECRET:
		break;

		case NETR_DELTA_DELETE_GROUP2:
			ndr_print_ptr(ndr, "delete_group", r->delete_group);
			ndr->depth++;
			if (r->delete_group) {
				ndr_print_netr_DELTA_DELETE_USER(ndr, "delete_group", r->delete_group);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_USER2:
			ndr_print_ptr(ndr, "delete_user", r->delete_user);
			ndr->depth++;
			if (r->delete_user) {
				ndr_print_netr_DELTA_DELETE_USER(ndr, "delete_user", r->delete_user);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_MODIFY_COUNT:
			ndr_print_ptr(ndr, "modified_count", r->modified_count);
			ndr->depth++;
			if (r->modified_count) {
				ndr_print_udlong(ndr, "modified_count", *r->modified_count);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_netr_DELTA_ID_UNION(struct ndr_push *ndr, int ndr_flags, const union netr_DELTA_ID_UNION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_DeltaEnum(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case NETR_DELTA_DOMAIN: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_GROUP: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_DELETE_GROUP: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_RENAME_GROUP: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_USER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_DELETE_USER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_RENAME_USER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_GROUP_MEMBER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_ALIAS: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_DELETE_ALIAS: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_RENAME_ALIAS: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_ALIAS_MEMBER: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_POLICY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
			break; }

			case NETR_DELTA_TRUSTED_DOMAIN: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
			break; }

			case NETR_DELTA_DELETE_TRUST: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
			break; }

			case NETR_DELTA_ACCOUNT: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
			break; }

			case NETR_DELTA_DELETE_ACCOUNT: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
			break; }

			case NETR_DELTA_SECRET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
			break; }

			case NETR_DELTA_DELETE_SECRET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
			break; }

			case NETR_DELTA_DELETE_GROUP2: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_DELETE_USER2: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
			break; }

			case NETR_DELTA_MODIFY_COUNT: {
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETR_DELTA_DOMAIN:
			break;

			case NETR_DELTA_GROUP:
			break;

			case NETR_DELTA_DELETE_GROUP:
			break;

			case NETR_DELTA_RENAME_GROUP:
			break;

			case NETR_DELTA_USER:
			break;

			case NETR_DELTA_DELETE_USER:
			break;

			case NETR_DELTA_RENAME_USER:
			break;

			case NETR_DELTA_GROUP_MEMBER:
			break;

			case NETR_DELTA_ALIAS:
			break;

			case NETR_DELTA_DELETE_ALIAS:
			break;

			case NETR_DELTA_RENAME_ALIAS:
			break;

			case NETR_DELTA_ALIAS_MEMBER:
			break;

			case NETR_DELTA_POLICY:
				if (r->sid) {
					NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
				}
			break;

			case NETR_DELTA_TRUSTED_DOMAIN:
				if (r->sid) {
					NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
				}
			break;

			case NETR_DELTA_DELETE_TRUST:
				if (r->sid) {
					NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
				}
			break;

			case NETR_DELTA_ACCOUNT:
				if (r->sid) {
					NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
				}
			break;

			case NETR_DELTA_DELETE_ACCOUNT:
				if (r->sid) {
					NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
				}
			break;

			case NETR_DELTA_SECRET:
				if (r->name) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETR_DELTA_DELETE_SECRET:
				if (r->name) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETR_DELTA_DELETE_GROUP2:
			break;

			case NETR_DELTA_DELETE_USER2:
			break;

			case NETR_DELTA_MODIFY_COUNT:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ID_UNION(struct ndr_pull *ndr, int ndr_flags, union netr_DELTA_ID_UNION *r)
{
	uint32_t level;
	uint16_t _level;
	TALLOC_CTX *_mem_save_sid_0;
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_name;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case NETR_DELTA_DOMAIN: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_GROUP: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_DELETE_GROUP: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_RENAME_GROUP: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_USER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_DELETE_USER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_RENAME_USER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_GROUP_MEMBER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_ALIAS: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_DELETE_ALIAS: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_RENAME_ALIAS: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_ALIAS_MEMBER: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_POLICY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
				if (_ptr_sid) {
					NDR_PULL_ALLOC(ndr, r->sid);
				} else {
					r->sid = NULL;
				}
			break; }

			case NETR_DELTA_TRUSTED_DOMAIN: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
				if (_ptr_sid) {
					NDR_PULL_ALLOC(ndr, r->sid);
				} else {
					r->sid = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_TRUST: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
				if (_ptr_sid) {
					NDR_PULL_ALLOC(ndr, r->sid);
				} else {
					r->sid = NULL;
				}
			break; }

			case NETR_DELTA_ACCOUNT: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
				if (_ptr_sid) {
					NDR_PULL_ALLOC(ndr, r->sid);
				} else {
					r->sid = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_ACCOUNT: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
				if (_ptr_sid) {
					NDR_PULL_ALLOC(ndr, r->sid);
				} else {
					r->sid = NULL;
				}
			break; }

			case NETR_DELTA_SECRET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
				if (_ptr_name) {
					NDR_PULL_ALLOC(ndr, r->name);
				} else {
					r->name = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_SECRET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
				if (_ptr_name) {
					NDR_PULL_ALLOC(ndr, r->name);
				} else {
					r->name = NULL;
				}
			break; }

			case NETR_DELTA_DELETE_GROUP2: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_DELETE_USER2: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
			break; }

			case NETR_DELTA_MODIFY_COUNT: {
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NETR_DELTA_DOMAIN:
			break;

			case NETR_DELTA_GROUP:
			break;

			case NETR_DELTA_DELETE_GROUP:
			break;

			case NETR_DELTA_RENAME_GROUP:
			break;

			case NETR_DELTA_USER:
			break;

			case NETR_DELTA_DELETE_USER:
			break;

			case NETR_DELTA_RENAME_USER:
			break;

			case NETR_DELTA_GROUP_MEMBER:
			break;

			case NETR_DELTA_ALIAS:
			break;

			case NETR_DELTA_DELETE_ALIAS:
			break;

			case NETR_DELTA_RENAME_ALIAS:
			break;

			case NETR_DELTA_ALIAS_MEMBER:
			break;

			case NETR_DELTA_POLICY:
				if (r->sid) {
					_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
					NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
				}
			break;

			case NETR_DELTA_TRUSTED_DOMAIN:
				if (r->sid) {
					_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
					NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_TRUST:
				if (r->sid) {
					_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
					NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
				}
			break;

			case NETR_DELTA_ACCOUNT:
				if (r->sid) {
					_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
					NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_ACCOUNT:
				if (r->sid) {
					_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
					NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
				}
			break;

			case NETR_DELTA_SECRET:
				if (r->name) {
					_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
					size_name_1 = ndr_get_array_size(ndr, &r->name);
					length_name_1 = ndr_get_array_length(ndr, &r->name);
					if (length_name_1 > size_name_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_1, length_name_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_SECRET:
				if (r->name) {
					_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
					size_name_1 = ndr_get_array_size(ndr, &r->name);
					length_name_1 = ndr_get_array_length(ndr, &r->name);
					if (length_name_1 > size_name_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_name_1, length_name_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
				}
			break;

			case NETR_DELTA_DELETE_GROUP2:
			break;

			case NETR_DELTA_DELETE_USER2:
			break;

			case NETR_DELTA_MODIFY_COUNT:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ID_UNION(struct ndr_print *ndr, const char *name, const union netr_DELTA_ID_UNION *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_DELTA_ID_UNION");
	switch (level) {
		case NETR_DELTA_DOMAIN:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_GROUP:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_DELETE_GROUP:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_RENAME_GROUP:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_USER:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_DELETE_USER:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_RENAME_USER:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_GROUP_MEMBER:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_ALIAS:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_DELETE_ALIAS:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_RENAME_ALIAS:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_ALIAS_MEMBER:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_POLICY:
			ndr_print_ptr(ndr, "sid", r->sid);
			ndr->depth++;
			if (r->sid) {
				ndr_print_dom_sid2(ndr, "sid", r->sid);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			ndr_print_ptr(ndr, "sid", r->sid);
			ndr->depth++;
			if (r->sid) {
				ndr_print_dom_sid2(ndr, "sid", r->sid);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_TRUST:
			ndr_print_ptr(ndr, "sid", r->sid);
			ndr->depth++;
			if (r->sid) {
				ndr_print_dom_sid2(ndr, "sid", r->sid);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_ACCOUNT:
			ndr_print_ptr(ndr, "sid", r->sid);
			ndr->depth++;
			if (r->sid) {
				ndr_print_dom_sid2(ndr, "sid", r->sid);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_ACCOUNT:
			ndr_print_ptr(ndr, "sid", r->sid);
			ndr->depth++;
			if (r->sid) {
				ndr_print_dom_sid2(ndr, "sid", r->sid);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_SECRET:
			ndr_print_ptr(ndr, "name", r->name);
			ndr->depth++;
			if (r->name) {
				ndr_print_string(ndr, "name", r->name);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_SECRET:
			ndr_print_ptr(ndr, "name", r->name);
			ndr->depth++;
			if (r->name) {
				ndr_print_string(ndr, "name", r->name);
			}
			ndr->depth--;
		break;

		case NETR_DELTA_DELETE_GROUP2:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_DELETE_USER2:
			ndr_print_uint32(ndr, "rid", r->rid);
		break;

		case NETR_DELTA_MODIFY_COUNT:
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_netr_DELTA_ENUM(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_ENUM *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_DeltaEnum(ndr, NDR_SCALARS, r->delta_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->delta_id_union, r->delta_type));
		NDR_CHECK(ndr_push_netr_DELTA_ID_UNION(ndr, NDR_SCALARS, &r->delta_id_union));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->delta_union, r->delta_type));
		NDR_CHECK(ndr_push_netr_DELTA_UNION(ndr, NDR_SCALARS, &r->delta_union));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_DELTA_ID_UNION(ndr, NDR_BUFFERS, &r->delta_id_union));
		NDR_CHECK(ndr_push_netr_DELTA_UNION(ndr, NDR_BUFFERS, &r->delta_union));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ENUM(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_ENUM *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_DeltaEnum(ndr, NDR_SCALARS, &r->delta_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->delta_id_union, r->delta_type));
		NDR_CHECK(ndr_pull_netr_DELTA_ID_UNION(ndr, NDR_SCALARS, &r->delta_id_union));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->delta_union, r->delta_type));
		NDR_CHECK(ndr_pull_netr_DELTA_UNION(ndr, NDR_SCALARS, &r->delta_union));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_DELTA_ID_UNION(ndr, NDR_BUFFERS, &r->delta_id_union));
		NDR_CHECK(ndr_pull_netr_DELTA_UNION(ndr, NDR_BUFFERS, &r->delta_union));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ENUM(struct ndr_print *ndr, const char *name, const struct netr_DELTA_ENUM *r)
{
	ndr_print_struct(ndr, name, "netr_DELTA_ENUM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_DeltaEnum(ndr, "delta_type", r->delta_type);
	ndr_print_set_switch_value(ndr, &r->delta_id_union, r->delta_type);
	ndr_print_netr_DELTA_ID_UNION(ndr, "delta_id_union", &r->delta_id_union);
	ndr_print_set_switch_value(ndr, &r->delta_union, r->delta_type);
	ndr_print_netr_DELTA_UNION(ndr, "delta_union", &r->delta_union);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DELTA_ENUM_ARRAY(struct ndr_push *ndr, int ndr_flags, const struct netr_DELTA_ENUM_ARRAY *r)
{
	uint32_t cntr_delta_enum_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_deltas));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->delta_enum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->delta_enum) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_deltas));
			for (cntr_delta_enum_1 = 0; cntr_delta_enum_1 < r->num_deltas; cntr_delta_enum_1++) {
				NDR_CHECK(ndr_push_netr_DELTA_ENUM(ndr, NDR_SCALARS, &r->delta_enum[cntr_delta_enum_1]));
			}
			for (cntr_delta_enum_1 = 0; cntr_delta_enum_1 < r->num_deltas; cntr_delta_enum_1++) {
				NDR_CHECK(ndr_push_netr_DELTA_ENUM(ndr, NDR_BUFFERS, &r->delta_enum[cntr_delta_enum_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DELTA_ENUM_ARRAY(struct ndr_pull *ndr, int ndr_flags, struct netr_DELTA_ENUM_ARRAY *r)
{
	uint32_t _ptr_delta_enum;
	uint32_t size_delta_enum_1 = 0;
	uint32_t cntr_delta_enum_1;
	TALLOC_CTX *_mem_save_delta_enum_0;
	TALLOC_CTX *_mem_save_delta_enum_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_deltas));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delta_enum));
		if (_ptr_delta_enum) {
			NDR_PULL_ALLOC(ndr, r->delta_enum);
		} else {
			r->delta_enum = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->delta_enum) {
			_mem_save_delta_enum_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->delta_enum, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->delta_enum));
			size_delta_enum_1 = ndr_get_array_size(ndr, &r->delta_enum);
			NDR_PULL_ALLOC_N(ndr, r->delta_enum, size_delta_enum_1);
			_mem_save_delta_enum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->delta_enum, 0);
			for (cntr_delta_enum_1 = 0; cntr_delta_enum_1 < size_delta_enum_1; cntr_delta_enum_1++) {
				NDR_CHECK(ndr_pull_netr_DELTA_ENUM(ndr, NDR_SCALARS, &r->delta_enum[cntr_delta_enum_1]));
			}
			for (cntr_delta_enum_1 = 0; cntr_delta_enum_1 < size_delta_enum_1; cntr_delta_enum_1++) {
				NDR_CHECK(ndr_pull_netr_DELTA_ENUM(ndr, NDR_BUFFERS, &r->delta_enum[cntr_delta_enum_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_0, 0);
		}
		if (r->delta_enum) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->delta_enum, r->num_deltas));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DELTA_ENUM_ARRAY(struct ndr_print *ndr, const char *name, const struct netr_DELTA_ENUM_ARRAY *r)
{
	uint32_t cntr_delta_enum_1;
	ndr_print_struct(ndr, name, "netr_DELTA_ENUM_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_deltas", r->num_deltas);
	ndr_print_ptr(ndr, "delta_enum", r->delta_enum);
	ndr->depth++;
	if (r->delta_enum) {
		ndr->print(ndr, "%s: ARRAY(%d)", "delta_enum", (int)r->num_deltas);
		ndr->depth++;
		for (cntr_delta_enum_1=0;cntr_delta_enum_1<r->num_deltas;cntr_delta_enum_1++) {
			ndr_print_netr_DELTA_ENUM(ndr, "delta_enum", &r->delta_enum[cntr_delta_enum_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_UAS_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct netr_UAS_INFO_0 *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->computer_name, 16));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timecreated));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_number));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_UAS_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct netr_UAS_INFO_0 *r)
{
	uint32_t size_computer_name_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			size_computer_name_0 = 16;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->computer_name, size_computer_name_0));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timecreated));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_number));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_UAS_INFO_0(struct ndr_print *ndr, const char *name, const struct netr_UAS_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "netr_UAS_INFO_0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "computer_name", r->computer_name, 16);
		ndr_print_uint32(ndr, "timecreated", r->timecreated);
		ndr_print_uint32(ndr, "serial_number", r->serial_number);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_netr_AccountBuffer(struct ndr_push *ndr, int ndr_flags, const struct netr_AccountBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_AccountBuffer(struct ndr_pull *ndr, int ndr_flags, struct netr_AccountBuffer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->blob));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_AccountBuffer(struct ndr_print *ndr, const char *name, const struct netr_AccountBuffer *r)
{
	ndr_print_struct(ndr, name, "netr_AccountBuffer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "blob", r->blob);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_InfoFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_InfoFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_InfoFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_REPLICATION_NEEDED", NETLOGON_REPLICATION_NEEDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_REPLICATION_IN_PROGRESS", NETLOGON_REPLICATION_IN_PROGRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_FULL_SYNC_REPLICATION", NETLOGON_FULL_SYNC_REPLICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_REDO_NEEDED", NETLOGON_REDO_NEEDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_HAS_IP", NETLOGON_HAS_IP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_HAS_TIMESERV", NETLOGON_HAS_TIMESERV, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_DNS_UPDATE_FAILURE", NETLOGON_DNS_UPDATE_FAILURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_VERIFY_STATUS_RETURNED", NETLOGON_VERIFY_STATUS_RETURNED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETLOGON_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct netr_NETLOGON_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_InfoFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->pdc_connection_status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETLOGON_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct netr_NETLOGON_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_InfoFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->pdc_connection_status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETLOGON_INFO_1(struct ndr_print *ndr, const char *name, const struct netr_NETLOGON_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "netr_NETLOGON_INFO_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_InfoFlags(ndr, "flags", r->flags);
	ndr_print_WERROR(ndr, "pdc_connection_status", r->pdc_connection_status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETLOGON_INFO_2(struct ndr_push *ndr, int ndr_flags, const struct netr_NETLOGON_INFO_2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_InfoFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->pdc_connection_status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->trusted_dc_name));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->tc_connection_status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->trusted_dc_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_dc_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_dc_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->trusted_dc_name, ndr_charset_length(r->trusted_dc_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETLOGON_INFO_2(struct ndr_pull *ndr, int ndr_flags, struct netr_NETLOGON_INFO_2 *r)
{
	uint32_t _ptr_trusted_dc_name;
	uint32_t size_trusted_dc_name_1 = 0;
	uint32_t length_trusted_dc_name_1 = 0;
	TALLOC_CTX *_mem_save_trusted_dc_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_InfoFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->pdc_connection_status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_dc_name));
		if (_ptr_trusted_dc_name) {
			NDR_PULL_ALLOC(ndr, r->trusted_dc_name);
		} else {
			r->trusted_dc_name = NULL;
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->tc_connection_status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->trusted_dc_name) {
			_mem_save_trusted_dc_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->trusted_dc_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->trusted_dc_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->trusted_dc_name));
			size_trusted_dc_name_1 = ndr_get_array_size(ndr, &r->trusted_dc_name);
			length_trusted_dc_name_1 = ndr_get_array_length(ndr, &r->trusted_dc_name);
			if (length_trusted_dc_name_1 > size_trusted_dc_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_trusted_dc_name_1, length_trusted_dc_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_trusted_dc_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->trusted_dc_name, length_trusted_dc_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_dc_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETLOGON_INFO_2(struct ndr_print *ndr, const char *name, const struct netr_NETLOGON_INFO_2 *r)
{
	ndr_print_struct(ndr, name, "netr_NETLOGON_INFO_2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_InfoFlags(ndr, "flags", r->flags);
	ndr_print_WERROR(ndr, "pdc_connection_status", r->pdc_connection_status);
	ndr_print_ptr(ndr, "trusted_dc_name", r->trusted_dc_name);
	ndr->depth++;
	if (r->trusted_dc_name) {
		ndr_print_string(ndr, "trusted_dc_name", r->trusted_dc_name);
	}
	ndr->depth--;
	ndr_print_WERROR(ndr, "tc_connection_status", r->tc_connection_status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETLOGON_INFO_3(struct ndr_push *ndr, int ndr_flags, const struct netr_NETLOGON_INFO_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_InfoFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->logon_attempts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETLOGON_INFO_3(struct ndr_pull *ndr, int ndr_flags, struct netr_NETLOGON_INFO_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_InfoFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->logon_attempts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETLOGON_INFO_3(struct ndr_print *ndr, const char *name, const struct netr_NETLOGON_INFO_3 *r)
{
	ndr_print_struct(ndr, name, "netr_NETLOGON_INFO_3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_InfoFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "logon_attempts", r->logon_attempts);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "unknown3", r->unknown3);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETLOGON_INFO_4(struct ndr_push *ndr, int ndr_flags, const struct netr_NETLOGON_INFO_4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->trusted_dc_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->trusted_domain_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->trusted_dc_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_dc_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_dc_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->trusted_dc_name, ndr_charset_length(r->trusted_dc_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->trusted_domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->trusted_domain_name, ndr_charset_length(r->trusted_domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETLOGON_INFO_4(struct ndr_pull *ndr, int ndr_flags, struct netr_NETLOGON_INFO_4 *r)
{
	uint32_t _ptr_trusted_dc_name;
	uint32_t size_trusted_dc_name_1 = 0;
	uint32_t length_trusted_dc_name_1 = 0;
	TALLOC_CTX *_mem_save_trusted_dc_name_0;
	uint32_t _ptr_trusted_domain_name;
	uint32_t size_trusted_domain_name_1 = 0;
	uint32_t length_trusted_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_trusted_domain_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_dc_name));
		if (_ptr_trusted_dc_name) {
			NDR_PULL_ALLOC(ndr, r->trusted_dc_name);
		} else {
			r->trusted_dc_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_domain_name));
		if (_ptr_trusted_domain_name) {
			NDR_PULL_ALLOC(ndr, r->trusted_domain_name);
		} else {
			r->trusted_domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->trusted_dc_name) {
			_mem_save_trusted_dc_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->trusted_dc_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->trusted_dc_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->trusted_dc_name));
			size_trusted_dc_name_1 = ndr_get_array_size(ndr, &r->trusted_dc_name);
			length_trusted_dc_name_1 = ndr_get_array_length(ndr, &r->trusted_dc_name);
			if (length_trusted_dc_name_1 > size_trusted_dc_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_trusted_dc_name_1, length_trusted_dc_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_trusted_dc_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->trusted_dc_name, length_trusted_dc_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_dc_name_0, 0);
		}
		if (r->trusted_domain_name) {
			_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->trusted_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->trusted_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->trusted_domain_name));
			size_trusted_domain_name_1 = ndr_get_array_size(ndr, &r->trusted_domain_name);
			length_trusted_domain_name_1 = ndr_get_array_length(ndr, &r->trusted_domain_name);
			if (length_trusted_domain_name_1 > size_trusted_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_trusted_domain_name_1, length_trusted_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_trusted_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->trusted_domain_name, length_trusted_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETLOGON_INFO_4(struct ndr_print *ndr, const char *name, const struct netr_NETLOGON_INFO_4 *r)
{
	ndr_print_struct(ndr, name, "netr_NETLOGON_INFO_4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "trusted_dc_name", r->trusted_dc_name);
	ndr->depth++;
	if (r->trusted_dc_name) {
		ndr_print_string(ndr, "trusted_dc_name", r->trusted_dc_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "trusted_domain_name", r->trusted_domain_name);
	ndr->depth++;
	if (r->trusted_domain_name) {
		ndr_print_string(ndr, "trusted_domain_name", r->trusted_domain_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_CONTROL_QUERY_INFORMATION(struct ndr_push *ndr, int ndr_flags, const union netr_CONTROL_QUERY_INFORMATION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_netr_NETLOGON_INFO_1(ndr, NDR_SCALARS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_netr_NETLOGON_INFO_2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_netr_NETLOGON_INFO_3(ndr, NDR_SCALARS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_netr_NETLOGON_INFO_4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_CONTROL_QUERY_INFORMATION(struct ndr_pull *ndr, int ndr_flags, union netr_CONTROL_QUERY_INFORMATION *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	uint32_t _ptr_info1;
	TALLOC_CTX *_mem_save_info2_0;
	uint32_t _ptr_info2;
	TALLOC_CTX *_mem_save_info3_0;
	uint32_t _ptr_info3;
	TALLOC_CTX *_mem_save_info4_0;
	uint32_t _ptr_info4;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_netr_NETLOGON_INFO_1(ndr, NDR_SCALARS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_netr_NETLOGON_INFO_2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_netr_NETLOGON_INFO_3(ndr, NDR_SCALARS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_netr_NETLOGON_INFO_4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_CONTROL_QUERY_INFORMATION(struct ndr_print *ndr, const char *name, const union netr_CONTROL_QUERY_INFORMATION *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_CONTROL_QUERY_INFORMATION");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_netr_NETLOGON_INFO_1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_netr_NETLOGON_INFO_2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_netr_NETLOGON_INFO_3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_netr_NETLOGON_INFO_4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_netr_LogonControlCode(struct ndr_push *ndr, int ndr_flags, enum netr_LogonControlCode r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonControlCode(struct ndr_pull *ndr, int ndr_flags, enum netr_LogonControlCode *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonControlCode(struct ndr_print *ndr, const char *name, enum netr_LogonControlCode r)
{
	const char *val = NULL;

	switch (r) {
		case NETLOGON_CONTROL_QUERY: val = "NETLOGON_CONTROL_QUERY"; break;
		case NETLOGON_CONTROL_REPLICATE: val = "NETLOGON_CONTROL_REPLICATE"; break;
		case NETLOGON_CONTROL_SYNCHRONIZE: val = "NETLOGON_CONTROL_SYNCHRONIZE"; break;
		case NETLOGON_CONTROL_PDC_REPLICATE: val = "NETLOGON_CONTROL_PDC_REPLICATE"; break;
		case NETLOGON_CONTROL_REDISCOVER: val = "NETLOGON_CONTROL_REDISCOVER"; break;
		case NETLOGON_CONTROL_TC_QUERY: val = "NETLOGON_CONTROL_TC_QUERY"; break;
		case NETLOGON_CONTROL_TRANSPORT_NOTIFY: val = "NETLOGON_CONTROL_TRANSPORT_NOTIFY"; break;
		case NETLOGON_CONTROL_FIND_USER: val = "NETLOGON_CONTROL_FIND_USER"; break;
		case NETLOGON_CONTROL_CHANGE_PASSWORD: val = "NETLOGON_CONTROL_CHANGE_PASSWORD"; break;
		case NETLOGON_CONTROL_TC_VERIFY: val = "NETLOGON_CONTROL_TC_VERIFY"; break;
		case NETLOGON_CONTROL_FORCE_DNS_REG: val = "NETLOGON_CONTROL_FORCE_DNS_REG"; break;
		case NETLOGON_CONTROL_QUERY_DNS_REG: val = "NETLOGON_CONTROL_QUERY_DNS_REG"; break;
		case NETLOGON_CONTROL_BACKUP_CHANGE_LOG: val = "NETLOGON_CONTROL_BACKUP_CHANGE_LOG"; break;
		case NETLOGON_CONTROL_TRUNCATE_LOG: val = "NETLOGON_CONTROL_TRUNCATE_LOG"; break;
		case NETLOGON_CONTROL_SET_DBFLAG: val = "NETLOGON_CONTROL_SET_DBFLAG"; break;
		case NETLOGON_CONTROL_BREAKPOINT: val = "NETLOGON_CONTROL_BREAKPOINT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_CONTROL_DATA_INFORMATION(struct ndr_push *ndr, int ndr_flags, const union netr_CONTROL_DATA_INFORMATION *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case NETLOGON_CONTROL_REDISCOVER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETLOGON_CONTROL_TC_QUERY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETLOGON_CONTROL_TRANSPORT_NOTIFY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETLOGON_CONTROL_CHANGE_PASSWORD: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETLOGON_CONTROL_TC_VERIFY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
			break; }

			case NETLOGON_CONTROL_FIND_USER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
			break; }

			case NETLOGON_CONTROL_SET_DBFLAG: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->debug_level));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETLOGON_CONTROL_REDISCOVER:
				if (r->domain) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_TC_QUERY:
				if (r->domain) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
				if (r->domain) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_CHANGE_PASSWORD:
				if (r->domain) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_TC_VERIFY:
				if (r->domain) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain, ndr_charset_length(r->domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_FIND_USER:
				if (r->user) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case NETLOGON_CONTROL_SET_DBFLAG:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_CONTROL_DATA_INFORMATION(struct ndr_pull *ndr, int ndr_flags, union netr_CONTROL_DATA_INFORMATION *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_domain_0;
	uint32_t _ptr_domain;
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	TALLOC_CTX *_mem_save_user_0;
	uint32_t _ptr_user;
	uint32_t size_user_1 = 0;
	uint32_t length_user_1 = 0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case NETLOGON_CONTROL_REDISCOVER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETLOGON_CONTROL_TC_QUERY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETLOGON_CONTROL_TRANSPORT_NOTIFY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETLOGON_CONTROL_CHANGE_PASSWORD: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETLOGON_CONTROL_TC_VERIFY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
				if (_ptr_domain) {
					NDR_PULL_ALLOC(ndr, r->domain);
				} else {
					r->domain = NULL;
				}
			break; }

			case NETLOGON_CONTROL_FIND_USER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
				if (_ptr_user) {
					NDR_PULL_ALLOC(ndr, r->user);
				} else {
					r->user = NULL;
				}
			break; }

			case NETLOGON_CONTROL_SET_DBFLAG: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->debug_level));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NETLOGON_CONTROL_REDISCOVER:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
					size_domain_1 = ndr_get_array_size(ndr, &r->domain);
					length_domain_1 = ndr_get_array_length(ndr, &r->domain);
					if (length_domain_1 > size_domain_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETLOGON_CONTROL_TC_QUERY:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
					size_domain_1 = ndr_get_array_size(ndr, &r->domain);
					length_domain_1 = ndr_get_array_length(ndr, &r->domain);
					if (length_domain_1 > size_domain_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
					size_domain_1 = ndr_get_array_size(ndr, &r->domain);
					length_domain_1 = ndr_get_array_length(ndr, &r->domain);
					if (length_domain_1 > size_domain_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETLOGON_CONTROL_CHANGE_PASSWORD:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
					size_domain_1 = ndr_get_array_size(ndr, &r->domain);
					length_domain_1 = ndr_get_array_length(ndr, &r->domain);
					if (length_domain_1 > size_domain_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETLOGON_CONTROL_TC_VERIFY:
				if (r->domain) {
					_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->domain));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->domain));
					size_domain_1 = ndr_get_array_size(ndr, &r->domain);
					length_domain_1 = ndr_get_array_length(ndr, &r->domain);
					if (length_domain_1 > size_domain_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
				}
			break;

			case NETLOGON_CONTROL_FIND_USER:
				if (r->user) {
					_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
					size_user_1 = ndr_get_array_size(ndr, &r->user);
					length_user_1 = ndr_get_array_length(ndr, &r->user);
					if (length_user_1 > size_user_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_user_1, length_user_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_user_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, length_user_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
				}
			break;

			case NETLOGON_CONTROL_SET_DBFLAG:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_CONTROL_DATA_INFORMATION(struct ndr_print *ndr, const char *name, const union netr_CONTROL_DATA_INFORMATION *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_CONTROL_DATA_INFORMATION");
	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_string(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_TC_QUERY:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_string(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_string(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_string(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_TC_VERIFY:
			ndr_print_ptr(ndr, "domain", r->domain);
			ndr->depth++;
			if (r->domain) {
				ndr_print_string(ndr, "domain", r->domain);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_FIND_USER:
			ndr_print_ptr(ndr, "user", r->user);
			ndr->depth++;
			if (r->user) {
				ndr_print_string(ndr, "user", r->user);
			}
			ndr->depth--;
		break;

		case NETLOGON_CONTROL_SET_DBFLAG:
			ndr_print_uint32(ndr, "debug_level", r->debug_level);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_NegotiateFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_NegotiateFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NegotiateFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_ACCOUNT_LOCKOUT", NETLOGON_NEG_ACCOUNT_LOCKOUT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_PERSISTENT_SAMREPL", NETLOGON_NEG_PERSISTENT_SAMREPL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_ARCFOUR", NETLOGON_NEG_ARCFOUR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_PROMOTION_COUNT", NETLOGON_NEG_PROMOTION_COUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_CHANGELOG_BDC", NETLOGON_NEG_CHANGELOG_BDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_FULL_SYNC_REPL", NETLOGON_NEG_FULL_SYNC_REPL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_MULTIPLE_SIDS", NETLOGON_NEG_MULTIPLE_SIDS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_REDO", NETLOGON_NEG_REDO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL", NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_SEND_PASSWORD_INFO_PDC", NETLOGON_NEG_SEND_PASSWORD_INFO_PDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_GENERIC_PASSTHROUGH", NETLOGON_NEG_GENERIC_PASSTHROUGH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_CONCURRENT_RPC", NETLOGON_NEG_CONCURRENT_RPC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL", NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL", NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_STRONG_KEYS", NETLOGON_NEG_STRONG_KEYS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_TRANSITIVE_TRUSTS", NETLOGON_NEG_TRANSITIVE_TRUSTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_DNS_DOMAIN_TRUSTS", NETLOGON_NEG_DNS_DOMAIN_TRUSTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_PASSWORD_SET2", NETLOGON_NEG_PASSWORD_SET2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_GETDOMAININFO", NETLOGON_NEG_GETDOMAININFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_CROSS_FOREST_TRUSTS", NETLOGON_NEG_CROSS_FOREST_TRUSTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION", NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_RODC_PASSTHROUGH", NETLOGON_NEG_RODC_PASSTHROUGH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_SUPPORTS_AES_SHA2", NETLOGON_NEG_SUPPORTS_AES_SHA2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_SUPPORTS_AES", NETLOGON_NEG_SUPPORTS_AES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_AUTHENTICATED_RPC_LSASS", NETLOGON_NEG_AUTHENTICATED_RPC_LSASS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETLOGON_NEG_AUTHENTICATED_RPC", NETLOGON_NEG_AUTHENTICATED_RPC, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SyncStateEnum(struct ndr_push *ndr, int ndr_flags, enum SyncStateEnum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SyncStateEnum(struct ndr_pull *ndr, int ndr_flags, enum SyncStateEnum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SyncStateEnum(struct ndr_print *ndr, const char *name, enum SyncStateEnum r)
{
	const char *val = NULL;

	switch (r) {
		case SYNCSTATE_NORMAL_STATE: val = "SYNCSTATE_NORMAL_STATE"; break;
		case SYNCSTATE_DOMAIN_STATE: val = "SYNCSTATE_DOMAIN_STATE"; break;
		case SYNCSTATE_GROUP_STATE: val = "SYNCSTATE_GROUP_STATE"; break;
		case SYNCSTATE_UAS_BUILT_IN_GROUP_STATE: val = "SYNCSTATE_UAS_BUILT_IN_GROUP_STATE"; break;
		case SYNCSTATE_USER_STATE: val = "SYNCSTATE_USER_STATE"; break;
		case SYNCSTATE_GROUP_MEMBER_STATE: val = "SYNCSTATE_GROUP_MEMBER_STATE"; break;
		case SYNCSTATE_ALIAS_STATE: val = "SYNCSTATE_ALIAS_STATE"; break;
		case SYNCSTATE_ALIAS_MEMBER_STATE: val = "SYNCSTATE_ALIAS_MEMBER_STATE"; break;
		case SYNCSTATE_SAM_DONE_STATE: val = "SYNCSTATE_SAM_DONE_STATE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_ChangeLogFlags(struct ndr_push *ndr, int ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ChangeLogFlags(struct ndr_pull *ndr, int ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ChangeLogFlags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED", NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_CHANGELOG_CHANGED_PASSWORD", NETR_CHANGELOG_CHANGED_PASSWORD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_CHANGELOG_SID_INCLUDED", NETR_CHANGELOG_SID_INCLUDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_CHANGELOG_NAME_INCLUDED", NETR_CHANGELOG_NAME_INCLUDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_CHANGELOG_FIRST_PROMOTION_OBJ", NETR_CHANGELOG_FIRST_PROMOTION_OBJ, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ChangeLogObject(struct ndr_push *ndr, int ndr_flags, const union netr_ChangeLogObject *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 4));
		switch (level) {
			case NETR_CHANGELOG_SID_INCLUDED: {
				NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->object_sid));
			break; }

			case NETR_CHANGELOG_NAME_INCLUDED: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->object_name));
					ndr->flags = _flags_save_string;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case NETR_CHANGELOG_SID_INCLUDED:
			break;

			case NETR_CHANGELOG_NAME_INCLUDED:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ChangeLogObject(struct ndr_pull *ndr, int ndr_flags, union netr_ChangeLogObject *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 4));
		switch (level) {
			case NETR_CHANGELOG_SID_INCLUDED: {
				NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->object_sid));
			break; }

			case NETR_CHANGELOG_NAME_INCLUDED: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->object_name));
					ndr->flags = _flags_save_string;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NETR_CHANGELOG_SID_INCLUDED:
			break;

			case NETR_CHANGELOG_NAME_INCLUDED:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ChangeLogObject(struct ndr_print *ndr, const char *name, const union netr_ChangeLogObject *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_ChangeLogObject");
	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			ndr_print_dom_sid(ndr, "object_sid", &r->object_sid);
		break;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ndr_print_string(ndr, "object_name", r->object_name);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_ChangeLogEntry(struct ndr_push *ndr, int ndr_flags, const struct netr_ChangeLogEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_number1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_number2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->object_rid));
		NDR_CHECK(ndr_push_netr_ChangeLogFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_netr_SamDatabaseID8Bit(ndr, NDR_SCALARS, r->db_index));
		NDR_CHECK(ndr_push_netr_DeltaEnum8Bit(ndr, NDR_SCALARS, r->delta_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->object, r->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED)));
		NDR_CHECK(ndr_push_netr_ChangeLogObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_ChangeLogObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_ChangeLogEntry(struct ndr_pull *ndr, int ndr_flags, struct netr_ChangeLogEntry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_number1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_number2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->object_rid));
		NDR_CHECK(ndr_pull_netr_ChangeLogFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_netr_SamDatabaseID8Bit(ndr, NDR_SCALARS, &r->db_index));
		NDR_CHECK(ndr_pull_netr_DeltaEnum8Bit(ndr, NDR_SCALARS, &r->delta_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->object, r->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED)));
		NDR_CHECK(ndr_pull_netr_ChangeLogObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_ChangeLogObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ChangeLogEntry(struct ndr_print *ndr, const char *name, const struct netr_ChangeLogEntry *r)
{
	ndr_print_struct(ndr, name, "netr_ChangeLogEntry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "serial_number1", r->serial_number1);
	ndr_print_uint32(ndr, "serial_number2", r->serial_number2);
	ndr_print_uint32(ndr, "object_rid", r->object_rid);
	ndr_print_netr_ChangeLogFlags(ndr, "flags", r->flags);
	ndr_print_netr_SamDatabaseID8Bit(ndr, "db_index", r->db_index);
	ndr_print_netr_DeltaEnum8Bit(ndr, "delta_type", r->delta_type);
	ndr_print_set_switch_value(ndr, &r->object, r->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED));
	ndr_print_netr_ChangeLogObject(ndr, "object", &r->object);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_netr_ChangeLogEntry(const struct netr_ChangeLogEntry *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_netr_ChangeLogEntry);
}

static enum ndr_err_code ndr_push_netr_Blob(struct ndr_push *ndr, int ndr_flags, const struct netr_Blob *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_Blob(struct ndr_pull *ndr, int ndr_flags, struct netr_Blob *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			size_data_1 = ndr_get_array_size(ndr, &r->data);
			NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Blob(struct ndr_print *ndr, const char *name, const struct netr_Blob *r)
{
	ndr_print_struct(ndr, name, "netr_Blob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetDCName_flags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetDCName_flags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCName_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_FORCE_REDISCOVERY", DS_FORCE_REDISCOVERY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DIRECTORY_SERVICE_REQUIRED", DS_DIRECTORY_SERVICE_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DIRECTORY_SERVICE_PREFERRED", DS_DIRECTORY_SERVICE_PREFERRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_GC_SERVER_REQUIRED", DS_GC_SERVER_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_PDC_REQUIRED", DS_PDC_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_BACKGROUND_ONLY", DS_BACKGROUND_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_IP_REQUIRED", DS_IP_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_KDC_REQUIRED", DS_KDC_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_TIMESERV_REQUIRED", DS_TIMESERV_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_WRITABLE_REQUIRED", DS_WRITABLE_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_GOOD_TIMESERV_PREFERRED", DS_GOOD_TIMESERV_PREFERRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_AVOID_SELF", DS_AVOID_SELF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_ONLY_LDAP_NEEDED", DS_ONLY_LDAP_NEEDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_IS_FLAT_NAME", DS_IS_FLAT_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_IS_DNS_NAME", DS_IS_DNS_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_TRY_NEXTCLOSEST_SITE", DS_TRY_NEXTCLOSEST_SITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DIRECTORY_SERVICE_6_REQUIRED", DS_DIRECTORY_SERVICE_6_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_WEB_SERVICE_REQUIRED", DS_WEB_SERVICE_REQUIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_RETURN_DNS_NAME", DS_RETURN_DNS_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_RETURN_FLAT_NAME", DS_RETURN_FLAT_NAME, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetDCNameInfo_AddressType(struct ndr_push *ndr, int ndr_flags, enum netr_DsRGetDCNameInfo_AddressType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetDCNameInfo_AddressType(struct ndr_pull *ndr, int ndr_flags, enum netr_DsRGetDCNameInfo_AddressType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCNameInfo_AddressType(struct ndr_print *ndr, const char *name, enum netr_DsRGetDCNameInfo_AddressType r)
{
	const char *val = NULL;

	switch (r) {
		case DS_ADDRESS_TYPE_INET: val = "DS_ADDRESS_TYPE_INET"; break;
		case DS_ADDRESS_TYPE_NETBIOS: val = "DS_ADDRESS_TYPE_NETBIOS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_DsR_DcFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsR_DcFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsR_DcFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_PDC", DS_SERVER_PDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_GC", DS_SERVER_GC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_LDAP", DS_SERVER_LDAP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_DS", DS_SERVER_DS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_KDC", DS_SERVER_KDC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_TIMESERV", DS_SERVER_TIMESERV, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_CLOSEST", DS_SERVER_CLOSEST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_WRITABLE", DS_SERVER_WRITABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_GOOD_TIMESERV", DS_SERVER_GOOD_TIMESERV, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_NDNC", DS_SERVER_NDNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_SELECT_SECRET_DOMAIN_6", DS_SERVER_SELECT_SECRET_DOMAIN_6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_SERVER_FULL_SECRET_DOMAIN_6", DS_SERVER_FULL_SECRET_DOMAIN_6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DNS_CONTROLLER", DS_DNS_CONTROLLER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DNS_DOMAIN", DS_DNS_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DS_DNS_FOREST_ROOT", DS_DNS_FOREST_ROOT, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_DsRGetDCNameInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_DsRGetDCNameInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dc_unc));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dc_address));
		NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo_AddressType(ndr, NDR_SCALARS, r->dc_address_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->forest_name));
		NDR_CHECK(ndr_push_netr_DsR_DcFlags(ndr, NDR_SCALARS, r->dc_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dc_site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_site_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dc_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dc_unc, ndr_charset_length(r->dc_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dc_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dc_address, ndr_charset_length(r->dc_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->forest_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->forest_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->forest_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->forest_name, ndr_charset_length(r->forest_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dc_site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dc_site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dc_site_name, ndr_charset_length(r->dc_site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->client_site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_site_name, ndr_charset_length(r->client_site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_DsRGetDCNameInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_DsRGetDCNameInfo *r)
{
	uint32_t _ptr_dc_unc;
	uint32_t size_dc_unc_1 = 0;
	uint32_t length_dc_unc_1 = 0;
	TALLOC_CTX *_mem_save_dc_unc_0;
	uint32_t _ptr_dc_address;
	uint32_t size_dc_address_1 = 0;
	uint32_t length_dc_address_1 = 0;
	TALLOC_CTX *_mem_save_dc_address_0;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_domain_name_0;
	uint32_t _ptr_forest_name;
	uint32_t size_forest_name_1 = 0;
	uint32_t length_forest_name_1 = 0;
	TALLOC_CTX *_mem_save_forest_name_0;
	uint32_t _ptr_dc_site_name;
	uint32_t size_dc_site_name_1 = 0;
	uint32_t length_dc_site_name_1 = 0;
	TALLOC_CTX *_mem_save_dc_site_name_0;
	uint32_t _ptr_client_site_name;
	uint32_t size_client_site_name_1 = 0;
	uint32_t length_client_site_name_1 = 0;
	TALLOC_CTX *_mem_save_client_site_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dc_unc));
		if (_ptr_dc_unc) {
			NDR_PULL_ALLOC(ndr, r->dc_unc);
		} else {
			r->dc_unc = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dc_address));
		if (_ptr_dc_address) {
			NDR_PULL_ALLOC(ndr, r->dc_address);
		} else {
			r->dc_address = NULL;
		}
		NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo_AddressType(ndr, NDR_SCALARS, &r->dc_address_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_name));
		if (_ptr_forest_name) {
			NDR_PULL_ALLOC(ndr, r->forest_name);
		} else {
			r->forest_name = NULL;
		}
		NDR_CHECK(ndr_pull_netr_DsR_DcFlags(ndr, NDR_SCALARS, &r->dc_flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dc_site_name));
		if (_ptr_dc_site_name) {
			NDR_PULL_ALLOC(ndr, r->dc_site_name);
		} else {
			r->dc_site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_site_name));
		if (_ptr_client_site_name) {
			NDR_PULL_ALLOC(ndr, r->client_site_name);
		} else {
			r->client_site_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dc_unc) {
			_mem_save_dc_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dc_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dc_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dc_unc));
			size_dc_unc_1 = ndr_get_array_size(ndr, &r->dc_unc);
			length_dc_unc_1 = ndr_get_array_length(ndr, &r->dc_unc);
			if (length_dc_unc_1 > size_dc_unc_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dc_unc_1, length_dc_unc_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dc_unc_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dc_unc, length_dc_unc_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_unc_0, 0);
		}
		if (r->dc_address) {
			_mem_save_dc_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dc_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dc_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dc_address));
			size_dc_address_1 = ndr_get_array_size(ndr, &r->dc_address);
			length_dc_address_1 = ndr_get_array_length(ndr, &r->dc_address);
			if (length_dc_address_1 > size_dc_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dc_address_1, length_dc_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dc_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dc_address, length_dc_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_address_0, 0);
		}
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			size_domain_name_1 = ndr_get_array_size(ndr, &r->domain_name);
			length_domain_name_1 = ndr_get_array_length(ndr, &r->domain_name);
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		if (r->forest_name) {
			_mem_save_forest_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->forest_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->forest_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->forest_name));
			size_forest_name_1 = ndr_get_array_size(ndr, &r->forest_name);
			length_forest_name_1 = ndr_get_array_length(ndr, &r->forest_name);
			if (length_forest_name_1 > size_forest_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_forest_name_1, length_forest_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_forest_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->forest_name, length_forest_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_name_0, 0);
		}
		if (r->dc_site_name) {
			_mem_save_dc_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dc_site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dc_site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dc_site_name));
			size_dc_site_name_1 = ndr_get_array_size(ndr, &r->dc_site_name);
			length_dc_site_name_1 = ndr_get_array_length(ndr, &r->dc_site_name);
			if (length_dc_site_name_1 > size_dc_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dc_site_name_1, length_dc_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dc_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dc_site_name, length_dc_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_site_name_0, 0);
		}
		if (r->client_site_name) {
			_mem_save_client_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_site_name));
			size_client_site_name_1 = ndr_get_array_size(ndr, &r->client_site_name);
			length_client_site_name_1 = ndr_get_array_length(ndr, &r->client_site_name);
			if (length_client_site_name_1 > size_client_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_client_site_name_1, length_client_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_client_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_site_name, length_client_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_site_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCNameInfo(struct ndr_print *ndr, const char *name, const struct netr_DsRGetDCNameInfo *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetDCNameInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "dc_unc", r->dc_unc);
	ndr->depth++;
	if (r->dc_unc) {
		ndr_print_string(ndr, "dc_unc", r->dc_unc);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dc_address", r->dc_address);
	ndr->depth++;
	if (r->dc_address) {
		ndr_print_string(ndr, "dc_address", r->dc_address);
	}
	ndr->depth--;
	ndr_print_netr_DsRGetDCNameInfo_AddressType(ndr, "dc_address_type", r->dc_address_type);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "forest_name", r->forest_name);
	ndr->depth++;
	if (r->forest_name) {
		ndr_print_string(ndr, "forest_name", r->forest_name);
	}
	ndr->depth--;
	ndr_print_netr_DsR_DcFlags(ndr, "dc_flags", r->dc_flags);
	ndr_print_ptr(ndr, "dc_site_name", r->dc_site_name);
	ndr->depth++;
	if (r->dc_site_name) {
		ndr_print_string(ndr, "dc_site_name", r->dc_site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "client_site_name", r->client_site_name);
	ndr->depth++;
	if (r->client_site_name) {
		ndr_print_string(ndr, "client_site_name", r->client_site_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_Capabilities(struct ndr_push *ndr, int ndr_flags, const union netr_Capabilities *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, r->server_capabilities));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_Capabilities(struct ndr_pull *ndr, int ndr_flags, union netr_Capabilities *r)
{
	uint32_t level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, &r->server_capabilities));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Capabilities(struct ndr_print *ndr, const char *name, const union netr_Capabilities *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_Capabilities");
	switch (level) {
		case 1:
			ndr_print_netr_NegotiateFlags(ndr, "server_capabilities", r->server_capabilities);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_netr_TrustFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_TrustFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_TrustFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_IN_FOREST", NETR_TRUST_FLAG_IN_FOREST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_OUTBOUND", NETR_TRUST_FLAG_OUTBOUND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_TREEROOT", NETR_TRUST_FLAG_TREEROOT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_PRIMARY", NETR_TRUST_FLAG_PRIMARY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_NATIVE", NETR_TRUST_FLAG_NATIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_INBOUND", NETR_TRUST_FLAG_INBOUND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_MIT_KRB5", NETR_TRUST_FLAG_MIT_KRB5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_FLAG_AES", NETR_TRUST_FLAG_AES, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_WorkstationFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_WorkstationFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_WorkstationFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS", NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_WS_FLAG_HANDLES_SPN_UPDATE", NETR_WS_FLAG_HANDLES_SPN_UPDATE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_SuiteMask(struct ndr_push *ndr, int ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_SuiteMask(struct ndr_pull *ndr, int ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SuiteMask(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_BACKOFFICE", NETR_VER_SUITE_BACKOFFICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_BLADE", NETR_VER_SUITE_BLADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_COMPUTE_SERVER", NETR_VER_SUITE_COMPUTE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_DATACENTER", NETR_VER_SUITE_DATACENTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_ENTERPRISE", NETR_VER_SUITE_ENTERPRISE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_EMBEDDEDNT", NETR_VER_SUITE_EMBEDDEDNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_PERSONAL", NETR_VER_SUITE_PERSONAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_SINGLEUSERTS", NETR_VER_SUITE_SINGLEUSERTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_SMALLBUSINESS", NETR_VER_SUITE_SMALLBUSINESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_SMALLBUSINESS_RESTRICTED", NETR_VER_SUITE_SMALLBUSINESS_RESTRICTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_STORAGE_SERVER", NETR_VER_SUITE_STORAGE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_TERMINAL", NETR_VER_SUITE_TERMINAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "NETR_VER_SUITE_WH_SERVER", NETR_VER_SUITE_WH_SERVER, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ProductType(struct ndr_push *ndr, int ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ProductType(struct ndr_pull *ndr, int ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ProductType(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "NETR_VER_NT_DOMAIN_CONTROLLER", NETR_VER_NT_DOMAIN_CONTROLLER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "NETR_VER_NT_SERVER", NETR_VER_NT_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "NETR_VER_NT_WORKSTATION", NETR_VER_NT_WORKSTATION, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LsaPolicyInformation(struct ndr_push *ndr, int ndr_flags, const struct netr_LsaPolicyInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->policy_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->policy));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->policy) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->policy_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->policy, r->policy_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LsaPolicyInformation(struct ndr_pull *ndr, int ndr_flags, struct netr_LsaPolicyInformation *r)
{
	uint32_t _ptr_policy;
	uint32_t size_policy_1 = 0;
	TALLOC_CTX *_mem_save_policy_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->policy_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_policy));
		if (_ptr_policy) {
			NDR_PULL_ALLOC(ndr, r->policy);
		} else {
			r->policy = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->policy) {
			_mem_save_policy_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->policy, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->policy));
			size_policy_1 = ndr_get_array_size(ndr, &r->policy);
			NDR_PULL_ALLOC_N(ndr, r->policy, size_policy_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->policy, size_policy_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_policy_0, 0);
		}
		if (r->policy) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->policy, r->policy_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LsaPolicyInformation(struct ndr_print *ndr, const char *name, const struct netr_LsaPolicyInformation *r)
{
	ndr_print_struct(ndr, name, "netr_LsaPolicyInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "policy_size", r->policy_size);
	ndr_print_ptr(ndr, "policy", r->policy);
	ndr->depth++;
	if (r->policy) {
		ndr_print_array_uint8(ndr, "policy", r->policy, r->policy_size);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_OsVersionInfoEx(struct ndr_push *ndr, int ndr_flags, const struct netr_OsVersionInfoEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 284));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MajorVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MinorVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->BuildNumber));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->PlatformId));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			{
				struct ndr_push *_ndr_CSDVersion;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_CSDVersion, 0, 256));
				NDR_CHECK(ndr_push_string(_ndr_CSDVersion, NDR_SCALARS, r->CSDVersion));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_CSDVersion, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ServicePackMajor));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ServicePackMinor));
		NDR_CHECK(ndr_push_netr_SuiteMask(ndr, NDR_SCALARS, r->SuiteMask));
		NDR_CHECK(ndr_push_netr_ProductType(ndr, NDR_SCALARS, r->ProductType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Reserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_OsVersionInfoEx(struct ndr_pull *ndr, int ndr_flags, struct netr_OsVersionInfoEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->OSVersionInfoSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MajorVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MinorVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->BuildNumber));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->PlatformId));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			{
				struct ndr_pull *_ndr_CSDVersion;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_CSDVersion, 0, 256));
				NDR_CHECK(ndr_pull_string(_ndr_CSDVersion, NDR_SCALARS, &r->CSDVersion));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_CSDVersion, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ServicePackMajor));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ServicePackMinor));
		NDR_CHECK(ndr_pull_netr_SuiteMask(ndr, NDR_SCALARS, &r->SuiteMask));
		NDR_CHECK(ndr_pull_netr_ProductType(ndr, NDR_SCALARS, &r->ProductType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_OsVersionInfoEx(struct ndr_print *ndr, const char *name, const struct netr_OsVersionInfoEx *r)
{
	ndr_print_struct(ndr, name, "netr_OsVersionInfoEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "OSVersionInfoSize", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?284:r->OSVersionInfoSize);
	ndr_print_uint32(ndr, "MajorVersion", r->MajorVersion);
	ndr_print_uint32(ndr, "MinorVersion", r->MinorVersion);
	ndr_print_uint32(ndr, "BuildNumber", r->BuildNumber);
	ndr_print_uint32(ndr, "PlatformId", r->PlatformId);
	ndr_print_string(ndr, "CSDVersion", r->CSDVersion);
	ndr_print_uint16(ndr, "ServicePackMajor", r->ServicePackMajor);
	ndr_print_uint16(ndr, "ServicePackMinor", r->ServicePackMinor);
	ndr_print_netr_SuiteMask(ndr, "SuiteMask", r->SuiteMask);
	ndr_print_netr_ProductType(ndr, "ProductType", r->ProductType);
	ndr_print_uint8(ndr, "Reserved", r->Reserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_OsVersion(struct ndr_push *ndr, int ndr_flags, const struct netr_OsVersion *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 142));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 142));
		NDR_CHECK(ndr_push_netr_OsVersionInfoEx(ndr, NDR_SCALARS, &r->os));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_OsVersion(struct ndr_pull *ndr, int ndr_flags, struct netr_OsVersion *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_netr_OsVersionInfoEx(ndr, NDR_SCALARS, &r->os));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_OsVersion(struct ndr_print *ndr, const char *name, const struct netr_OsVersion *r)
{
	ndr_print_struct(ndr, name, "netr_OsVersion");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?142:r->length);
	ndr_print_uint32(ndr, "dummy", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->dummy);
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?142:r->size);
	ndr_print_netr_OsVersionInfoEx(ndr, "os", &r->os);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_OsVersionContainer(struct ndr_push *ndr, int ndr_flags, const struct netr_OsVersionContainer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->os == NULL?0:284));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->os == NULL?0:284));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->os));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->os) {
			NDR_CHECK(ndr_push_netr_OsVersion(ndr, NDR_SCALARS, r->os));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_OsVersionContainer(struct ndr_pull *ndr, int ndr_flags, struct netr_OsVersionContainer *r)
{
	uint32_t _ptr_os;
	TALLOC_CTX *_mem_save_os_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_os));
		if (_ptr_os) {
			NDR_PULL_ALLOC(ndr, r->os);
		} else {
			r->os = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->os) {
			_mem_save_os_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->os, 0);
			NDR_CHECK(ndr_pull_netr_OsVersion(ndr, NDR_SCALARS, r->os));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_os_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_OsVersionContainer(struct ndr_print *ndr, const char *name, const struct netr_OsVersionContainer *r)
{
	ndr_print_struct(ndr, name, "netr_OsVersionContainer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->os == NULL?0:284:r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->os == NULL?0:284:r->size);
	ndr_print_ptr(ndr, "os", r->os);
	ndr->depth++;
	if (r->os) {
		ndr_print_netr_OsVersion(ndr, "os", r->os);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_WorkstationInformation(struct ndr_push *ndr, int ndr_flags, const struct netr_WorkstationInformation *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_LsaPolicyInformation(ndr, NDR_SCALARS, &r->lsa_policy));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_hostname));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sitename));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy4));
		NDR_CHECK(ndr_push_netr_OsVersionContainer(ndr, NDR_SCALARS, &r->os_version));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->os_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_push_netr_WorkstationFlags(ndr, NDR_SCALARS, r->workstation_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_LsaPolicyInformation(ndr, NDR_BUFFERS, &r->lsa_policy));
		if (r->dns_hostname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_hostname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_hostname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_hostname, ndr_charset_length(r->dns_hostname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->sitename) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->sitename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->sitename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->sitename, ndr_charset_length(r->sitename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dummy1) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy1, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy1, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dummy1, ndr_charset_length(r->dummy1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dummy2) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy2, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy2, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dummy2, ndr_charset_length(r->dummy2, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dummy3) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy3, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy3, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dummy3, ndr_charset_length(r->dummy3, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dummy4) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy4, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dummy4, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dummy4, ndr_charset_length(r->dummy4, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_OsVersionContainer(ndr, NDR_BUFFERS, &r->os_version));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->os_name));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->dummy_string4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_WorkstationInformation(struct ndr_pull *ndr, int ndr_flags, struct netr_WorkstationInformation *r)
{
	uint32_t _ptr_dns_hostname;
	uint32_t size_dns_hostname_1 = 0;
	uint32_t length_dns_hostname_1 = 0;
	TALLOC_CTX *_mem_save_dns_hostname_0;
	uint32_t _ptr_sitename;
	uint32_t size_sitename_1 = 0;
	uint32_t length_sitename_1 = 0;
	TALLOC_CTX *_mem_save_sitename_0;
	uint32_t _ptr_dummy1;
	uint32_t size_dummy1_1 = 0;
	uint32_t length_dummy1_1 = 0;
	TALLOC_CTX *_mem_save_dummy1_0;
	uint32_t _ptr_dummy2;
	uint32_t size_dummy2_1 = 0;
	uint32_t length_dummy2_1 = 0;
	TALLOC_CTX *_mem_save_dummy2_0;
	uint32_t _ptr_dummy3;
	uint32_t size_dummy3_1 = 0;
	uint32_t length_dummy3_1 = 0;
	TALLOC_CTX *_mem_save_dummy3_0;
	uint32_t _ptr_dummy4;
	uint32_t size_dummy4_1 = 0;
	uint32_t length_dummy4_1 = 0;
	TALLOC_CTX *_mem_save_dummy4_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_LsaPolicyInformation(ndr, NDR_SCALARS, &r->lsa_policy));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_hostname));
		if (_ptr_dns_hostname) {
			NDR_PULL_ALLOC(ndr, r->dns_hostname);
		} else {
			r->dns_hostname = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sitename));
		if (_ptr_sitename) {
			NDR_PULL_ALLOC(ndr, r->sitename);
		} else {
			r->sitename = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy1));
		if (_ptr_dummy1) {
			NDR_PULL_ALLOC(ndr, r->dummy1);
		} else {
			r->dummy1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy2));
		if (_ptr_dummy2) {
			NDR_PULL_ALLOC(ndr, r->dummy2);
		} else {
			r->dummy2 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy3));
		if (_ptr_dummy3) {
			NDR_PULL_ALLOC(ndr, r->dummy3);
		} else {
			r->dummy3 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy4));
		if (_ptr_dummy4) {
			NDR_PULL_ALLOC(ndr, r->dummy4);
		} else {
			r->dummy4 = NULL;
		}
		NDR_CHECK(ndr_pull_netr_OsVersionContainer(ndr, NDR_SCALARS, &r->os_version));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->os_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_pull_netr_WorkstationFlags(ndr, NDR_SCALARS, &r->workstation_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_LsaPolicyInformation(ndr, NDR_BUFFERS, &r->lsa_policy));
		if (r->dns_hostname) {
			_mem_save_dns_hostname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_hostname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_hostname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_hostname));
			size_dns_hostname_1 = ndr_get_array_size(ndr, &r->dns_hostname);
			length_dns_hostname_1 = ndr_get_array_length(ndr, &r->dns_hostname);
			if (length_dns_hostname_1 > size_dns_hostname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_hostname_1, length_dns_hostname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_hostname_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_hostname, length_dns_hostname_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_hostname_0, 0);
		}
		if (r->sitename) {
			_mem_save_sitename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sitename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sitename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->sitename));
			size_sitename_1 = ndr_get_array_size(ndr, &r->sitename);
			length_sitename_1 = ndr_get_array_length(ndr, &r->sitename);
			if (length_sitename_1 > size_sitename_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_sitename_1, length_sitename_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_sitename_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->sitename, length_sitename_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sitename_0, 0);
		}
		if (r->dummy1) {
			_mem_save_dummy1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dummy1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dummy1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dummy1));
			size_dummy1_1 = ndr_get_array_size(ndr, &r->dummy1);
			length_dummy1_1 = ndr_get_array_length(ndr, &r->dummy1);
			if (length_dummy1_1 > size_dummy1_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dummy1_1, length_dummy1_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dummy1_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dummy1, length_dummy1_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy1_0, 0);
		}
		if (r->dummy2) {
			_mem_save_dummy2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dummy2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dummy2));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dummy2));
			size_dummy2_1 = ndr_get_array_size(ndr, &r->dummy2);
			length_dummy2_1 = ndr_get_array_length(ndr, &r->dummy2);
			if (length_dummy2_1 > size_dummy2_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dummy2_1, length_dummy2_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dummy2_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dummy2, length_dummy2_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy2_0, 0);
		}
		if (r->dummy3) {
			_mem_save_dummy3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dummy3, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dummy3));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dummy3));
			size_dummy3_1 = ndr_get_array_size(ndr, &r->dummy3);
			length_dummy3_1 = ndr_get_array_length(ndr, &r->dummy3);
			if (length_dummy3_1 > size_dummy3_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dummy3_1, length_dummy3_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dummy3_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dummy3, length_dummy3_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy3_0, 0);
		}
		if (r->dummy4) {
			_mem_save_dummy4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dummy4, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dummy4));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dummy4));
			size_dummy4_1 = ndr_get_array_size(ndr, &r->dummy4);
			length_dummy4_1 = ndr_get_array_length(ndr, &r->dummy4);
			if (length_dummy4_1 > size_dummy4_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dummy4_1, length_dummy4_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dummy4_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dummy4, length_dummy4_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy4_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_OsVersionContainer(ndr, NDR_BUFFERS, &r->os_version));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->os_name));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->dummy_string4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_WorkstationInformation(struct ndr_print *ndr, const char *name, const struct netr_WorkstationInformation *r)
{
	ndr_print_struct(ndr, name, "netr_WorkstationInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_LsaPolicyInformation(ndr, "lsa_policy", &r->lsa_policy);
	ndr_print_ptr(ndr, "dns_hostname", r->dns_hostname);
	ndr->depth++;
	if (r->dns_hostname) {
		ndr_print_string(ndr, "dns_hostname", r->dns_hostname);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sitename", r->sitename);
	ndr->depth++;
	if (r->sitename) {
		ndr_print_string(ndr, "sitename", r->sitename);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dummy1", r->dummy1);
	ndr->depth++;
	if (r->dummy1) {
		ndr_print_string(ndr, "dummy1", r->dummy1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dummy2", r->dummy2);
	ndr->depth++;
	if (r->dummy2) {
		ndr_print_string(ndr, "dummy2", r->dummy2);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dummy3", r->dummy3);
	ndr->depth++;
	if (r->dummy3) {
		ndr_print_string(ndr, "dummy3", r->dummy3);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dummy4", r->dummy4);
	ndr->depth++;
	if (r->dummy4) {
		ndr_print_string(ndr, "dummy4", r->dummy4);
	}
	ndr->depth--;
	ndr_print_netr_OsVersionContainer(ndr, "os_version", &r->os_version);
	ndr_print_lsa_String(ndr, "os_name", &r->os_name);
	ndr_print_lsa_String(ndr, "dummy_string3", &r->dummy_string3);
	ndr_print_lsa_String(ndr, "dummy_string4", &r->dummy_string4);
	ndr_print_netr_WorkstationFlags(ndr, "workstation_flags", r->workstation_flags);
	ndr_print_uint32(ndr, "dummy_long2", r->dummy_long2);
	ndr_print_uint32(ndr, "dummy_long3", r->dummy_long3);
	ndr_print_uint32(ndr, "dummy_long4", r->dummy_long4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_WorkstationInfo(struct ndr_push *ndr, int ndr_flags, const union netr_WorkstationInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->workstation_info));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->lsa_policy_info));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->workstation_info) {
					NDR_CHECK(ndr_push_netr_WorkstationInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->workstation_info));
				}
			break;

			case 2:
				if (r->lsa_policy_info) {
					NDR_CHECK(ndr_push_netr_WorkstationInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->lsa_policy_info));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_WorkstationInfo(struct ndr_pull *ndr, int ndr_flags, union netr_WorkstationInfo *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_workstation_info_0;
	uint32_t _ptr_workstation_info;
	TALLOC_CTX *_mem_save_lsa_policy_info_0;
	uint32_t _ptr_lsa_policy_info;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_workstation_info));
				if (_ptr_workstation_info) {
					NDR_PULL_ALLOC(ndr, r->workstation_info);
				} else {
					r->workstation_info = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lsa_policy_info));
				if (_ptr_lsa_policy_info) {
					NDR_PULL_ALLOC(ndr, r->lsa_policy_info);
				} else {
					r->lsa_policy_info = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->workstation_info) {
					_mem_save_workstation_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->workstation_info, 0);
					NDR_CHECK(ndr_pull_netr_WorkstationInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->workstation_info));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_workstation_info_0, 0);
				}
			break;

			case 2:
				if (r->lsa_policy_info) {
					_mem_save_lsa_policy_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->lsa_policy_info, 0);
					NDR_CHECK(ndr_pull_netr_WorkstationInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->lsa_policy_info));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lsa_policy_info_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_WorkstationInfo(struct ndr_print *ndr, const char *name, const union netr_WorkstationInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_WorkstationInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "workstation_info", r->workstation_info);
			ndr->depth++;
			if (r->workstation_info) {
				ndr_print_netr_WorkstationInformation(ndr, "workstation_info", r->workstation_info);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "lsa_policy_info", r->lsa_policy_info);
			ndr->depth++;
			if (r->lsa_policy_info) {
				ndr_print_netr_WorkstationInformation(ndr, "lsa_policy_info", r->lsa_policy_info);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_netr_trust_extension(struct ndr_push *ndr, int ndr_flags, const struct netr_trust_extension *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 8));
		NDR_CHECK(ndr_push_netr_TrustFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->parent_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trust_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trust_attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_trust_extension(struct ndr_pull *ndr, int ndr_flags, struct netr_trust_extension *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_netr_TrustFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->parent_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trust_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trust_attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_trust_extension(struct ndr_print *ndr, const char *name, const struct netr_trust_extension *r)
{
	ndr_print_struct(ndr, name, "netr_trust_extension");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?8:r->length);
	ndr_print_uint32(ndr, "dummy", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->dummy);
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?8:r->size);
	ndr_print_netr_TrustFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "parent_index", r->parent_index);
	ndr_print_uint32(ndr, "trust_type", r->trust_type);
	ndr_print_uint32(ndr, "trust_attributes", r->trust_attributes);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_trust_extension_container(struct ndr_push *ndr, int ndr_flags, const struct netr_trust_extension_container *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_netr_trust_extension(ndr, NDR_SCALARS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_trust_extension_container(struct ndr_pull *ndr, int ndr_flags, struct netr_trust_extension_container *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_netr_trust_extension(ndr, NDR_SCALARS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_trust_extension_container(struct ndr_print *ndr, const char *name, const struct netr_trust_extension_container *r)
{
	ndr_print_struct(ndr, name, "netr_trust_extension_container");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->length:r->size);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_netr_trust_extension(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_OneDomainInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_OneDomainInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->domainname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domainname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forestname));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_sid));
		NDR_CHECK(ndr_push_netr_trust_extension_container(ndr, NDR_SCALARS, &r->trust_extension));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string2));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domainname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domainname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forestname));
		if (r->domain_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
		}
		NDR_CHECK(ndr_push_netr_trust_extension_container(ndr, NDR_BUFFERS, &r->trust_extension));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string2));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_OneDomainInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_OneDomainInfo *r)
{
	uint32_t _ptr_domain_sid;
	TALLOC_CTX *_mem_save_domain_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->domainname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_domainname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_forestname));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_sid));
		if (_ptr_domain_sid) {
			NDR_PULL_ALLOC(ndr, r->domain_sid);
		} else {
			r->domain_sid = NULL;
		}
		NDR_CHECK(ndr_pull_netr_trust_extension_container(ndr, NDR_SCALARS, &r->trust_extension));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string2));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->domainname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_domainname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_forestname));
		if (r->domain_sid) {
			_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_trust_extension_container(ndr, NDR_BUFFERS, &r->trust_extension));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string2));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string4));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_OneDomainInfo(struct ndr_print *ndr, const char *name, const struct netr_OneDomainInfo *r)
{
	ndr_print_struct(ndr, name, "netr_OneDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "domainname", &r->domainname);
	ndr_print_lsa_StringLarge(ndr, "dns_domainname", &r->dns_domainname);
	ndr_print_lsa_StringLarge(ndr, "dns_forestname", &r->dns_forestname);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_ptr(ndr, "domain_sid", r->domain_sid);
	ndr->depth++;
	if (r->domain_sid) {
		ndr_print_dom_sid2(ndr, "domain_sid", r->domain_sid);
	}
	ndr->depth--;
	ndr_print_netr_trust_extension_container(ndr, "trust_extension", &r->trust_extension);
	ndr_print_lsa_StringLarge(ndr, "dummy_string2", &r->dummy_string2);
	ndr_print_lsa_StringLarge(ndr, "dummy_string3", &r->dummy_string3);
	ndr_print_lsa_StringLarge(ndr, "dummy_string4", &r->dummy_string4);
	ndr_print_uint32(ndr, "dummy_long1", r->dummy_long1);
	ndr_print_uint32(ndr, "dummy_long2", r->dummy_long2);
	ndr_print_uint32(ndr, "dummy_long3", r->dummy_long3);
	ndr_print_uint32(ndr, "dummy_long4", r->dummy_long4);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_SupportedEncTypes(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_SupportedEncTypes(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SupportedEncTypes(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENC_CRC32", ENC_CRC32, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENC_RSA_MD5", ENC_RSA_MD5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENC_RC4_HMAC_MD5", ENC_RC4_HMAC_MD5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENC_HMAC_SHA1_96_AES128", ENC_HMAC_SHA1_96_AES128, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENC_HMAC_SHA1_96_AES256", ENC_HMAC_SHA1_96_AES256, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DomainInformation(struct ndr_push *ndr, int ndr_flags, const struct netr_DomainInformation *r)
{
	uint32_t cntr_trusted_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_OneDomainInfo(ndr, NDR_SCALARS, &r->primary_domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->trusted_domain_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->trusted_domains));
		NDR_CHECK(ndr_push_netr_LsaPolicyInformation(ndr, NDR_SCALARS, &r->lsa_policy));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_hostname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string2));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_push_netr_WorkstationFlags(ndr, NDR_SCALARS, r->workstation_flags));
		NDR_CHECK(ndr_push_netr_SupportedEncTypes(ndr, NDR_SCALARS, r->supported_enc_types));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy_long4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_OneDomainInfo(ndr, NDR_BUFFERS, &r->primary_domain));
		if (r->trusted_domains) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->trusted_domain_count));
			for (cntr_trusted_domains_1 = 0; cntr_trusted_domains_1 < r->trusted_domain_count; cntr_trusted_domains_1++) {
				NDR_CHECK(ndr_push_netr_OneDomainInfo(ndr, NDR_SCALARS, &r->trusted_domains[cntr_trusted_domains_1]));
			}
			for (cntr_trusted_domains_1 = 0; cntr_trusted_domains_1 < r->trusted_domain_count; cntr_trusted_domains_1++) {
				NDR_CHECK(ndr_push_netr_OneDomainInfo(ndr, NDR_BUFFERS, &r->trusted_domains[cntr_trusted_domains_1]));
			}
		}
		NDR_CHECK(ndr_push_netr_LsaPolicyInformation(ndr, NDR_BUFFERS, &r->lsa_policy));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_hostname));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string2));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string4));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DomainInformation(struct ndr_pull *ndr, int ndr_flags, struct netr_DomainInformation *r)
{
	uint32_t _ptr_trusted_domains;
	uint32_t size_trusted_domains_1 = 0;
	uint32_t cntr_trusted_domains_1;
	TALLOC_CTX *_mem_save_trusted_domains_0;
	TALLOC_CTX *_mem_save_trusted_domains_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_OneDomainInfo(ndr, NDR_SCALARS, &r->primary_domain));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->trusted_domain_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_domains));
		if (_ptr_trusted_domains) {
			NDR_PULL_ALLOC(ndr, r->trusted_domains);
		} else {
			r->trusted_domains = NULL;
		}
		NDR_CHECK(ndr_pull_netr_LsaPolicyInformation(ndr, NDR_SCALARS, &r->lsa_policy));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dns_hostname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string2));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->dummy_string4));
		NDR_CHECK(ndr_pull_netr_WorkstationFlags(ndr, NDR_SCALARS, &r->workstation_flags));
		NDR_CHECK(ndr_pull_netr_SupportedEncTypes(ndr, NDR_SCALARS, &r->supported_enc_types));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy_long4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_OneDomainInfo(ndr, NDR_BUFFERS, &r->primary_domain));
		if (r->trusted_domains) {
			_mem_save_trusted_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->trusted_domains, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->trusted_domains));
			size_trusted_domains_1 = ndr_get_array_size(ndr, &r->trusted_domains);
			NDR_PULL_ALLOC_N(ndr, r->trusted_domains, size_trusted_domains_1);
			_mem_save_trusted_domains_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->trusted_domains, 0);
			for (cntr_trusted_domains_1 = 0; cntr_trusted_domains_1 < size_trusted_domains_1; cntr_trusted_domains_1++) {
				NDR_CHECK(ndr_pull_netr_OneDomainInfo(ndr, NDR_SCALARS, &r->trusted_domains[cntr_trusted_domains_1]));
			}
			for (cntr_trusted_domains_1 = 0; cntr_trusted_domains_1 < size_trusted_domains_1; cntr_trusted_domains_1++) {
				NDR_CHECK(ndr_pull_netr_OneDomainInfo(ndr, NDR_BUFFERS, &r->trusted_domains[cntr_trusted_domains_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domains_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domains_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LsaPolicyInformation(ndr, NDR_BUFFERS, &r->lsa_policy));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dns_hostname));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string2));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string3));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->dummy_string4));
		if (r->trusted_domains) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->trusted_domains, r->trusted_domain_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DomainInformation(struct ndr_print *ndr, const char *name, const struct netr_DomainInformation *r)
{
	uint32_t cntr_trusted_domains_1;
	ndr_print_struct(ndr, name, "netr_DomainInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_OneDomainInfo(ndr, "primary_domain", &r->primary_domain);
	ndr_print_uint32(ndr, "trusted_domain_count", r->trusted_domain_count);
	ndr_print_ptr(ndr, "trusted_domains", r->trusted_domains);
	ndr->depth++;
	if (r->trusted_domains) {
		ndr->print(ndr, "%s: ARRAY(%d)", "trusted_domains", (int)r->trusted_domain_count);
		ndr->depth++;
		for (cntr_trusted_domains_1=0;cntr_trusted_domains_1<r->trusted_domain_count;cntr_trusted_domains_1++) {
			ndr_print_netr_OneDomainInfo(ndr, "trusted_domains", &r->trusted_domains[cntr_trusted_domains_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_netr_LsaPolicyInformation(ndr, "lsa_policy", &r->lsa_policy);
	ndr_print_lsa_StringLarge(ndr, "dns_hostname", &r->dns_hostname);
	ndr_print_lsa_StringLarge(ndr, "dummy_string2", &r->dummy_string2);
	ndr_print_lsa_StringLarge(ndr, "dummy_string3", &r->dummy_string3);
	ndr_print_lsa_StringLarge(ndr, "dummy_string4", &r->dummy_string4);
	ndr_print_netr_WorkstationFlags(ndr, "workstation_flags", r->workstation_flags);
	ndr_print_netr_SupportedEncTypes(ndr, "supported_enc_types", r->supported_enc_types);
	ndr_print_uint32(ndr, "dummy_long3", r->dummy_long3);
	ndr_print_uint32(ndr, "dummy_long4", r->dummy_long4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DomainInfo(struct ndr_push *ndr, int ndr_flags, const union netr_DomainInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_info));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->lsa_policy_info));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->domain_info) {
					NDR_CHECK(ndr_push_netr_DomainInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_info));
				}
			break;

			case 2:
				if (r->lsa_policy_info) {
					NDR_CHECK(ndr_push_netr_LsaPolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->lsa_policy_info));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DomainInfo(struct ndr_pull *ndr, int ndr_flags, union netr_DomainInfo *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_domain_info_0;
	uint32_t _ptr_domain_info;
	TALLOC_CTX *_mem_save_lsa_policy_info_0;
	uint32_t _ptr_lsa_policy_info;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_info));
				if (_ptr_domain_info) {
					NDR_PULL_ALLOC(ndr, r->domain_info);
				} else {
					r->domain_info = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lsa_policy_info));
				if (_ptr_lsa_policy_info) {
					NDR_PULL_ALLOC(ndr, r->lsa_policy_info);
				} else {
					r->lsa_policy_info = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->domain_info) {
					_mem_save_domain_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->domain_info, 0);
					NDR_CHECK(ndr_pull_netr_DomainInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain_info));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_info_0, 0);
				}
			break;

			case 2:
				if (r->lsa_policy_info) {
					_mem_save_lsa_policy_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->lsa_policy_info, 0);
					NDR_CHECK(ndr_pull_netr_LsaPolicyInformation(ndr, NDR_SCALARS|NDR_BUFFERS, r->lsa_policy_info));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lsa_policy_info_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DomainInfo(struct ndr_print *ndr, const char *name, const union netr_DomainInfo *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "netr_DomainInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "domain_info", r->domain_info);
			ndr->depth++;
			if (r->domain_info) {
				ndr_print_netr_DomainInformation(ndr, "domain_info", r->domain_info);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "lsa_policy_info", r->lsa_policy_info);
			ndr->depth++;
			if (r->lsa_policy_info) {
				ndr_print_netr_LsaPolicyInformation(ndr, "lsa_policy_info", r->lsa_policy_info);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_netr_CryptPassword(struct ndr_push *ndr, int ndr_flags, const struct netr_CryptPassword *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, 512));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_CryptPassword(struct ndr_pull *ndr, int ndr_flags, struct netr_CryptPassword *r)
{
	uint32_t size_data_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			size_data_0 = 512;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_0));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_CryptPassword(struct ndr_print *ndr, const char *name, const struct netr_CryptPassword *r)
{
	ndr_print_struct(ndr, name, "netr_CryptPassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->data, 512);
		ndr_print_uint32(ndr, "length", r->length);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_netr_DsRAddressToSitenamesWCtr(struct ndr_push *ndr, int ndr_flags, const struct netr_DsRAddressToSitenamesWCtr *r)
{
	uint32_t cntr_sitename_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sitename));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sitename) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_sitename_1 = 0; cntr_sitename_1 < r->count; cntr_sitename_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->sitename[cntr_sitename_1]));
			}
			for (cntr_sitename_1 = 0; cntr_sitename_1 < r->count; cntr_sitename_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->sitename[cntr_sitename_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRAddressToSitenamesWCtr(struct ndr_pull *ndr, int ndr_flags, struct netr_DsRAddressToSitenamesWCtr *r)
{
	uint32_t _ptr_sitename;
	uint32_t size_sitename_1 = 0;
	uint32_t cntr_sitename_1;
	TALLOC_CTX *_mem_save_sitename_0;
	TALLOC_CTX *_mem_save_sitename_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sitename));
		if (_ptr_sitename) {
			NDR_PULL_ALLOC(ndr, r->sitename);
		} else {
			r->sitename = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sitename) {
			_mem_save_sitename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sitename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sitename));
			size_sitename_1 = ndr_get_array_size(ndr, &r->sitename);
			NDR_PULL_ALLOC_N(ndr, r->sitename, size_sitename_1);
			_mem_save_sitename_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sitename, 0);
			for (cntr_sitename_1 = 0; cntr_sitename_1 < size_sitename_1; cntr_sitename_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->sitename[cntr_sitename_1]));
			}
			for (cntr_sitename_1 = 0; cntr_sitename_1 < size_sitename_1; cntr_sitename_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->sitename[cntr_sitename_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sitename_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sitename_0, 0);
		}
		if (r->sitename) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sitename, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRAddressToSitenamesWCtr(struct ndr_print *ndr, const char *name, const struct netr_DsRAddressToSitenamesWCtr *r)
{
	uint32_t cntr_sitename_1;
	ndr_print_struct(ndr, name, "netr_DsRAddressToSitenamesWCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sitename", r->sitename);
	ndr->depth++;
	if (r->sitename) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sitename", (int)r->count);
		ndr->depth++;
		for (cntr_sitename_1=0;cntr_sitename_1<r->count;cntr_sitename_1++) {
			ndr_print_lsa_String(ndr, "sitename", &r->sitename[cntr_sitename_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRAddress(struct ndr_push *ndr, int ndr_flags, const struct netr_DsRAddress *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buffer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRAddress(struct ndr_pull *ndr, int ndr_flags, struct netr_DsRAddress *r)
{
	uint32_t _ptr_buffer;
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_buffer_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->buffer);
		} else {
			r->buffer = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->buffer));
			size_buffer_1 = ndr_get_array_size(ndr, &r->buffer);
			NDR_PULL_ALLOC_N(ndr, r->buffer, size_buffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, size_buffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (r->buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->buffer, r->size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRAddress(struct ndr_print *ndr, const char *name, const struct netr_DsRAddress *r)
{
	ndr_print_struct(ndr, name, "netr_DsRAddress");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "buffer", r->buffer);
	ndr->depth++;
	if (r->buffer) {
		ndr_print_array_uint8(ndr, "buffer", r->buffer, r->size);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "size", r->size);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_TrustType(struct ndr_push *ndr, int ndr_flags, enum netr_TrustType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_TrustType(struct ndr_pull *ndr, int ndr_flags, enum netr_TrustType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_TrustType(struct ndr_print *ndr, const char *name, enum netr_TrustType r)
{
	const char *val = NULL;

	switch (r) {
		case NETR_TRUST_TYPE_DOWNLEVEL: val = "NETR_TRUST_TYPE_DOWNLEVEL"; break;
		case NETR_TRUST_TYPE_UPLEVEL: val = "NETR_TRUST_TYPE_UPLEVEL"; break;
		case NETR_TRUST_TYPE_MIT: val = "NETR_TRUST_TYPE_MIT"; break;
		case NETR_TRUST_TYPE_DCE: val = "NETR_TRUST_TYPE_DCE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_TrustAttributes(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_TrustAttributes(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_TrustAttributes(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE", NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY", NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_WITHIN_FOREST", NETR_TRUST_ATTRIBUTE_WITHIN_FOREST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DomainTrust(struct ndr_push *ndr, int ndr_flags, const struct netr_DomainTrust *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_netr_TrustFlags(ndr, NDR_SCALARS, r->trust_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->parent_index));
		NDR_CHECK(ndr_push_netr_TrustType(ndr, NDR_SCALARS, r->trust_type));
		NDR_CHECK(ndr_push_netr_TrustAttributes(ndr, NDR_SCALARS, r->trust_attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DomainTrust(struct ndr_pull *ndr, int ndr_flags, struct netr_DomainTrust *r)
{
	uint32_t _ptr_netbios_name;
	uint32_t size_netbios_name_1 = 0;
	uint32_t length_netbios_name_1 = 0;
	TALLOC_CTX *_mem_save_netbios_name_0;
	uint32_t _ptr_dns_name;
	uint32_t size_dns_name_1 = 0;
	uint32_t length_dns_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_name_0;
	uint32_t _ptr_sid;
	TALLOC_CTX *_mem_save_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_netr_TrustFlags(ndr, NDR_SCALARS, &r->trust_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->parent_index));
		NDR_CHECK(ndr_pull_netr_TrustType(ndr, NDR_SCALARS, &r->trust_type));
		NDR_CHECK(ndr_pull_netr_TrustAttributes(ndr, NDR_SCALARS, &r->trust_attributes));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sid));
		if (_ptr_sid) {
			NDR_PULL_ALLOC(ndr, r->sid);
		} else {
			r->sid = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			size_netbios_name_1 = ndr_get_array_size(ndr, &r->netbios_name);
			length_netbios_name_1 = ndr_get_array_length(ndr, &r->netbios_name);
			if (length_netbios_name_1 > size_netbios_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_netbios_name_1, length_netbios_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_netbios_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, length_netbios_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			size_dns_name_1 = ndr_get_array_size(ndr, &r->dns_name);
			length_dns_name_1 = ndr_get_array_length(ndr, &r->dns_name);
			if (length_dns_name_1 > size_dns_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_name_1, length_dns_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, length_dns_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->sid) {
			_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DomainTrust(struct ndr_print *ndr, const char *name, const struct netr_DomainTrust *r)
{
	ndr_print_struct(ndr, name, "netr_DomainTrust");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_netr_TrustFlags(ndr, "trust_flags", r->trust_flags);
	ndr_print_uint32(ndr, "parent_index", r->parent_index);
	ndr_print_netr_TrustType(ndr, "trust_type", r->trust_type);
	ndr_print_netr_TrustAttributes(ndr, "trust_attributes", r->trust_attributes);
	ndr_print_ptr(ndr, "sid", r->sid);
	ndr->depth++;
	if (r->sid) {
		ndr_print_dom_sid2(ndr, "sid", r->sid);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DomainTrustList(struct ndr_push *ndr, int ndr_flags, const struct netr_DomainTrustList *r)
{
	uint32_t cntr_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_netr_DomainTrust(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < r->count; cntr_array_1++) {
				NDR_CHECK(ndr_push_netr_DomainTrust(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DomainTrustList(struct ndr_pull *ndr, int ndr_flags, struct netr_DomainTrustList *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0;
	TALLOC_CTX *_mem_save_array_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			size_array_1 = ndr_get_array_size(ndr, &r->array);
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < size_array_1; cntr_array_1++) {
				NDR_CHECK(ndr_pull_netr_DomainTrust(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < size_array_1; cntr_array_1++) {
				NDR_CHECK(ndr_pull_netr_DomainTrust(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DomainTrustList(struct ndr_print *ndr, const char *name, const struct netr_DomainTrustList *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "netr_DomainTrustList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)r->count);
		ndr->depth++;
		for (cntr_array_1=0;cntr_array_1<r->count;cntr_array_1++) {
			ndr_print_netr_DomainTrust(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRAddressToSitenamesExWCtr(struct ndr_push *ndr, int ndr_flags, const struct netr_DsRAddressToSitenamesExWCtr *r)
{
	uint32_t cntr_sitename_1;
	uint32_t cntr_subnetname_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sitename));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->subnetname));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sitename) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_sitename_1 = 0; cntr_sitename_1 < r->count; cntr_sitename_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->sitename[cntr_sitename_1]));
			}
			for (cntr_sitename_1 = 0; cntr_sitename_1 < r->count; cntr_sitename_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->sitename[cntr_sitename_1]));
			}
		}
		if (r->subnetname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_subnetname_1 = 0; cntr_subnetname_1 < r->count; cntr_subnetname_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->subnetname[cntr_subnetname_1]));
			}
			for (cntr_subnetname_1 = 0; cntr_subnetname_1 < r->count; cntr_subnetname_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->subnetname[cntr_subnetname_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRAddressToSitenamesExWCtr(struct ndr_pull *ndr, int ndr_flags, struct netr_DsRAddressToSitenamesExWCtr *r)
{
	uint32_t _ptr_sitename;
	uint32_t size_sitename_1 = 0;
	uint32_t cntr_sitename_1;
	TALLOC_CTX *_mem_save_sitename_0;
	TALLOC_CTX *_mem_save_sitename_1;
	uint32_t _ptr_subnetname;
	uint32_t size_subnetname_1 = 0;
	uint32_t cntr_subnetname_1;
	TALLOC_CTX *_mem_save_subnetname_0;
	TALLOC_CTX *_mem_save_subnetname_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sitename));
		if (_ptr_sitename) {
			NDR_PULL_ALLOC(ndr, r->sitename);
		} else {
			r->sitename = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_subnetname));
		if (_ptr_subnetname) {
			NDR_PULL_ALLOC(ndr, r->subnetname);
		} else {
			r->subnetname = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sitename) {
			_mem_save_sitename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sitename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sitename));
			size_sitename_1 = ndr_get_array_size(ndr, &r->sitename);
			NDR_PULL_ALLOC_N(ndr, r->sitename, size_sitename_1);
			_mem_save_sitename_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sitename, 0);
			for (cntr_sitename_1 = 0; cntr_sitename_1 < size_sitename_1; cntr_sitename_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->sitename[cntr_sitename_1]));
			}
			for (cntr_sitename_1 = 0; cntr_sitename_1 < size_sitename_1; cntr_sitename_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->sitename[cntr_sitename_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sitename_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sitename_0, 0);
		}
		if (r->subnetname) {
			_mem_save_subnetname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->subnetname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->subnetname));
			size_subnetname_1 = ndr_get_array_size(ndr, &r->subnetname);
			NDR_PULL_ALLOC_N(ndr, r->subnetname, size_subnetname_1);
			_mem_save_subnetname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->subnetname, 0);
			for (cntr_subnetname_1 = 0; cntr_subnetname_1 < size_subnetname_1; cntr_subnetname_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->subnetname[cntr_subnetname_1]));
			}
			for (cntr_subnetname_1 = 0; cntr_subnetname_1 < size_subnetname_1; cntr_subnetname_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->subnetname[cntr_subnetname_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_subnetname_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_subnetname_0, 0);
		}
		if (r->sitename) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sitename, r->count));
		}
		if (r->subnetname) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->subnetname, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRAddressToSitenamesExWCtr(struct ndr_print *ndr, const char *name, const struct netr_DsRAddressToSitenamesExWCtr *r)
{
	uint32_t cntr_sitename_1;
	uint32_t cntr_subnetname_1;
	ndr_print_struct(ndr, name, "netr_DsRAddressToSitenamesExWCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "sitename", r->sitename);
	ndr->depth++;
	if (r->sitename) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sitename", (int)r->count);
		ndr->depth++;
		for (cntr_sitename_1=0;cntr_sitename_1<r->count;cntr_sitename_1++) {
			ndr_print_lsa_String(ndr, "sitename", &r->sitename[cntr_sitename_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "subnetname", r->subnetname);
	ndr->depth++;
	if (r->subnetname) {
		ndr->print(ndr, "%s: ARRAY(%d)", "subnetname", (int)r->count);
		ndr->depth++;
		for (cntr_subnetname_1=0;cntr_subnetname_1<r->count;cntr_subnetname_1++) {
			ndr_print_lsa_String(ndr, "subnetname", &r->subnetname[cntr_subnetname_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DcSitesCtr(struct ndr_push *ndr, int ndr_flags, const struct DcSitesCtr *r)
{
	uint32_t cntr_sites_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sites));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sites));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sites) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sites));
			for (cntr_sites_1 = 0; cntr_sites_1 < r->num_sites; cntr_sites_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->sites[cntr_sites_1]));
			}
			for (cntr_sites_1 = 0; cntr_sites_1 < r->num_sites; cntr_sites_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->sites[cntr_sites_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DcSitesCtr(struct ndr_pull *ndr, int ndr_flags, struct DcSitesCtr *r)
{
	uint32_t _ptr_sites;
	uint32_t size_sites_1 = 0;
	uint32_t cntr_sites_1;
	TALLOC_CTX *_mem_save_sites_0;
	TALLOC_CTX *_mem_save_sites_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sites));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sites));
		if (_ptr_sites) {
			NDR_PULL_ALLOC(ndr, r->sites);
		} else {
			r->sites = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sites) {
			_mem_save_sites_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sites, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sites));
			size_sites_1 = ndr_get_array_size(ndr, &r->sites);
			NDR_PULL_ALLOC_N(ndr, r->sites, size_sites_1);
			_mem_save_sites_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sites, 0);
			for (cntr_sites_1 = 0; cntr_sites_1 < size_sites_1; cntr_sites_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->sites[cntr_sites_1]));
			}
			for (cntr_sites_1 = 0; cntr_sites_1 < size_sites_1; cntr_sites_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->sites[cntr_sites_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sites_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sites_0, 0);
		}
		if (r->sites) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sites, r->num_sites));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DcSitesCtr(struct ndr_print *ndr, const char *name, const struct DcSitesCtr *r)
{
	uint32_t cntr_sites_1;
	ndr_print_struct(ndr, name, "DcSitesCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sites", r->num_sites);
	ndr_print_ptr(ndr, "sites", r->sites);
	ndr->depth++;
	if (r->sites) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sites", (int)r->num_sites);
		ndr->depth++;
		for (cntr_sites_1=0;cntr_sites_1<r->num_sites;cntr_sites_1++) {
			ndr_print_lsa_String(ndr, "sites", &r->sites[cntr_sites_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_TrustInfo(struct ndr_push *ndr, int ndr_flags, const struct netr_TrustInfo *r)
{
	uint32_t cntr_data_1;
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entry_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_data_1 = 0; cntr_data_1 < r->count; cntr_data_1++) {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data[cntr_data_1]));
			}
		}
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->count; cntr_entries_1++) {
				NDR_CHECK(ndr_push_lsa_String(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_TrustInfo(struct ndr_pull *ndr, int ndr_flags, struct netr_TrustInfo *r)
{
	uint32_t _ptr_data;
	uint32_t size_data_1 = 0;
	uint32_t cntr_data_1;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_data_1;
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entry_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			size_data_1 = ndr_get_array_size(ndr, &r->data);
			NDR_PULL_ALLOC_N(ndr, r->data, size_data_1);
			_mem_save_data_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			for (cntr_data_1 = 0; cntr_data_1 < size_data_1; cntr_data_1++) {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data[cntr_data_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			size_entries_1 = ndr_get_array_size(ndr, &r->entries);
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->count));
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_TrustInfo(struct ndr_print *ndr, const char *name, const struct netr_TrustInfo *r)
{
	uint32_t cntr_data_1;
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "netr_TrustInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr->print(ndr, "%s: ARRAY(%d)", "data", (int)r->count);
		ndr->depth++;
		for (cntr_data_1=0;cntr_data_1<r->count;cntr_data_1++) {
			ndr_print_uint32(ndr, "data", r->data[cntr_data_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "entry_count", r->entry_count);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->count);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->count;cntr_entries_1++) {
			ndr_print_lsa_String(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DnsType(struct ndr_push *ndr, int ndr_flags, enum netr_DnsType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DnsType(struct ndr_pull *ndr, int ndr_flags, enum netr_DnsType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DnsType(struct ndr_print *ndr, const char *name, enum netr_DnsType r)
{
	const char *val = NULL;

	switch (r) {
		case NlDnsLdapAtSite: val = "NlDnsLdapAtSite"; break;
		case NlDnsGcAtSite: val = "NlDnsGcAtSite"; break;
		case NlDnsDsaCname: val = "NlDnsDsaCname"; break;
		case NlDnsKdcAtSite: val = "NlDnsKdcAtSite"; break;
		case NlDnsDcAtSite: val = "NlDnsDcAtSite"; break;
		case NlDnsRfc1510KdcAtSite: val = "NlDnsRfc1510KdcAtSite"; break;
		case NlDnsGenericGcAtSite: val = "NlDnsGenericGcAtSite"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_netr_DnsDomainInfoType(struct ndr_push *ndr, int ndr_flags, enum netr_DnsDomainInfoType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DnsDomainInfoType(struct ndr_pull *ndr, int ndr_flags, enum netr_DnsDomainInfoType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DnsDomainInfoType(struct ndr_print *ndr, const char *name, enum netr_DnsDomainInfoType r)
{
	const char *val = NULL;

	switch (r) {
		case NlDnsInfoTypeNone: val = "NlDnsInfoTypeNone"; break;
		case NlDnsDomainName: val = "NlDnsDomainName"; break;
		case NlDnsDomainNameAlias: val = "NlDnsDomainNameAlias"; break;
		case NlDnsForestName: val = "NlDnsForestName"; break;
		case NlDnsForestNameAlias: val = "NlDnsForestNameAlias"; break;
		case NlDnsNdncDomainName: val = "NlDnsNdncDomainName"; break;
		case NlDnsRecordName: val = "NlDnsRecordName"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_NL_DNS_NAME_INFO(struct ndr_push *ndr, int ndr_flags, const struct NL_DNS_NAME_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_netr_DnsType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_domain_info));
		NDR_CHECK(ndr_push_netr_DnsDomainInfoType(ndr, NDR_SCALARS, r->dns_domain_info_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->weight));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->port));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dns_register));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_info) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_info, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_info, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_domain_info, ndr_charset_length(r->dns_domain_info, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NL_DNS_NAME_INFO(struct ndr_pull *ndr, int ndr_flags, struct NL_DNS_NAME_INFO *r)
{
	uint32_t _ptr_dns_domain_info;
	uint32_t size_dns_domain_info_1 = 0;
	uint32_t length_dns_domain_info_1 = 0;
	TALLOC_CTX *_mem_save_dns_domain_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_netr_DnsType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_domain_info));
		if (_ptr_dns_domain_info) {
			NDR_PULL_ALLOC(ndr, r->dns_domain_info);
		} else {
			r->dns_domain_info = NULL;
		}
		NDR_CHECK(ndr_pull_netr_DnsDomainInfoType(ndr, NDR_SCALARS, &r->dns_domain_info_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->weight));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->port));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dns_register));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_info) {
			_mem_save_dns_domain_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_domain_info, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_domain_info));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_domain_info));
			size_dns_domain_info_1 = ndr_get_array_size(ndr, &r->dns_domain_info);
			length_dns_domain_info_1 = ndr_get_array_length(ndr, &r->dns_domain_info);
			if (length_dns_domain_info_1 > size_dns_domain_info_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_domain_info_1, length_dns_domain_info_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_domain_info_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_domain_info, length_dns_domain_info_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_domain_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_DNS_NAME_INFO(struct ndr_print *ndr, const char *name, const struct NL_DNS_NAME_INFO *r)
{
	ndr_print_struct(ndr, name, "NL_DNS_NAME_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_netr_DnsType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "dns_domain_info", r->dns_domain_info);
	ndr->depth++;
	if (r->dns_domain_info) {
		ndr_print_string(ndr, "dns_domain_info", r->dns_domain_info);
	}
	ndr->depth--;
	ndr_print_netr_DnsDomainInfoType(ndr, "dns_domain_info_type", r->dns_domain_info_type);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "weight", r->weight);
	ndr_print_uint32(ndr, "port", r->port);
	ndr_print_uint32(ndr, "dns_register", r->dns_register);
	ndr_print_uint32(ndr, "status", r->status);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_DNS_NAME_INFO_ARRAY(struct ndr_push *ndr, int ndr_flags, const struct NL_DNS_NAME_INFO_ARRAY *r)
{
	uint32_t cntr_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_NL_DNS_NAME_INFO(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < r->count; cntr_names_1++) {
				NDR_CHECK(ndr_push_NL_DNS_NAME_INFO(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_DNS_NAME_INFO_ARRAY(struct ndr_pull *ndr, int ndr_flags, struct NL_DNS_NAME_INFO_ARRAY *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0;
	TALLOC_CTX *_mem_save_names_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			size_names_1 = ndr_get_array_size(ndr, &r->names);
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < size_names_1; cntr_names_1++) {
				NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < size_names_1; cntr_names_1++) {
				NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_DNS_NAME_INFO_ARRAY(struct ndr_print *ndr, const char *name, const struct NL_DNS_NAME_INFO_ARRAY *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "NL_DNS_NAME_INFO_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%d)", "names", (int)r->count);
		ndr->depth++;
		for (cntr_names_1=0;cntr_names_1<r->count;cntr_names_1++) {
			ndr_print_NL_DNS_NAME_INFO(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonUasLogon(struct ndr_push *ndr, int flags, const struct netr_LogonUasLogon *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.workstation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.workstation, ndr_charset_length(r->in.workstation, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_netr_UasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonUasLogon(struct ndr_pull *ndr, int flags, struct netr_LogonUasLogon *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_workstation_1 = 0;
	uint32_t length_workstation_1 = 0;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.workstation));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.workstation));
		size_workstation_1 = ndr_get_array_size(ndr, &r->in.workstation);
		length_workstation_1 = ndr_get_array_length(ndr, &r->in.workstation);
		if (length_workstation_1 > size_workstation_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_workstation_1, length_workstation_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_workstation_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.workstation, length_workstation_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_netr_UasInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonUasLogon(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonUasLogon *r)
{
	ndr_print_struct(ndr, name, "netr_LogonUasLogon");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonUasLogon");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "workstation", r->in.workstation);
		ndr->depth++;
		ndr_print_string(ndr, "workstation", r->in.workstation);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonUasLogon");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_netr_UasInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonUasLogoff(struct ndr_push *ndr, int flags, const struct netr_LogonUasLogoff *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.workstation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.workstation, ndr_charset_length(r->in.workstation, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_UasLogoffInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonUasLogoff(struct ndr_pull *ndr, int flags, struct netr_LogonUasLogoff *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_workstation_1 = 0;
	uint32_t length_workstation_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.workstation));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.workstation));
		size_workstation_1 = ndr_get_array_size(ndr, &r->in.workstation);
		length_workstation_1 = ndr_get_array_length(ndr, &r->in.workstation);
		if (length_workstation_1 > size_workstation_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_workstation_1, length_workstation_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_workstation_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.workstation, length_workstation_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_UasLogoffInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonUasLogoff(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonUasLogoff *r)
{
	ndr_print_struct(ndr, name, "netr_LogonUasLogoff");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonUasLogoff");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "workstation", r->in.workstation);
		ndr->depth++;
		ndr_print_string(ndr, "workstation", r->in.workstation);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonUasLogoff");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_netr_UasLogoffInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_LogonSamLogon(struct ndr_push *ndr, int flags, const struct netr_LogonSamLogon *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.credential));
		if (r->in.credential) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.return_authenticator));
		if (r->in.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		}
		NDR_CHECK(ndr_push_netr_LogonInfoClass(ndr, NDR_SCALARS, r->in.logon_level));
		if (r->in.logon == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.validation_level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.return_authenticator));
		if (r->out.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		}
		if (r->out.validation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		if (r->out.authoritative == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->out.authoritative));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_LogonSamLogon(struct ndr_pull *ndr, int flags, struct netr_LogonSamLogon *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_credential;
	uint32_t _ptr_return_authenticator;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_logon_0;
	TALLOC_CTX *_mem_save_validation_0;
	TALLOC_CTX *_mem_save_authoritative_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_credential));
		if (_ptr_credential) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		} else {
			r->in.credential = NULL;
		}
		if (r->in.credential) {
			_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		} else {
			r->in.return_authenticator = NULL;
		}
		if (r->in.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonInfoClass(ndr, NDR_SCALARS, &r->in.logon_level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logon);
		}
		_mem_save_logon_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logon, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.validation_level));
		NDR_PULL_ALLOC(ndr, r->out.validation);
		ZERO_STRUCTP(r->out.validation);
		NDR_PULL_ALLOC(ndr, r->out.authoritative);
		ZERO_STRUCTP(r->out.authoritative);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		} else {
			r->out.return_authenticator = NULL;
		}
		if (r->out.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.validation);
		}
		_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.validation, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.authoritative);
		}
		_mem_save_authoritative_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.authoritative, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authoritative_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonSamLogon(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonSamLogon *r)
{
	ndr_print_struct(ndr, name, "netr_LogonSamLogon");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonSamLogon");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		if (r->in.credential) {
			ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		if (r->in.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		}
		ndr->depth--;
		ndr_print_netr_LogonInfoClass(ndr, "logon_level", r->in.logon_level);
		ndr_print_ptr(ndr, "logon", r->in.logon);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", r->in.logon);
		ndr->depth--;
		ndr_print_uint16(ndr, "validation_level", r->in.validation_level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonSamLogon");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		if (r->out.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "validation", r->out.validation);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.validation, r->in.validation_level);
		ndr_print_netr_Validation(ndr, "validation", r->out.validation);
		ndr->depth--;
		ndr_print_ptr(ndr, "authoritative", r->out.authoritative);
		ndr->depth++;
		ndr_print_uint8(ndr, "authoritative", *r->out.authoritative);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonSamLogoff(struct ndr_push *ndr, int flags, const struct netr_LogonSamLogoff *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.credential));
		if (r->in.credential) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.return_authenticator));
		if (r->in.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		}
		NDR_CHECK(ndr_push_netr_LogonInfoClass(ndr, NDR_SCALARS, r->in.logon_level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.return_authenticator));
		if (r->out.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonSamLogoff(struct ndr_pull *ndr, int flags, struct netr_LogonSamLogoff *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_credential;
	uint32_t _ptr_return_authenticator;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_credential));
		if (_ptr_credential) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		} else {
			r->in.credential = NULL;
		}
		if (r->in.credential) {
			_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		} else {
			r->in.return_authenticator = NULL;
		}
		if (r->in.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonInfoClass(ndr, NDR_SCALARS, &r->in.logon_level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		} else {
			r->out.return_authenticator = NULL;
		}
		if (r->out.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonSamLogoff(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonSamLogoff *r)
{
	ndr_print_struct(ndr, name, "netr_LogonSamLogoff");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonSamLogoff");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		if (r->in.credential) {
			ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		if (r->in.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		}
		ndr->depth--;
		ndr_print_netr_LogonInfoClass(ndr, "logon_level", r->in.logon_level);
		ndr_print_set_switch_value(ndr, &r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", &r->in.logon);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonSamLogoff");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		if (r->out.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_ServerReqChallenge(struct ndr_push *ndr, int flags, const struct netr_ServerReqChallenge *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_ServerReqChallenge(struct ndr_pull *ndr, int flags, struct netr_ServerReqChallenge *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credentials_0;
	TALLOC_CTX *_mem_save_return_credentials_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credentials);
		}
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		ZERO_STRUCTP(r->out.return_credentials);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		}
		_mem_save_return_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerReqChallenge(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerReqChallenge *r)
{
	ndr_print_struct(ndr, name, "netr_ServerReqChallenge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerReqChallenge");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credentials", r->in.credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "credentials", r->in.credentials);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerReqChallenge");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerAuthenticate(struct ndr_push *ndr, int flags, const struct netr_ServerAuthenticate *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerAuthenticate(struct ndr_pull *ndr, int flags, struct netr_ServerAuthenticate *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credentials_0;
	TALLOC_CTX *_mem_save_return_credentials_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credentials);
		}
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		ZERO_STRUCTP(r->out.return_credentials);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		}
		_mem_save_return_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerAuthenticate(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerAuthenticate *r)
{
	ndr_print_struct(ndr, name, "netr_ServerAuthenticate");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerAuthenticate");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credentials", r->in.credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "credentials", r->in.credentials);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerAuthenticate");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerPasswordSet(struct ndr_push *ndr, int flags, const struct netr_ServerPasswordSet *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.new_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->in.new_password));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerPasswordSet(struct ndr_pull *ndr, int flags, struct netr_ServerPasswordSet *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_new_password_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.new_password);
		}
		_mem_save_new_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.new_password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->in.new_password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_password_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerPasswordSet(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerPasswordSet *r)
{
	ndr_print_struct(ndr, name, "netr_ServerPasswordSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerPasswordSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_password", r->in.new_password);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "new_password", r->in.new_password);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerPasswordSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DatabaseDeltas(struct ndr_push *ndr, int flags, const struct netr_DatabaseDeltas *r)
{
	if (flags & NDR_IN) {
		if (r->in.logon_server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_netr_SamDatabaseID(ndr, NDR_SCALARS, r->in.database_id));
		if (r->in.sequence_num == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, *r->in.sequence_num));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.preferredmaximumlength));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.sequence_num == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, *r->out.sequence_num));
		if (r->out.delta_enum_array == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.delta_enum_array));
		if (*r->out.delta_enum_array) {
			NDR_CHECK(ndr_push_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DatabaseDeltas(struct ndr_pull *ndr, int flags, struct netr_DatabaseDeltas *r)
{
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	uint32_t _ptr_delta_enum_array;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_sequence_num_0;
	TALLOC_CTX *_mem_save_delta_enum_array_0;
	TALLOC_CTX *_mem_save_delta_enum_array_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
		size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
		length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
		if (length_logon_server_1 > size_logon_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_SamDatabaseID(ndr, NDR_SCALARS, &r->in.database_id));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sequence_num);
		}
		_mem_save_sequence_num_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sequence_num, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, r->in.sequence_num));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sequence_num_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.preferredmaximumlength));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.sequence_num);
		*r->out.sequence_num = *r->in.sequence_num;
		NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		ZERO_STRUCTP(r->out.delta_enum_array);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sequence_num);
		}
		_mem_save_sequence_num_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sequence_num, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, r->out.sequence_num));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sequence_num_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		}
		_mem_save_delta_enum_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.delta_enum_array, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delta_enum_array));
		if (_ptr_delta_enum_array) {
			NDR_PULL_ALLOC(ndr, *r->out.delta_enum_array);
		} else {
			*r->out.delta_enum_array = NULL;
		}
		if (*r->out.delta_enum_array) {
			_mem_save_delta_enum_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.delta_enum_array, 0);
			NDR_CHECK(ndr_pull_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DatabaseDeltas(struct ndr_print *ndr, const char *name, int flags, const struct netr_DatabaseDeltas *r)
{
	ndr_print_struct(ndr, name, "netr_DatabaseDeltas");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DatabaseDeltas");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		ndr_print_string(ndr, "logon_server", r->in.logon_server);
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_netr_SamDatabaseID(ndr, "database_id", r->in.database_id);
		ndr_print_ptr(ndr, "sequence_num", r->in.sequence_num);
		ndr->depth++;
		ndr_print_udlong(ndr, "sequence_num", *r->in.sequence_num);
		ndr->depth--;
		ndr_print_uint32(ndr, "preferredmaximumlength", r->in.preferredmaximumlength);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DatabaseDeltas");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "sequence_num", r->out.sequence_num);
		ndr->depth++;
		ndr_print_udlong(ndr, "sequence_num", *r->out.sequence_num);
		ndr->depth--;
		ndr_print_ptr(ndr, "delta_enum_array", r->out.delta_enum_array);
		ndr->depth++;
		ndr_print_ptr(ndr, "delta_enum_array", *r->out.delta_enum_array);
		ndr->depth++;
		if (*r->out.delta_enum_array) {
			ndr_print_netr_DELTA_ENUM_ARRAY(ndr, "delta_enum_array", *r->out.delta_enum_array);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DatabaseSync(struct ndr_push *ndr, int flags, const struct netr_DatabaseSync *r)
{
	if (flags & NDR_IN) {
		if (r->in.logon_server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_netr_SamDatabaseID(ndr, NDR_SCALARS, r->in.database_id));
		if (r->in.sync_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.sync_context));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.preferredmaximumlength));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.sync_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sync_context));
		if (r->out.delta_enum_array == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.delta_enum_array));
		if (*r->out.delta_enum_array) {
			NDR_CHECK(ndr_push_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DatabaseSync(struct ndr_pull *ndr, int flags, struct netr_DatabaseSync *r)
{
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	uint32_t _ptr_delta_enum_array;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_sync_context_0;
	TALLOC_CTX *_mem_save_delta_enum_array_0;
	TALLOC_CTX *_mem_save_delta_enum_array_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
		size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
		length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
		if (length_logon_server_1 > size_logon_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_SamDatabaseID(ndr, NDR_SCALARS, &r->in.database_id));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sync_context);
		}
		_mem_save_sync_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sync_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.sync_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sync_context_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.preferredmaximumlength));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.sync_context);
		*r->out.sync_context = *r->in.sync_context;
		NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		ZERO_STRUCTP(r->out.delta_enum_array);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sync_context);
		}
		_mem_save_sync_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sync_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sync_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sync_context_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		}
		_mem_save_delta_enum_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.delta_enum_array, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delta_enum_array));
		if (_ptr_delta_enum_array) {
			NDR_PULL_ALLOC(ndr, *r->out.delta_enum_array);
		} else {
			*r->out.delta_enum_array = NULL;
		}
		if (*r->out.delta_enum_array) {
			_mem_save_delta_enum_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.delta_enum_array, 0);
			NDR_CHECK(ndr_pull_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DatabaseSync(struct ndr_print *ndr, const char *name, int flags, const struct netr_DatabaseSync *r)
{
	ndr_print_struct(ndr, name, "netr_DatabaseSync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DatabaseSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		ndr_print_string(ndr, "logon_server", r->in.logon_server);
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_netr_SamDatabaseID(ndr, "database_id", r->in.database_id);
		ndr_print_ptr(ndr, "sync_context", r->in.sync_context);
		ndr->depth++;
		ndr_print_uint32(ndr, "sync_context", *r->in.sync_context);
		ndr->depth--;
		ndr_print_uint32(ndr, "preferredmaximumlength", r->in.preferredmaximumlength);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DatabaseSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "sync_context", r->out.sync_context);
		ndr->depth++;
		ndr_print_uint32(ndr, "sync_context", *r->out.sync_context);
		ndr->depth--;
		ndr_print_ptr(ndr, "delta_enum_array", r->out.delta_enum_array);
		ndr->depth++;
		ndr_print_ptr(ndr, "delta_enum_array", *r->out.delta_enum_array);
		ndr->depth++;
		if (*r->out.delta_enum_array) {
			ndr_print_netr_DELTA_ENUM_ARRAY(ndr, "delta_enum_array", *r->out.delta_enum_array);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_AccountDeltas(struct ndr_push *ndr, int flags, const struct netr_AccountDeltas *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, &r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_netr_UAS_INFO_0(ndr, NDR_SCALARS, &r->in.uas));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffersize));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		{
			struct ndr_push *_ndr_buffer;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_buffer, 4, -1));
			NDR_CHECK(ndr_push_netr_AccountBuffer(_ndr_buffer, NDR_SCALARS, r->out.buffer));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_buffer, 4, -1));
		}
		if (r->out.count_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count_returned));
		if (r->out.total_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_entries));
		if (r->out.recordid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->out.recordid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_AccountDeltas(struct ndr_pull *ndr, int flags, struct netr_AccountDeltas *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_count_returned_0;
	TALLOC_CTX *_mem_save_total_entries_0;
	TALLOC_CTX *_mem_save_recordid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, &r->in.credential));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_UAS_INFO_0(ndr, NDR_SCALARS, &r->in.uas));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buffersize));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.buffer);
		ZERO_STRUCTP(r->out.buffer);
		NDR_PULL_ALLOC(ndr, r->out.count_returned);
		ZERO_STRUCTP(r->out.count_returned);
		NDR_PULL_ALLOC(ndr, r->out.total_entries);
		ZERO_STRUCTP(r->out.total_entries);
		NDR_PULL_ALLOC(ndr, r->out.recordid);
		ZERO_STRUCTP(r->out.recordid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.buffer);
		}
		_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer, LIBNDR_FLAG_REF_ALLOC);
		{
			struct ndr_pull *_ndr_buffer;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_buffer, 4, -1));
			NDR_CHECK(ndr_pull_netr_AccountBuffer(_ndr_buffer, NDR_SCALARS, r->out.buffer));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_buffer, 4, -1));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count_returned);
		}
		_mem_save_count_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_returned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_entries);
		}
		_mem_save_total_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_entries_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.recordid);
		}
		_mem_save_recordid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.recordid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->out.recordid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recordid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_AccountDeltas(struct ndr_print *ndr, const char *name, int flags, const struct netr_AccountDeltas *r)
{
	ndr_print_struct(ndr, name, "netr_AccountDeltas");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_AccountDeltas");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_netr_Authenticator(ndr, "credential", &r->in.credential);
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_netr_UAS_INFO_0(ndr, "uas", &r->in.uas);
		ndr_print_uint32(ndr, "count", r->in.count);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "buffersize", r->in.buffersize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_AccountDeltas");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_netr_AccountBuffer(ndr, "buffer", r->out.buffer);
		ndr->depth--;
		ndr_print_ptr(ndr, "count_returned", r->out.count_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "count_returned", *r->out.count_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "recordid", r->out.recordid);
		ndr->depth++;
		ndr_print_netr_UAS_INFO_0(ndr, "recordid", r->out.recordid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_AccountSync(struct ndr_push *ndr, int flags, const struct netr_AccountSync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, &r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reference));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffersize));
		if (r->in.recordid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->in.recordid));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		{
			struct ndr_push *_ndr_buffer;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_buffer, 4, -1));
			NDR_CHECK(ndr_push_netr_AccountBuffer(_ndr_buffer, NDR_SCALARS, r->out.buffer));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_buffer, 4, -1));
		}
		if (r->out.count_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count_returned));
		if (r->out.total_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_entries));
		if (r->out.next_reference == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.next_reference));
		if (r->out.recordid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->out.recordid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_AccountSync(struct ndr_pull *ndr, int flags, struct netr_AccountSync *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_count_returned_0;
	TALLOC_CTX *_mem_save_total_entries_0;
	TALLOC_CTX *_mem_save_next_reference_0;
	TALLOC_CTX *_mem_save_recordid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, &r->in.credential));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reference));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buffersize));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.recordid);
		}
		_mem_save_recordid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.recordid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->in.recordid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recordid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.buffer);
		ZERO_STRUCTP(r->out.buffer);
		NDR_PULL_ALLOC(ndr, r->out.count_returned);
		ZERO_STRUCTP(r->out.count_returned);
		NDR_PULL_ALLOC(ndr, r->out.total_entries);
		ZERO_STRUCTP(r->out.total_entries);
		NDR_PULL_ALLOC(ndr, r->out.next_reference);
		ZERO_STRUCTP(r->out.next_reference);
		NDR_PULL_ALLOC(ndr, r->out.recordid);
		*r->out.recordid = *r->in.recordid;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.buffer);
		}
		_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer, LIBNDR_FLAG_REF_ALLOC);
		{
			struct ndr_pull *_ndr_buffer;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_buffer, 4, -1));
			NDR_CHECK(ndr_pull_netr_AccountBuffer(_ndr_buffer, NDR_SCALARS, r->out.buffer));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_buffer, 4, -1));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count_returned);
		}
		_mem_save_count_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_returned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_entries);
		}
		_mem_save_total_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_entries_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.next_reference);
		}
		_mem_save_next_reference_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.next_reference, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.next_reference));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_reference_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.recordid);
		}
		_mem_save_recordid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.recordid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_UAS_INFO_0(ndr, NDR_SCALARS, r->out.recordid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_recordid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_AccountSync(struct ndr_print *ndr, const char *name, int flags, const struct netr_AccountSync *r)
{
	ndr_print_struct(ndr, name, "netr_AccountSync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_AccountSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_netr_Authenticator(ndr, "credential", &r->in.credential);
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_uint32(ndr, "reference", r->in.reference);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "buffersize", r->in.buffersize);
		ndr_print_ptr(ndr, "recordid", r->in.recordid);
		ndr->depth++;
		ndr_print_netr_UAS_INFO_0(ndr, "recordid", r->in.recordid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_AccountSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_netr_AccountBuffer(ndr, "buffer", r->out.buffer);
		ndr->depth--;
		ndr_print_ptr(ndr, "count_returned", r->out.count_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "count_returned", *r->out.count_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "next_reference", r->out.next_reference);
		ndr->depth++;
		ndr_print_uint32(ndr, "next_reference", *r->out.next_reference);
		ndr->depth--;
		ndr_print_ptr(ndr, "recordid", r->out.recordid);
		ndr->depth++;
		ndr_print_netr_UAS_INFO_0(ndr, "recordid", r->out.recordid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_GetDcName(struct ndr_push *ndr, int flags, const struct netr_GetDcName *r)
{
	if (flags & NDR_IN) {
		if (r->in.logon_server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domainname));
		if (r->in.domainname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domainname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domainname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domainname, ndr_charset_length(r->in.domainname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.dcname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dcname));
		if (*r->out.dcname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.dcname, ndr_charset_length(*r->out.dcname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_GetDcName(struct ndr_pull *ndr, int flags, struct netr_GetDcName *r)
{
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t _ptr_domainname;
	uint32_t size_domainname_1 = 0;
	uint32_t length_domainname_1 = 0;
	uint32_t _ptr_dcname;
	uint32_t size_dcname_2 = 0;
	uint32_t length_dcname_2 = 0;
	TALLOC_CTX *_mem_save_domainname_0;
	TALLOC_CTX *_mem_save_dcname_0;
	TALLOC_CTX *_mem_save_dcname_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
		size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
		length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
		if (length_logon_server_1 > size_logon_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domainname));
		if (_ptr_domainname) {
			NDR_PULL_ALLOC(ndr, r->in.domainname);
		} else {
			r->in.domainname = NULL;
		}
		if (r->in.domainname) {
			_mem_save_domainname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domainname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domainname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domainname));
			size_domainname_1 = ndr_get_array_size(ndr, &r->in.domainname);
			length_domainname_1 = ndr_get_array_length(ndr, &r->in.domainname);
			if (length_domainname_1 > size_domainname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domainname_1, length_domainname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domainname_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domainname, length_domainname_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domainname_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.dcname);
		ZERO_STRUCTP(r->out.dcname);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dcname);
		}
		_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dcname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
		if (_ptr_dcname) {
			NDR_PULL_ALLOC(ndr, *r->out.dcname);
		} else {
			*r->out.dcname = NULL;
		}
		if (*r->out.dcname) {
			_mem_save_dcname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dcname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.dcname));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.dcname));
			size_dcname_2 = ndr_get_array_size(ndr, r->out.dcname);
			length_dcname_2 = ndr_get_array_length(ndr, r->out.dcname);
			if (length_dcname_2 > size_dcname_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dcname_2, length_dcname_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dcname_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.dcname, length_dcname_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_GetDcName(struct ndr_print *ndr, const char *name, int flags, const struct netr_GetDcName *r)
{
	ndr_print_struct(ndr, name, "netr_GetDcName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_GetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		ndr_print_string(ndr, "logon_server", r->in.logon_server);
		ndr->depth--;
		ndr_print_ptr(ndr, "domainname", r->in.domainname);
		ndr->depth++;
		if (r->in.domainname) {
			ndr_print_string(ndr, "domainname", r->in.domainname);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_GetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->out.dcname);
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", *r->out.dcname);
		ndr->depth++;
		if (*r->out.dcname) {
			ndr_print_string(ndr, "dcname", *r->out.dcname);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonControl(struct ndr_push *ndr, int flags, const struct netr_LogonControl *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_LogonControlCode(ndr, NDR_SCALARS, r->in.function_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_push_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonControl(struct ndr_pull *ndr, int flags, struct netr_LogonControl *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_query_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonControlCode(ndr, NDR_SCALARS, &r->in.function_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.query);
		ZERO_STRUCTP(r->out.query);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_pull_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonControl(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonControl *r)
{
	ndr_print_struct(ndr, name, "netr_LogonControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_netr_LogonControlCode(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.query, r->in.level);
		ndr_print_netr_CONTROL_QUERY_INFORMATION(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_GetAnyDCName(struct ndr_push *ndr, int flags, const struct netr_GetAnyDCName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domainname));
		if (r->in.domainname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domainname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domainname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domainname, ndr_charset_length(r->in.domainname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.dcname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dcname));
		if (*r->out.dcname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.dcname, ndr_charset_length(*r->out.dcname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_GetAnyDCName(struct ndr_pull *ndr, int flags, struct netr_GetAnyDCName *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t _ptr_domainname;
	uint32_t size_domainname_1 = 0;
	uint32_t length_domainname_1 = 0;
	uint32_t _ptr_dcname;
	uint32_t size_dcname_2 = 0;
	uint32_t length_dcname_2 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_domainname_0;
	TALLOC_CTX *_mem_save_dcname_0;
	TALLOC_CTX *_mem_save_dcname_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domainname));
		if (_ptr_domainname) {
			NDR_PULL_ALLOC(ndr, r->in.domainname);
		} else {
			r->in.domainname = NULL;
		}
		if (r->in.domainname) {
			_mem_save_domainname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domainname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domainname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domainname));
			size_domainname_1 = ndr_get_array_size(ndr, &r->in.domainname);
			length_domainname_1 = ndr_get_array_length(ndr, &r->in.domainname);
			if (length_domainname_1 > size_domainname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domainname_1, length_domainname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domainname_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domainname, length_domainname_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domainname_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.dcname);
		ZERO_STRUCTP(r->out.dcname);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dcname);
		}
		_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dcname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
		if (_ptr_dcname) {
			NDR_PULL_ALLOC(ndr, *r->out.dcname);
		} else {
			*r->out.dcname = NULL;
		}
		if (*r->out.dcname) {
			_mem_save_dcname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dcname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.dcname));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.dcname));
			size_dcname_2 = ndr_get_array_size(ndr, r->out.dcname);
			length_dcname_2 = ndr_get_array_length(ndr, r->out.dcname);
			if (length_dcname_2 > size_dcname_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dcname_2, length_dcname_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dcname_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.dcname, length_dcname_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_GetAnyDCName(struct ndr_print *ndr, const char *name, int flags, const struct netr_GetAnyDCName *r)
{
	ndr_print_struct(ndr, name, "netr_GetAnyDCName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_GetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domainname", r->in.domainname);
		ndr->depth++;
		if (r->in.domainname) {
			ndr_print_string(ndr, "domainname", r->in.domainname);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_GetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->out.dcname);
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", *r->out.dcname);
		ndr->depth++;
		if (*r->out.dcname) {
			ndr_print_string(ndr, "dcname", *r->out.dcname);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonControl2(struct ndr_push *ndr, int flags, const struct netr_LogonControl2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_LogonControlCode(ndr, NDR_SCALARS, r->in.function_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_push_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_push_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonControl2(struct ndr_pull *ndr, int flags, struct netr_LogonControl2 *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_query_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonControlCode(ndr, NDR_SCALARS, &r->in.function_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_pull_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.query);
		ZERO_STRUCTP(r->out.query);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_pull_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonControl2(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonControl2 *r)
{
	ndr_print_struct(ndr, name, "netr_LogonControl2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonControl2");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_netr_LogonControlCode(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.data, r->in.function_code);
		ndr_print_netr_CONTROL_DATA_INFORMATION(ndr, "data", r->in.data);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonControl2");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.query, r->in.level);
		ndr_print_netr_CONTROL_QUERY_INFORMATION(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerAuthenticate2(struct ndr_push *ndr, int flags, const struct netr_ServerAuthenticate2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		if (r->in.negotiate_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, *r->in.negotiate_flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		if (r->out.negotiate_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, *r->out.negotiate_flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerAuthenticate2(struct ndr_pull *ndr, int flags, struct netr_ServerAuthenticate2 *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credentials_0;
	TALLOC_CTX *_mem_save_return_credentials_0;
	TALLOC_CTX *_mem_save_negotiate_flags_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credentials);
		}
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.negotiate_flags);
		}
		_mem_save_negotiate_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.negotiate_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, r->in.negotiate_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_negotiate_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		ZERO_STRUCTP(r->out.return_credentials);
		NDR_PULL_ALLOC(ndr, r->out.negotiate_flags);
		*r->out.negotiate_flags = *r->in.negotiate_flags;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		}
		_mem_save_return_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.negotiate_flags);
		}
		_mem_save_negotiate_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.negotiate_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, r->out.negotiate_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_negotiate_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerAuthenticate2(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerAuthenticate2 *r)
{
	ndr_print_struct(ndr, name, "netr_ServerAuthenticate2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerAuthenticate2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credentials", r->in.credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "credentials", r->in.credentials);
		ndr->depth--;
		ndr_print_ptr(ndr, "negotiate_flags", r->in.negotiate_flags);
		ndr->depth++;
		ndr_print_netr_NegotiateFlags(ndr, "negotiate_flags", *r->in.negotiate_flags);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerAuthenticate2");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth--;
		ndr_print_ptr(ndr, "negotiate_flags", r->out.negotiate_flags);
		ndr->depth++;
		ndr_print_netr_NegotiateFlags(ndr, "negotiate_flags", *r->out.negotiate_flags);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DatabaseSync2(struct ndr_push *ndr, int flags, const struct netr_DatabaseSync2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.logon_server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_netr_SamDatabaseID(ndr, NDR_SCALARS, r->in.database_id));
		NDR_CHECK(ndr_push_SyncStateEnum(ndr, NDR_SCALARS, r->in.restart_state));
		if (r->in.sync_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.sync_context));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.preferredmaximumlength));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.sync_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sync_context));
		if (r->out.delta_enum_array == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.delta_enum_array));
		if (*r->out.delta_enum_array) {
			NDR_CHECK(ndr_push_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DatabaseSync2(struct ndr_pull *ndr, int flags, struct netr_DatabaseSync2 *r)
{
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	uint32_t _ptr_delta_enum_array;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_sync_context_0;
	TALLOC_CTX *_mem_save_delta_enum_array_0;
	TALLOC_CTX *_mem_save_delta_enum_array_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
		size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
		length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
		if (length_logon_server_1 > size_logon_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_SamDatabaseID(ndr, NDR_SCALARS, &r->in.database_id));
		NDR_CHECK(ndr_pull_SyncStateEnum(ndr, NDR_SCALARS, &r->in.restart_state));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sync_context);
		}
		_mem_save_sync_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sync_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.sync_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sync_context_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.preferredmaximumlength));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.sync_context);
		*r->out.sync_context = *r->in.sync_context;
		NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		ZERO_STRUCTP(r->out.delta_enum_array);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sync_context);
		}
		_mem_save_sync_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sync_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sync_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sync_context_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		}
		_mem_save_delta_enum_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.delta_enum_array, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delta_enum_array));
		if (_ptr_delta_enum_array) {
			NDR_PULL_ALLOC(ndr, *r->out.delta_enum_array);
		} else {
			*r->out.delta_enum_array = NULL;
		}
		if (*r->out.delta_enum_array) {
			_mem_save_delta_enum_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.delta_enum_array, 0);
			NDR_CHECK(ndr_pull_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DatabaseSync2(struct ndr_print *ndr, const char *name, int flags, const struct netr_DatabaseSync2 *r)
{
	ndr_print_struct(ndr, name, "netr_DatabaseSync2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DatabaseSync2");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		ndr_print_string(ndr, "logon_server", r->in.logon_server);
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_netr_SamDatabaseID(ndr, "database_id", r->in.database_id);
		ndr_print_SyncStateEnum(ndr, "restart_state", r->in.restart_state);
		ndr_print_ptr(ndr, "sync_context", r->in.sync_context);
		ndr->depth++;
		ndr_print_uint32(ndr, "sync_context", *r->in.sync_context);
		ndr->depth--;
		ndr_print_uint32(ndr, "preferredmaximumlength", r->in.preferredmaximumlength);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DatabaseSync2");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "sync_context", r->out.sync_context);
		ndr->depth++;
		ndr_print_uint32(ndr, "sync_context", *r->out.sync_context);
		ndr->depth--;
		ndr_print_ptr(ndr, "delta_enum_array", r->out.delta_enum_array);
		ndr->depth++;
		ndr_print_ptr(ndr, "delta_enum_array", *r->out.delta_enum_array);
		ndr->depth++;
		if (*r->out.delta_enum_array) {
			ndr_print_netr_DELTA_ENUM_ARRAY(ndr, "delta_enum_array", *r->out.delta_enum_array);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DatabaseRedo(struct ndr_push *ndr, int flags, const struct netr_DatabaseRedo *r)
{
	if (flags & NDR_IN) {
		if (r->in.logon_server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.computername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computername, ndr_charset_length(r->in.computername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		{
			struct ndr_push *_ndr_change_log_entry;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_change_log_entry, 4, -1));
			NDR_CHECK(ndr_push_netr_ChangeLogEntry(_ndr_change_log_entry, NDR_SCALARS|NDR_BUFFERS, &r->in.change_log_entry));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_change_log_entry, 4, -1));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_netr_ChangeLogEntry(&r->in.change_log_entry, ndr->flags)));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.delta_enum_array == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.delta_enum_array));
		if (*r->out.delta_enum_array) {
			NDR_CHECK(ndr_push_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DatabaseRedo(struct ndr_pull *ndr, int flags, struct netr_DatabaseRedo *r)
{
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	uint32_t size_computername_1 = 0;
	uint32_t length_computername_1 = 0;
	uint32_t _ptr_delta_enum_array;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_delta_enum_array_0;
	TALLOC_CTX *_mem_save_delta_enum_array_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
		size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
		length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
		if (length_logon_server_1 > size_logon_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computername));
		size_computername_1 = ndr_get_array_size(ndr, &r->in.computername);
		length_computername_1 = ndr_get_array_length(ndr, &r->in.computername);
		if (length_computername_1 > size_computername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computername_1, length_computername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computername, length_computername_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		{
			struct ndr_pull *_ndr_change_log_entry;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_change_log_entry, 4, -1));
			NDR_CHECK(ndr_pull_netr_ChangeLogEntry(_ndr_change_log_entry, NDR_SCALARS|NDR_BUFFERS, &r->in.change_log_entry));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_change_log_entry, 4, -1));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.change_log_entry_size));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		ZERO_STRUCTP(r->out.delta_enum_array);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.delta_enum_array);
		}
		_mem_save_delta_enum_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.delta_enum_array, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_delta_enum_array));
		if (_ptr_delta_enum_array) {
			NDR_PULL_ALLOC(ndr, *r->out.delta_enum_array);
		} else {
			*r->out.delta_enum_array = NULL;
		}
		if (*r->out.delta_enum_array) {
			_mem_save_delta_enum_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.delta_enum_array, 0);
			NDR_CHECK(ndr_pull_netr_DELTA_ENUM_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.delta_enum_array));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_delta_enum_array_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DatabaseRedo(struct ndr_print *ndr, const char *name, int flags, const struct netr_DatabaseRedo *r)
{
	ndr_print_struct(ndr, name, "netr_DatabaseRedo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DatabaseRedo");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		ndr_print_string(ndr, "logon_server", r->in.logon_server);
		ndr->depth--;
		ndr_print_ptr(ndr, "computername", r->in.computername);
		ndr->depth++;
		ndr_print_string(ndr, "computername", r->in.computername);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_netr_ChangeLogEntry(ndr, "change_log_entry", &r->in.change_log_entry);
		ndr_print_uint32(ndr, "change_log_entry_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_netr_ChangeLogEntry(&r->in.change_log_entry, ndr->flags):r->in.change_log_entry_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DatabaseRedo");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "delta_enum_array", r->out.delta_enum_array);
		ndr->depth++;
		ndr_print_ptr(ndr, "delta_enum_array", *r->out.delta_enum_array);
		ndr->depth++;
		if (*r->out.delta_enum_array) {
			ndr_print_netr_DELTA_ENUM_ARRAY(ndr, "delta_enum_array", *r->out.delta_enum_array);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonControl2Ex(struct ndr_push *ndr, int flags, const struct netr_LogonControl2Ex *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.logon_server));
		if (r->in.logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.logon_server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.logon_server, ndr_charset_length(r->in.logon_server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_LogonControlCode(ndr, NDR_SCALARS, r->in.function_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_push_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_push_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonControl2Ex(struct ndr_pull *ndr, int flags, struct netr_LogonControl2Ex *r)
{
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_query_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->in.logon_server);
		} else {
			r->in.logon_server = NULL;
		}
		if (r->in.logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.logon_server));
			size_logon_server_1 = ndr_get_array_size(ndr, &r->in.logon_server);
			length_logon_server_1 = ndr_get_array_length(ndr, &r->in.logon_server);
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.logon_server, length_logon_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonControlCode(ndr, NDR_SCALARS, &r->in.function_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_pull_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.query);
		ZERO_STRUCTP(r->out.query);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_pull_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonControl2Ex(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonControl2Ex *r)
{
	ndr_print_struct(ndr, name, "netr_LogonControl2Ex");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonControl2Ex");
		ndr->depth++;
		ndr_print_ptr(ndr, "logon_server", r->in.logon_server);
		ndr->depth++;
		if (r->in.logon_server) {
			ndr_print_string(ndr, "logon_server", r->in.logon_server);
		}
		ndr->depth--;
		ndr_print_netr_LogonControlCode(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.data, r->in.function_code);
		ndr_print_netr_CONTROL_DATA_INFORMATION(ndr, "data", r->in.data);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonControl2Ex");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.query, r->in.level);
		ndr_print_netr_CONTROL_QUERY_INFORMATION(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NetrEnumerateTrustedDomains(struct ndr_push *ndr, int flags, const struct netr_NetrEnumerateTrustedDomains *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.trusted_domains_blob == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Blob(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trusted_domains_blob));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NetrEnumerateTrustedDomains(struct ndr_pull *ndr, int flags, struct netr_NetrEnumerateTrustedDomains *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_trusted_domains_blob_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.trusted_domains_blob);
		ZERO_STRUCTP(r->out.trusted_domains_blob);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trusted_domains_blob);
		}
		_mem_save_trusted_domains_blob_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trusted_domains_blob, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Blob(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trusted_domains_blob));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domains_blob_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NetrEnumerateTrustedDomains(struct ndr_print *ndr, const char *name, int flags, const struct netr_NetrEnumerateTrustedDomains *r)
{
	ndr_print_struct(ndr, name, "netr_NetrEnumerateTrustedDomains");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NetrEnumerateTrustedDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NetrEnumerateTrustedDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "trusted_domains_blob", r->out.trusted_domains_blob);
		ndr->depth++;
		ndr_print_netr_Blob(ndr, "trusted_domains_blob", r->out.trusted_domains_blob);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetDCName(struct ndr_push *ndr, int flags, const struct netr_DsRGetDCName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_name));
		if (r->in.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_guid));
		if (r->in.site_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.site_guid));
		}
		NDR_CHECK(ndr_push_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetDCName(struct ndr_pull *ndr, int flags, struct netr_DsRGetDCName *r)
{
	uint32_t _ptr_server_unc;
	uint32_t size_server_unc_1 = 0;
	uint32_t length_server_unc_1 = 0;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_site_guid;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_domain_guid_0;
	TALLOC_CTX *_mem_save_site_guid_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			size_server_unc_1 = ndr_get_array_size(ndr, &r->in.server_unc);
			length_server_unc_1 = ndr_get_array_length(ndr, &r->in.server_unc);
			if (length_server_unc_1 > size_server_unc_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_unc_1, length_server_unc_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_unc_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, length_server_unc_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		} else {
			r->in.domain_name = NULL;
		}
		if (r->in.domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
			size_domain_name_1 = ndr_get_array_size(ndr, &r->in.domain_name);
			length_domain_name_1 = ndr_get_array_length(ndr, &r->in.domain_name);
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_guid));
		if (_ptr_site_guid) {
			NDR_PULL_ALLOC(ndr, r->in.site_guid);
		} else {
			r->in.site_guid = NULL;
		}
		if (r->in.site_guid) {
			_mem_save_site_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.site_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCName(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRGetDCName *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetDCName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_guid", r->in.site_guid);
		ndr->depth++;
		if (r->in.site_guid) {
			ndr_print_GUID(ndr, "site_guid", r->in.site_guid);
		}
		ndr->depth--;
		ndr_print_netr_DsRGetDCName_flags(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_netr_DsRGetDCNameInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonGetCapabilities(struct ndr_push *ndr, int flags, const struct netr_LogonGetCapabilities *r)
{
	if (flags & NDR_IN) {
		if (r->in.server_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.query_level));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.capabilities == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.capabilities, r->in.query_level));
		NDR_CHECK(ndr_push_netr_Capabilities(ndr, NDR_SCALARS, r->out.capabilities));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonGetCapabilities(struct ndr_pull *ndr, int flags, struct netr_LogonGetCapabilities *r)
{
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_capabilities_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
		size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
		length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
		if (length_server_name_1 > size_server_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.query_level));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.capabilities);
		ZERO_STRUCTP(r->out.capabilities);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.capabilities);
		}
		_mem_save_capabilities_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.capabilities, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.capabilities, r->in.query_level));
		NDR_CHECK(ndr_pull_netr_Capabilities(ndr, NDR_SCALARS, r->out.capabilities));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_capabilities_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonGetCapabilities(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonGetCapabilities *r)
{
	ndr_print_struct(ndr, name, "netr_LogonGetCapabilities");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonGetCapabilities");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_uint32(ndr, "query_level", r->in.query_level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonGetCapabilities");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "capabilities", r->out.capabilities);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.capabilities, r->in.query_level);
		ndr_print_netr_Capabilities(ndr, "capabilities", r->out.capabilities);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETRLOGONSETSERVICEBITS(struct ndr_push *ndr, int flags, const struct netr_NETRLOGONSETSERVICEBITS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETRLOGONSETSERVICEBITS(struct ndr_pull *ndr, int flags, struct netr_NETRLOGONSETSERVICEBITS *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETRLOGONSETSERVICEBITS(struct ndr_print *ndr, const char *name, int flags, const struct netr_NETRLOGONSETSERVICEBITS *r)
{
	ndr_print_struct(ndr, name, "netr_NETRLOGONSETSERVICEBITS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NETRLOGONSETSERVICEBITS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NETRLOGONSETSERVICEBITS");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonGetTrustRid(struct ndr_push *ndr, int flags, const struct netr_LogonGetTrustRid *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_name));
		if (r->in.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonGetTrustRid(struct ndr_pull *ndr, int flags, struct netr_LogonGetTrustRid *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		} else {
			r->in.domain_name = NULL;
		}
		if (r->in.domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
			size_domain_name_1 = ndr_get_array_size(ndr, &r->in.domain_name);
			length_domain_name_1 = ndr_get_array_length(ndr, &r->in.domain_name);
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonGetTrustRid(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonGetTrustRid *r)
{
	ndr_print_struct(ndr, name, "netr_LogonGetTrustRid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonGetTrustRid");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonGetTrustRid");
		ndr->depth++;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETRLOGONCOMPUTESERVERDIGEST(struct ndr_push *ndr, int flags, const struct netr_NETRLOGONCOMPUTESERVERDIGEST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETRLOGONCOMPUTESERVERDIGEST(struct ndr_pull *ndr, int flags, struct netr_NETRLOGONCOMPUTESERVERDIGEST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETRLOGONCOMPUTESERVERDIGEST(struct ndr_print *ndr, const char *name, int flags, const struct netr_NETRLOGONCOMPUTESERVERDIGEST *r)
{
	ndr_print_struct(ndr, name, "netr_NETRLOGONCOMPUTESERVERDIGEST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NETRLOGONCOMPUTESERVERDIGEST");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NETRLOGONCOMPUTESERVERDIGEST");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct ndr_push *ndr, int flags, const struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct ndr_pull *ndr, int flags, struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct ndr_print *ndr, const char *name, int flags, const struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r)
{
	ndr_print_struct(ndr, name, "netr_NETRLOGONCOMPUTECLIENTDIGEST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NETRLOGONCOMPUTECLIENTDIGEST");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NETRLOGONCOMPUTECLIENTDIGEST");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_ServerAuthenticate3(struct ndr_push *ndr, int flags, const struct netr_ServerAuthenticate3 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		if (r->in.negotiate_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, *r->in.negotiate_flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_credentials == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		if (r->out.negotiate_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, *r->out.negotiate_flags));
		if (r->out.rid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.rid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_ServerAuthenticate3(struct ndr_pull *ndr, int flags, struct netr_ServerAuthenticate3 *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credentials_0;
	TALLOC_CTX *_mem_save_return_credentials_0;
	TALLOC_CTX *_mem_save_negotiate_flags_0;
	TALLOC_CTX *_mem_save_rid_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credentials);
		}
		_mem_save_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->in.credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.negotiate_flags);
		}
		_mem_save_negotiate_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.negotiate_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, r->in.negotiate_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_negotiate_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		ZERO_STRUCTP(r->out.return_credentials);
		NDR_PULL_ALLOC(ndr, r->out.negotiate_flags);
		*r->out.negotiate_flags = *r->in.negotiate_flags;
		NDR_PULL_ALLOC(ndr, r->out.rid);
		ZERO_STRUCTP(r->out.rid);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_credentials);
		}
		_mem_save_return_credentials_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_credentials, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, r->out.return_credentials));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_credentials_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.negotiate_flags);
		}
		_mem_save_negotiate_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.negotiate_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, r->out.negotiate_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_negotiate_flags_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rid);
		}
		_mem_save_rid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.rid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerAuthenticate3(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerAuthenticate3 *r)
{
	ndr_print_struct(ndr, name, "netr_ServerAuthenticate3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerAuthenticate3");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credentials", r->in.credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "credentials", r->in.credentials);
		ndr->depth--;
		ndr_print_ptr(ndr, "negotiate_flags", r->in.negotiate_flags);
		ndr->depth++;
		ndr_print_netr_NegotiateFlags(ndr, "negotiate_flags", *r->in.negotiate_flags);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerAuthenticate3");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth++;
		ndr_print_netr_Credential(ndr, "return_credentials", r->out.return_credentials);
		ndr->depth--;
		ndr_print_ptr(ndr, "negotiate_flags", r->out.negotiate_flags);
		ndr->depth++;
		ndr_print_netr_NegotiateFlags(ndr, "negotiate_flags", *r->out.negotiate_flags);
		ndr->depth--;
		ndr_print_ptr(ndr, "rid", r->out.rid);
		ndr->depth++;
		ndr_print_uint32(ndr, "rid", *r->out.rid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetDCNameEx(struct ndr_push *ndr, int flags, const struct netr_DsRGetDCNameEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_name));
		if (r->in.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetDCNameEx(struct ndr_pull *ndr, int flags, struct netr_DsRGetDCNameEx *r)
{
	uint32_t _ptr_server_unc;
	uint32_t size_server_unc_1 = 0;
	uint32_t length_server_unc_1 = 0;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_domain_guid_0;
	TALLOC_CTX *_mem_save_site_name_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			size_server_unc_1 = ndr_get_array_size(ndr, &r->in.server_unc);
			length_server_unc_1 = ndr_get_array_length(ndr, &r->in.server_unc);
			if (length_server_unc_1 > size_server_unc_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_unc_1, length_server_unc_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_unc_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, length_server_unc_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		} else {
			r->in.domain_name = NULL;
		}
		if (r->in.domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
			size_domain_name_1 = ndr_get_array_size(ndr, &r->in.domain_name);
			length_domain_name_1 = ndr_get_array_length(ndr, &r->in.domain_name);
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			size_site_name_1 = ndr_get_array_size(ndr, &r->in.site_name);
			length_site_name_1 = ndr_get_array_length(ndr, &r->in.site_name);
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCNameEx(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRGetDCNameEx *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetDCNameEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRGetDCNameEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_netr_DsRGetDCName_flags(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRGetDCNameEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_netr_DsRGetDCNameInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetSiteName(struct ndr_push *ndr, int flags, const struct netr_DsRGetSiteName *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.site == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.site));
		if (*r->out.site) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.site, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.site, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.site, ndr_charset_length(*r->out.site, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetSiteName(struct ndr_pull *ndr, int flags, struct netr_DsRGetSiteName *r)
{
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_site;
	uint32_t size_site_2 = 0;
	uint32_t length_site_2 = 0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_site_0;
	TALLOC_CTX *_mem_save_site_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.site);
		ZERO_STRUCTP(r->out.site);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.site);
		}
		_mem_save_site_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.site, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site));
		if (_ptr_site) {
			NDR_PULL_ALLOC(ndr, *r->out.site);
		} else {
			*r->out.site = NULL;
		}
		if (*r->out.site) {
			_mem_save_site_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.site, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.site));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.site));
			size_site_2 = ndr_get_array_size(ndr, r->out.site);
			length_site_2 = ndr_get_array_length(ndr, r->out.site);
			if (length_site_2 > size_site_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_site_2, length_site_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.site, length_site_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetSiteName(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRGetSiteName *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetSiteName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRGetSiteName");
		ndr->depth++;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRGetSiteName");
		ndr->depth++;
		ndr_print_ptr(ndr, "site", r->out.site);
		ndr->depth++;
		ndr_print_ptr(ndr, "site", *r->out.site);
		ndr->depth++;
		if (*r->out.site) {
			ndr_print_string(ndr, "site", *r->out.site);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonGetDomainInfo(struct ndr_push *ndr, int flags, const struct netr_LogonGetDomainInfo *r)
{
	if (flags & NDR_IN) {
		if (r->in.server_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.query, r->in.level));
		NDR_CHECK(ndr_push_netr_WorkstationInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.query));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_netr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonGetDomainInfo(struct ndr_pull *ndr, int flags, struct netr_LogonGetDomainInfo *r)
{
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_query_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
		size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
		length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
		if (length_server_name_1 > size_server_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.query, r->in.level));
		NDR_CHECK(ndr_pull_netr_WorkstationInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		*r->out.return_authenticator = *r->in.return_authenticator;
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_netr_DomainInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonGetDomainInfo(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonGetDomainInfo *r)
{
	ndr_print_struct(ndr, name, "netr_LogonGetDomainInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonGetDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "query", r->in.query);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.query, r->in.level);
		ndr_print_netr_WorkstationInfo(ndr, "query", r->in.query);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonGetDomainInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_netr_DomainInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerPasswordSet2(struct ndr_push *ndr, int flags, const struct netr_ServerPasswordSet2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		if (r->in.new_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_CryptPassword(ndr, NDR_SCALARS, r->in.new_password));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerPasswordSet2(struct ndr_pull *ndr, int flags, struct netr_ServerPasswordSet2 *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_new_password_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.new_password);
		}
		_mem_save_new_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.new_password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_CryptPassword(ndr, NDR_SCALARS, r->in.new_password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_password_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerPasswordSet2(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerPasswordSet2 *r)
{
	ndr_print_struct(ndr, name, "netr_ServerPasswordSet2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerPasswordSet2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_password", r->in.new_password);
		ndr->depth++;
		ndr_print_netr_CryptPassword(ndr, "new_password", r->in.new_password);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerPasswordSet2");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerPasswordGet(struct ndr_push *ndr, int flags, const struct netr_ServerPasswordGet *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->out.password));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerPasswordGet(struct ndr_pull *ndr, int flags, struct netr_ServerPasswordGet *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_password_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
		NDR_PULL_ALLOC(ndr, r->out.password);
		ZERO_STRUCTP(r->out.password);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.password);
		}
		_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->out.password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerPasswordGet(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerPasswordGet *r)
{
	ndr_print_struct(ndr, name, "netr_ServerPasswordGet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerPasswordGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerPasswordGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->out.password);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "password", r->out.password);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETRLOGONSENDTOSAM(struct ndr_push *ndr, int flags, const struct netr_NETRLOGONSENDTOSAM *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETRLOGONSENDTOSAM(struct ndr_pull *ndr, int flags, struct netr_NETRLOGONSENDTOSAM *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETRLOGONSENDTOSAM(struct ndr_print *ndr, const char *name, int flags, const struct netr_NETRLOGONSENDTOSAM *r)
{
	ndr_print_struct(ndr, name, "netr_NETRLOGONSENDTOSAM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NETRLOGONSENDTOSAM");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NETRLOGONSENDTOSAM");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRAddressToSitenamesW(struct ndr_push *ndr, int flags, const struct netr_DsRAddressToSitenamesW *r)
{
	uint32_t cntr_addresses_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
		if (r->in.addresses == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.count));
		for (cntr_addresses_1 = 0; cntr_addresses_1 < r->in.count; cntr_addresses_1++) {
			NDR_CHECK(ndr_push_netr_DsRAddress(ndr, NDR_SCALARS, &r->in.addresses[cntr_addresses_1]));
		}
		for (cntr_addresses_1 = 0; cntr_addresses_1 < r->in.count; cntr_addresses_1++) {
			NDR_CHECK(ndr_push_netr_DsRAddress(ndr, NDR_BUFFERS, &r->in.addresses[cntr_addresses_1]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ctr));
		if (*r->out.ctr) {
			NDR_CHECK(ndr_push_netr_DsRAddressToSitenamesWCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRAddressToSitenamesW(struct ndr_pull *ndr, int flags, struct netr_DsRAddressToSitenamesW *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_addresses_1 = 0;
	uint32_t cntr_addresses_1;
	uint32_t _ptr_ctr;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_addresses_1;
	TALLOC_CTX *_mem_save_ctr_0;
	TALLOC_CTX *_mem_save_ctr_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
		if (r->in.count > 32000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.addresses));
		size_addresses_1 = ndr_get_array_size(ndr, &r->in.addresses);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.addresses, size_addresses_1);
		}
		_mem_save_addresses_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addresses, 0);
		for (cntr_addresses_1 = 0; cntr_addresses_1 < size_addresses_1; cntr_addresses_1++) {
			NDR_CHECK(ndr_pull_netr_DsRAddress(ndr, NDR_SCALARS, &r->in.addresses[cntr_addresses_1]));
		}
		for (cntr_addresses_1 = 0; cntr_addresses_1 < size_addresses_1; cntr_addresses_1++) {
			NDR_CHECK(ndr_pull_netr_DsRAddress(ndr, NDR_BUFFERS, &r->in.addresses[cntr_addresses_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addresses_1, 0);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		ZERO_STRUCTP(r->out.ctr);
		if (r->in.addresses) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.addresses, r->in.count));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr));
		if (_ptr_ctr) {
			NDR_PULL_ALLOC(ndr, *r->out.ctr);
		} else {
			*r->out.ctr = NULL;
		}
		if (*r->out.ctr) {
			_mem_save_ctr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ctr, 0);
			NDR_CHECK(ndr_pull_netr_DsRAddressToSitenamesWCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRAddressToSitenamesW(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRAddressToSitenamesW *r)
{
	uint32_t cntr_addresses_1;
	ndr_print_struct(ndr, name, "netr_DsRAddressToSitenamesW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRAddressToSitenamesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "count", r->in.count);
		ndr_print_ptr(ndr, "addresses", r->in.addresses);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "addresses", (int)r->in.count);
		ndr->depth++;
		for (cntr_addresses_1=0;cntr_addresses_1<r->in.count;cntr_addresses_1++) {
			ndr_print_netr_DsRAddress(ndr, "addresses", &r->in.addresses[cntr_addresses_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRAddressToSitenamesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", *r->out.ctr);
		ndr->depth++;
		if (*r->out.ctr) {
			ndr_print_netr_DsRAddressToSitenamesWCtr(ndr, "ctr", *r->out.ctr);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetDCNameEx2(struct ndr_push *ndr, int flags, const struct netr_DsRGetDCNameEx2 *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.client_account));
		if (r->in.client_account) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_account, ndr_charset_length(r->in.client_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_samr_AcctFlags(ndr, NDR_SCALARS, r->in.mask));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_name));
		if (r->in.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetDCNameEx2(struct ndr_pull *ndr, int flags, struct netr_DsRGetDCNameEx2 *r)
{
	uint32_t _ptr_server_unc;
	uint32_t size_server_unc_1 = 0;
	uint32_t length_server_unc_1 = 0;
	uint32_t _ptr_client_account;
	uint32_t size_client_account_1 = 0;
	uint32_t length_client_account_1 = 0;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_client_account_0;
	TALLOC_CTX *_mem_save_domain_name_0;
	TALLOC_CTX *_mem_save_domain_guid_0;
	TALLOC_CTX *_mem_save_site_name_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			size_server_unc_1 = ndr_get_array_size(ndr, &r->in.server_unc);
			length_server_unc_1 = ndr_get_array_length(ndr, &r->in.server_unc);
			if (length_server_unc_1 > size_server_unc_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_unc_1, length_server_unc_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_unc_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, length_server_unc_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_account));
		if (_ptr_client_account) {
			NDR_PULL_ALLOC(ndr, r->in.client_account);
		} else {
			r->in.client_account = NULL;
		}
		if (r->in.client_account) {
			_mem_save_client_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.client_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_account));
			size_client_account_1 = ndr_get_array_size(ndr, &r->in.client_account);
			length_client_account_1 = ndr_get_array_length(ndr, &r->in.client_account);
			if (length_client_account_1 > size_client_account_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_client_account_1, length_client_account_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_client_account_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_account, length_client_account_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_account_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_AcctFlags(ndr, NDR_SCALARS, &r->in.mask));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.domain_name);
		} else {
			r->in.domain_name = NULL;
		}
		if (r->in.domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
			size_domain_name_1 = ndr_get_array_size(ndr, &r->in.domain_name);
			length_domain_name_1 = ndr_get_array_length(ndr, &r->in.domain_name);
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			size_site_name_1 = ndr_get_array_size(ndr, &r->in.site_name);
			length_site_name_1 = ndr_get_array_length(ndr, &r->in.site_name);
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_DsRGetDCName_flags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetDCNameEx2(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRGetDCNameEx2 *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetDCNameEx2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRGetDCNameEx2");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "client_account", r->in.client_account);
		ndr->depth++;
		if (r->in.client_account) {
			ndr_print_string(ndr, "client_account", r->in.client_account);
		}
		ndr->depth--;
		ndr_print_samr_AcctFlags(ndr, "mask", r->in.mask);
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_netr_DsRGetDCName_flags(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRGetDCNameEx2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_netr_DsRGetDCNameInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct ndr_push *ndr, int flags, const struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct ndr_pull *ndr, int flags, struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct ndr_print *ndr, const char *name, int flags, const struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r)
{
	ndr_print_struct(ndr, name, "netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_NetrEnumerateTrustedDomainsEx(struct ndr_push *ndr, int flags, const struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.dom_trust_list == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dom_trust_list));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_NetrEnumerateTrustedDomainsEx(struct ndr_pull *ndr, int flags, struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_dom_trust_list_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.dom_trust_list);
		ZERO_STRUCTP(r->out.dom_trust_list);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dom_trust_list);
		}
		_mem_save_dom_trust_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dom_trust_list, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dom_trust_list));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_trust_list_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_NetrEnumerateTrustedDomainsEx(struct ndr_print *ndr, const char *name, int flags, const struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	ndr_print_struct(ndr, name, "netr_NetrEnumerateTrustedDomainsEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_NetrEnumerateTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_NetrEnumerateTrustedDomainsEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "dom_trust_list", r->out.dom_trust_list);
		ndr->depth++;
		ndr_print_netr_DomainTrustList(ndr, "dom_trust_list", r->out.dom_trust_list);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRAddressToSitenamesExW(struct ndr_push *ndr, int flags, const struct netr_DsRAddressToSitenamesExW *r)
{
	uint32_t cntr_addresses_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
		if (r->in.addresses == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.count));
		for (cntr_addresses_1 = 0; cntr_addresses_1 < r->in.count; cntr_addresses_1++) {
			NDR_CHECK(ndr_push_netr_DsRAddress(ndr, NDR_SCALARS, &r->in.addresses[cntr_addresses_1]));
		}
		for (cntr_addresses_1 = 0; cntr_addresses_1 < r->in.count; cntr_addresses_1++) {
			NDR_CHECK(ndr_push_netr_DsRAddress(ndr, NDR_BUFFERS, &r->in.addresses[cntr_addresses_1]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ctr));
		if (*r->out.ctr) {
			NDR_CHECK(ndr_push_netr_DsRAddressToSitenamesExWCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRAddressToSitenamesExW(struct ndr_pull *ndr, int flags, struct netr_DsRAddressToSitenamesExW *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_addresses_1 = 0;
	uint32_t cntr_addresses_1;
	uint32_t _ptr_ctr;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_addresses_1;
	TALLOC_CTX *_mem_save_ctr_0;
	TALLOC_CTX *_mem_save_ctr_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
		if (r->in.count > 32000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.addresses));
		size_addresses_1 = ndr_get_array_size(ndr, &r->in.addresses);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.addresses, size_addresses_1);
		}
		_mem_save_addresses_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addresses, 0);
		for (cntr_addresses_1 = 0; cntr_addresses_1 < size_addresses_1; cntr_addresses_1++) {
			NDR_CHECK(ndr_pull_netr_DsRAddress(ndr, NDR_SCALARS, &r->in.addresses[cntr_addresses_1]));
		}
		for (cntr_addresses_1 = 0; cntr_addresses_1 < size_addresses_1; cntr_addresses_1++) {
			NDR_CHECK(ndr_pull_netr_DsRAddress(ndr, NDR_BUFFERS, &r->in.addresses[cntr_addresses_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addresses_1, 0);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		ZERO_STRUCTP(r->out.ctr);
		if (r->in.addresses) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.addresses, r->in.count));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr));
		if (_ptr_ctr) {
			NDR_PULL_ALLOC(ndr, *r->out.ctr);
		} else {
			*r->out.ctr = NULL;
		}
		if (*r->out.ctr) {
			_mem_save_ctr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ctr, 0);
			NDR_CHECK(ndr_pull_netr_DsRAddressToSitenamesExWCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRAddressToSitenamesExW(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRAddressToSitenamesExW *r)
{
	uint32_t cntr_addresses_1;
	ndr_print_struct(ndr, name, "netr_DsRAddressToSitenamesExW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRAddressToSitenamesExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "count", r->in.count);
		ndr_print_ptr(ndr, "addresses", r->in.addresses);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "addresses", (int)r->in.count);
		ndr->depth++;
		for (cntr_addresses_1=0;cntr_addresses_1<r->in.count;cntr_addresses_1++) {
			ndr_print_netr_DsRAddress(ndr, "addresses", &r->in.addresses[cntr_addresses_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRAddressToSitenamesExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", *r->out.ctr);
		ndr->depth++;
		if (*r->out.ctr) {
			ndr_print_netr_DsRAddressToSitenamesExWCtr(ndr, "ctr", *r->out.ctr);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsrGetDcSiteCoverageW(struct ndr_push *ndr, int flags, const struct netr_DsrGetDcSiteCoverageW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ctr));
		if (*r->out.ctr) {
			NDR_CHECK(ndr_push_DcSitesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsrGetDcSiteCoverageW(struct ndr_pull *ndr, int flags, struct netr_DsrGetDcSiteCoverageW *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_ctr;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_ctr_0;
	TALLOC_CTX *_mem_save_ctr_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr));
		if (_ptr_ctr) {
			NDR_PULL_ALLOC(ndr, *r->out.ctr);
		} else {
			*r->out.ctr = NULL;
		}
		if (*r->out.ctr) {
			_mem_save_ctr_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ctr, 0);
			NDR_CHECK(ndr_pull_DcSitesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsrGetDcSiteCoverageW(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsrGetDcSiteCoverageW *r)
{
	ndr_print_struct(ndr, name, "netr_DsrGetDcSiteCoverageW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsrGetDcSiteCoverageW");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsrGetDcSiteCoverageW");
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_ptr(ndr, "ctr", *r->out.ctr);
		ndr->depth++;
		if (*r->out.ctr) {
			ndr_print_DcSitesCtr(ndr, "ctr", *r->out.ctr);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonSamLogonEx(struct ndr_push *ndr, int flags, const struct netr_LogonSamLogonEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_LogonInfoClass(ndr, NDR_SCALARS, r->in.logon_level));
		if (r->in.logon == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.validation_level));
		if (r->in.flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.validation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		if (r->out.authoritative == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->out.authoritative));
		if (r->out.flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonSamLogonEx(struct ndr_pull *ndr, int flags, struct netr_LogonSamLogonEx *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_logon_0;
	TALLOC_CTX *_mem_save_validation_0;
	TALLOC_CTX *_mem_save_authoritative_0;
	TALLOC_CTX *_mem_save_flags_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonInfoClass(ndr, NDR_SCALARS, &r->in.logon_level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logon);
		}
		_mem_save_logon_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logon, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.validation_level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.flags);
		}
		_mem_save_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.validation);
		ZERO_STRUCTP(r->out.validation);
		NDR_PULL_ALLOC(ndr, r->out.authoritative);
		ZERO_STRUCTP(r->out.authoritative);
		NDR_PULL_ALLOC(ndr, r->out.flags);
		*r->out.flags = *r->in.flags;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.validation);
		}
		_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.validation, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.authoritative);
		}
		_mem_save_authoritative_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.authoritative, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authoritative_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.flags);
		}
		_mem_save_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonSamLogonEx(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonSamLogonEx *r)
{
	ndr_print_struct(ndr, name, "netr_LogonSamLogonEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonSamLogonEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_netr_LogonInfoClass(ndr, "logon_level", r->in.logon_level);
		ndr_print_ptr(ndr, "logon", r->in.logon);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", r->in.logon);
		ndr->depth--;
		ndr_print_uint16(ndr, "validation_level", r->in.validation_level);
		ndr_print_ptr(ndr, "flags", r->in.flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", *r->in.flags);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonSamLogonEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "validation", r->out.validation);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.validation, r->in.validation_level);
		ndr_print_netr_Validation(ndr, "validation", r->out.validation);
		ndr->depth--;
		ndr_print_ptr(ndr, "authoritative", r->out.authoritative);
		ndr->depth++;
		ndr_print_uint8(ndr, "authoritative", *r->out.authoritative);
		ndr->depth--;
		ndr_print_ptr(ndr, "flags", r->out.flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", *r->out.flags);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsrEnumerateDomainTrusts(struct ndr_push *ndr, int flags, const struct netr_DsrEnumerateDomainTrusts *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_netr_TrustFlags(ndr, NDR_SCALARS, r->in.trust_flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.trusts == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trusts));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsrEnumerateDomainTrusts(struct ndr_pull *ndr, int flags, struct netr_DsrEnumerateDomainTrusts *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_trusts_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_TrustFlags(ndr, NDR_SCALARS, &r->in.trust_flags));
		NDR_PULL_ALLOC(ndr, r->out.trusts);
		ZERO_STRUCTP(r->out.trusts);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trusts);
		}
		_mem_save_trusts_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trusts, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.trusts));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusts_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsrEnumerateDomainTrusts(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsrEnumerateDomainTrusts *r)
{
	ndr_print_struct(ndr, name, "netr_DsrEnumerateDomainTrusts");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsrEnumerateDomainTrusts");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_netr_TrustFlags(ndr, "trust_flags", r->in.trust_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsrEnumerateDomainTrusts");
		ndr->depth++;
		ndr_print_ptr(ndr, "trusts", r->out.trusts);
		ndr->depth++;
		ndr_print_netr_DomainTrustList(ndr, "trusts", r->out.trusts);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsrDeregisterDNSHostRecords(struct ndr_push *ndr, int flags, const struct netr_DsrDeregisterDNSHostRecords *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain));
		if (r->in.domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain, ndr_charset_length(r->in.domain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dsa_guid));
		if (r->in.dsa_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.dsa_guid));
		}
		if (r->in.dns_host == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_host, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_host, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dns_host, ndr_charset_length(r->in.dns_host, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsrDeregisterDNSHostRecords(struct ndr_pull *ndr, int flags, struct netr_DsrDeregisterDNSHostRecords *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_domain;
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_dsa_guid;
	uint32_t size_dns_host_1 = 0;
	uint32_t length_dns_host_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_domain_0;
	TALLOC_CTX *_mem_save_domain_guid_0;
	TALLOC_CTX *_mem_save_dsa_guid_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->in.domain);
		} else {
			r->in.domain = NULL;
		}
		if (r->in.domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain));
			size_domain_1 = ndr_get_array_size(ndr, &r->in.domain);
			length_domain_1 = ndr_get_array_length(ndr, &r->in.domain);
			if (length_domain_1 > size_domain_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_domain_1, length_domain_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain, length_domain_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dsa_guid));
		if (_ptr_dsa_guid) {
			NDR_PULL_ALLOC(ndr, r->in.dsa_guid);
		} else {
			r->in.dsa_guid = NULL;
		}
		if (r->in.dsa_guid) {
			_mem_save_dsa_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dsa_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.dsa_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dsa_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dns_host));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dns_host));
		size_dns_host_1 = ndr_get_array_size(ndr, &r->in.dns_host);
		length_dns_host_1 = ndr_get_array_length(ndr, &r->in.dns_host);
		if (length_dns_host_1 > size_dns_host_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_host_1, length_dns_host_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_host_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dns_host, length_dns_host_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsrDeregisterDNSHostRecords(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsrDeregisterDNSHostRecords *r)
{
	ndr_print_struct(ndr, name, "netr_DsrDeregisterDNSHostRecords");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsrDeregisterDNSHostRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		if (r->in.domain) {
			ndr_print_string(ndr, "domain", r->in.domain);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dsa_guid", r->in.dsa_guid);
		ndr->depth++;
		if (r->in.dsa_guid) {
			ndr_print_GUID(ndr, "dsa_guid", r->in.dsa_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dns_host", r->in.dns_host);
		ndr->depth++;
		ndr_print_string(ndr, "dns_host", r->in.dns_host);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsrDeregisterDNSHostRecords");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerTrustPasswordsGet(struct ndr_push *ndr, int flags, const struct netr_ServerTrustPasswordsGet *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->out.password));
		if (r->out.password2 == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->out.password2));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerTrustPasswordsGet(struct ndr_pull *ndr, int flags, struct netr_ServerTrustPasswordsGet *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_password_0;
	TALLOC_CTX *_mem_save_password2_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
		NDR_PULL_ALLOC(ndr, r->out.password);
		ZERO_STRUCTP(r->out.password);
		NDR_PULL_ALLOC(ndr, r->out.password2);
		ZERO_STRUCTP(r->out.password2);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.password);
		}
		_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->out.password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.password2);
		}
		_mem_save_password2_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.password2, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->out.password2));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password2_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerTrustPasswordsGet(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerTrustPasswordsGet *r)
{
	ndr_print_struct(ndr, name, "netr_ServerTrustPasswordsGet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerTrustPasswordsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerTrustPasswordsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->out.password);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "password", r->out.password);
		ndr->depth--;
		ndr_print_ptr(ndr, "password2", r->out.password2);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "password2", r->out.password2);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsRGetForestTrustInformation(struct ndr_push *ndr, int flags, const struct netr_DsRGetForestTrustInformation *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.trusted_domain_name));
		if (r->in.trusted_domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.trusted_domain_name, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.forest_trust_info));
		if (*r->out.forest_trust_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsRGetForestTrustInformation(struct ndr_pull *ndr, int flags, struct netr_DsRGetForestTrustInformation *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_trusted_domain_name;
	uint32_t size_trusted_domain_name_1 = 0;
	uint32_t length_trusted_domain_name_1 = 0;
	uint32_t _ptr_forest_trust_info;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_trusted_domain_name_0;
	TALLOC_CTX *_mem_save_forest_trust_info_0;
	TALLOC_CTX *_mem_save_forest_trust_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_domain_name));
		if (_ptr_trusted_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		} else {
			r->in.trusted_domain_name = NULL;
		}
		if (r->in.trusted_domain_name) {
			_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.trusted_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.trusted_domain_name));
			size_trusted_domain_name_1 = ndr_get_array_size(ndr, &r->in.trusted_domain_name);
			length_trusted_domain_name_1 = ndr_get_array_length(ndr, &r->in.trusted_domain_name);
			if (length_trusted_domain_name_1 > size_trusted_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_trusted_domain_name_1, length_trusted_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_trusted_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.trusted_domain_name, length_trusted_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		ZERO_STRUCTP(r->out.forest_trust_info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_info));
		if (_ptr_forest_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.forest_trust_info);
		} else {
			*r->out.forest_trust_info = NULL;
		}
		if (*r->out.forest_trust_info) {
			_mem_save_forest_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.forest_trust_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsRGetForestTrustInformation(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsRGetForestTrustInformation *r)
{
	ndr_print_struct(ndr, name, "netr_DsRGetForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsRGetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		if (r->in.trusted_domain_name) {
			ndr_print_string(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsRGetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", r->out.forest_trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", *r->out.forest_trust_info);
		ndr->depth++;
		if (*r->out.forest_trust_info) {
			ndr_print_lsa_ForestTrustInformation(ndr, "forest_trust_info", *r->out.forest_trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_GetForestTrustInformation(struct ndr_push *ndr, int flags, const struct netr_GetForestTrustInformation *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.forest_trust_info));
		if (*r->out.forest_trust_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_GetForestTrustInformation(struct ndr_pull *ndr, int flags, struct netr_GetForestTrustInformation *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_forest_trust_info;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_forest_trust_info_0;
	TALLOC_CTX *_mem_save_forest_trust_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
		NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		ZERO_STRUCTP(r->out.forest_trust_info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_info));
		if (_ptr_forest_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.forest_trust_info);
		} else {
			*r->out.forest_trust_info = NULL;
		}
		if (*r->out.forest_trust_info) {
			_mem_save_forest_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.forest_trust_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_GetForestTrustInformation(struct ndr_print *ndr, const char *name, int flags, const struct netr_GetForestTrustInformation *r)
{
	ndr_print_struct(ndr, name, "netr_GetForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_GetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_GetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "forest_trust_info", r->out.forest_trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", *r->out.forest_trust_info);
		ndr->depth++;
		if (*r->out.forest_trust_info) {
			ndr_print_lsa_ForestTrustInformation(ndr, "forest_trust_info", *r->out.forest_trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_LogonSamLogonWithFlags(struct ndr_push *ndr, int flags, const struct netr_LogonSamLogonWithFlags *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.computer_name));
		if (r->in.computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.credential));
		if (r->in.credential) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.return_authenticator));
		if (r->in.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
		}
		NDR_CHECK(ndr_push_netr_LogonInfoClass(ndr, NDR_SCALARS, r->in.logon_level));
		if (r->in.logon == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.validation_level));
		if (r->in.flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.return_authenticator));
		if (r->out.return_authenticator) {
			NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		}
		if (r->out.validation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		if (r->out.authoritative == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->out.authoritative));
		if (r->out.flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_LogonSamLogonWithFlags(struct ndr_pull *ndr, int flags, struct netr_LogonSamLogonWithFlags *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_credential;
	uint32_t _ptr_return_authenticator;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_computer_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_logon_0;
	TALLOC_CTX *_mem_save_validation_0;
	TALLOC_CTX *_mem_save_authoritative_0;
	TALLOC_CTX *_mem_save_flags_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.computer_name);
		} else {
			r->in.computer_name = NULL;
		}
		if (r->in.computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
			size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
			length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_credential));
		if (_ptr_credential) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		} else {
			r->in.credential = NULL;
		}
		if (r->in.credential) {
			_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->in.return_authenticator);
		} else {
			r->in.return_authenticator = NULL;
		}
		if (r->in.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		NDR_CHECK(ndr_pull_netr_LogonInfoClass(ndr, NDR_SCALARS, &r->in.logon_level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.logon);
		}
		_mem_save_logon_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.logon, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.logon));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.validation_level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.flags);
		}
		_mem_save_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.validation);
		ZERO_STRUCTP(r->out.validation);
		NDR_PULL_ALLOC(ndr, r->out.authoritative);
		ZERO_STRUCTP(r->out.authoritative);
		NDR_PULL_ALLOC(ndr, r->out.flags);
		*r->out.flags = *r->in.flags;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_return_authenticator));
		if (_ptr_return_authenticator) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		} else {
			r->out.return_authenticator = NULL;
		}
		if (r->out.return_authenticator) {
			_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, 0);
			NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.validation);
		}
		_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.validation, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.authoritative);
		}
		_mem_save_authoritative_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.authoritative, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authoritative_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.flags);
		}
		_mem_save_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_LogonSamLogonWithFlags(struct ndr_print *ndr, const char *name, int flags, const struct netr_LogonSamLogonWithFlags *r)
{
	ndr_print_struct(ndr, name, "netr_LogonSamLogonWithFlags");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_LogonSamLogonWithFlags");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		if (r->in.computer_name) {
			ndr_print_string(ndr, "computer_name", r->in.computer_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		if (r->in.credential) {
			ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "return_authenticator", r->in.return_authenticator);
		ndr->depth++;
		if (r->in.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->in.return_authenticator);
		}
		ndr->depth--;
		ndr_print_netr_LogonInfoClass(ndr, "logon_level", r->in.logon_level);
		ndr_print_ptr(ndr, "logon", r->in.logon);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", r->in.logon);
		ndr->depth--;
		ndr_print_uint16(ndr, "validation_level", r->in.validation_level);
		ndr_print_ptr(ndr, "flags", r->in.flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", *r->in.flags);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_LogonSamLogonWithFlags");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		if (r->out.return_authenticator) {
			ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "validation", r->out.validation);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.validation, r->in.validation_level);
		ndr_print_netr_Validation(ndr, "validation", r->out.validation);
		ndr->depth--;
		ndr_print_ptr(ndr, "authoritative", r->out.authoritative);
		ndr->depth++;
		ndr_print_uint8(ndr, "authoritative", *r->out.authoritative);
		ndr->depth--;
		ndr_print_ptr(ndr, "flags", r->out.flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "flags", *r->out.flags);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_ServerGetTrustInfo(struct ndr_push *ndr, int flags, const struct netr_ServerGetTrustInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.account_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.account_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.account_name, ndr_charset_length(r->in.account_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->in.secure_channel_type));
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.new_owf_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->out.new_owf_password));
		if (r->out.old_owf_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_samr_Password(ndr, NDR_SCALARS, r->out.old_owf_password));
		if (r->out.trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.trust_info));
		if (*r->out.trust_info) {
			NDR_CHECK(ndr_push_netr_TrustInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.trust_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_ServerGetTrustInfo(struct ndr_pull *ndr, int flags, struct netr_ServerGetTrustInfo *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_trust_info;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_new_owf_password_0;
	TALLOC_CTX *_mem_save_old_owf_password_0;
	TALLOC_CTX *_mem_save_trust_info_0;
	TALLOC_CTX *_mem_save_trust_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.account_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.account_name));
		size_account_name_1 = ndr_get_array_size(ndr, &r->in.account_name);
		length_account_name_1 = ndr_get_array_length(ndr, &r->in.account_name);
		if (length_account_name_1 > size_account_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_account_name_1, length_account_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.account_name, length_account_name_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->in.secure_channel_type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
		NDR_PULL_ALLOC(ndr, r->out.new_owf_password);
		ZERO_STRUCTP(r->out.new_owf_password);
		NDR_PULL_ALLOC(ndr, r->out.old_owf_password);
		ZERO_STRUCTP(r->out.old_owf_password);
		NDR_PULL_ALLOC(ndr, r->out.trust_info);
		ZERO_STRUCTP(r->out.trust_info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.new_owf_password);
		}
		_mem_save_new_owf_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.new_owf_password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->out.new_owf_password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_owf_password_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.old_owf_password);
		}
		_mem_save_old_owf_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.old_owf_password, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samr_Password(ndr, NDR_SCALARS, r->out.old_owf_password));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_old_owf_password_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.trust_info);
		}
		_mem_save_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trust_info));
		if (_ptr_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.trust_info);
		} else {
			*r->out.trust_info = NULL;
		}
		if (*r->out.trust_info) {
			_mem_save_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.trust_info, 0);
			NDR_CHECK(ndr_pull_netr_TrustInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_ServerGetTrustInfo(struct ndr_print *ndr, const char *name, int flags, const struct netr_ServerGetTrustInfo *r)
{
	ndr_print_struct(ndr, name, "netr_ServerGetTrustInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_ServerGetTrustInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account_name", r->in.account_name);
		ndr->depth++;
		ndr_print_string(ndr, "account_name", r->in.account_name);
		ndr->depth--;
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->in.secure_channel_type);
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_ServerGetTrustInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "new_owf_password", r->out.new_owf_password);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "new_owf_password", r->out.new_owf_password);
		ndr->depth--;
		ndr_print_ptr(ndr, "old_owf_password", r->out.old_owf_password);
		ndr->depth++;
		ndr_print_samr_Password(ndr, "old_owf_password", r->out.old_owf_password);
		ndr->depth--;
		ndr_print_ptr(ndr, "trust_info", r->out.trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "trust_info", *r->out.trust_info);
		ndr->depth++;
		if (*r->out.trust_info) {
			ndr_print_netr_TrustInfo(ndr, "trust_info", *r->out.trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_Unused47(struct ndr_push *ndr, int flags, const struct netr_Unused47 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_Unused47(struct ndr_pull *ndr, int flags, struct netr_Unused47 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_Unused47(struct ndr_print *ndr, const char *name, int flags, const struct netr_Unused47 *r)
{
	ndr_print_struct(ndr, name, "netr_Unused47");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_Unused47");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_Unused47");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_netr_DsrUpdateReadOnlyServerDnsRecords(struct ndr_push *ndr, int flags, const struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.computer_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.computer_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.computer_name, ndr_charset_length(r->in.computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.credential == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dns_ttl));
		if (r->in.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
	}
	if (flags & NDR_OUT) {
		if (r->out.return_authenticator == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		if (r->out.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netr_DsrUpdateReadOnlyServerDnsRecords(struct ndr_pull *ndr, int flags, struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	uint32_t _ptr_server_name;
	uint32_t size_server_name_1 = 0;
	uint32_t length_server_name_1 = 0;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_server_name_0;
	TALLOC_CTX *_mem_save_credential_0;
	TALLOC_CTX *_mem_save_return_authenticator_0;
	TALLOC_CTX *_mem_save_site_name_0;
	TALLOC_CTX *_mem_save_dns_names_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			size_server_name_1 = ndr_get_array_size(ndr, &r->in.server_name);
			length_server_name_1 = ndr_get_array_length(ndr, &r->in.server_name);
			if (length_server_name_1 > size_server_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_name_1, length_server_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, length_server_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.computer_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.computer_name));
		size_computer_name_1 = ndr_get_array_size(ndr, &r->in.computer_name);
		length_computer_name_1 = ndr_get_array_length(ndr, &r->in.computer_name);
		if (length_computer_name_1 > size_computer_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_computer_name_1, length_computer_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.credential);
		}
		_mem_save_credential_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.credential, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->in.credential));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_credential_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			size_site_name_1 = ndr_get_array_size(ndr, &r->in.site_name);
			length_site_name_1 = ndr_get_array_length(ndr, &r->in.site_name);
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dns_ttl));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		ZERO_STRUCTP(r->out.return_authenticator);
		NDR_PULL_ALLOC(ndr, r->out.dns_names);
		*r->out.dns_names = *r->in.dns_names;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.return_authenticator);
		}
		_mem_save_return_authenticator_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.return_authenticator, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_Authenticator(ndr, NDR_SCALARS, r->out.return_authenticator));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_return_authenticator_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_DsrUpdateReadOnlyServerDnsRecords(struct ndr_print *ndr, const char *name, int flags, const struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	ndr_print_struct(ndr, name, "netr_DsrUpdateReadOnlyServerDnsRecords");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "netr_DsrUpdateReadOnlyServerDnsRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "computer_name", r->in.computer_name);
		ndr->depth++;
		ndr_print_string(ndr, "computer_name", r->in.computer_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "credential", r->in.credential);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "credential", r->in.credential);
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dns_ttl", r->in.dns_ttl);
		ndr_print_ptr(ndr, "dns_names", r->in.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->in.dns_names);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "netr_DsrUpdateReadOnlyServerDnsRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth++;
		ndr_print_netr_Authenticator(ndr, "return_authenticator", r->out.return_authenticator);
		ndr->depth--;
		ndr_print_ptr(ndr, "dns_names", r->out.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->out.dns_names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call netlogon_calls[] = {
	{
		"netr_LogonUasLogon",
		sizeof(struct netr_LogonUasLogon),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonUasLogon,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonUasLogon,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonUasLogoff",
		sizeof(struct netr_LogonUasLogoff),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonUasLogoff,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonUasLogoff,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonSamLogon",
		sizeof(struct netr_LogonSamLogon),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonSamLogon,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonSamLogon,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonSamLogoff",
		sizeof(struct netr_LogonSamLogoff),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonSamLogoff,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonSamLogoff,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerReqChallenge",
		sizeof(struct netr_ServerReqChallenge),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerReqChallenge,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerReqChallenge,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerAuthenticate",
		sizeof(struct netr_ServerAuthenticate),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerAuthenticate,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerAuthenticate,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerPasswordSet",
		sizeof(struct netr_ServerPasswordSet),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerPasswordSet,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerPasswordSet,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DatabaseDeltas",
		sizeof(struct netr_DatabaseDeltas),
		(ndr_push_flags_fn_t) ndr_push_netr_DatabaseDeltas,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DatabaseDeltas,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DatabaseSync",
		sizeof(struct netr_DatabaseSync),
		(ndr_push_flags_fn_t) ndr_push_netr_DatabaseSync,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DatabaseSync,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_AccountDeltas",
		sizeof(struct netr_AccountDeltas),
		(ndr_push_flags_fn_t) ndr_push_netr_AccountDeltas,
		(ndr_pull_flags_fn_t) ndr_pull_netr_AccountDeltas,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_AccountSync",
		sizeof(struct netr_AccountSync),
		(ndr_push_flags_fn_t) ndr_push_netr_AccountSync,
		(ndr_pull_flags_fn_t) ndr_pull_netr_AccountSync,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_GetDcName",
		sizeof(struct netr_GetDcName),
		(ndr_push_flags_fn_t) ndr_push_netr_GetDcName,
		(ndr_pull_flags_fn_t) ndr_pull_netr_GetDcName,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonControl",
		sizeof(struct netr_LogonControl),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonControl,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonControl,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_GetAnyDCName",
		sizeof(struct netr_GetAnyDCName),
		(ndr_push_flags_fn_t) ndr_push_netr_GetAnyDCName,
		(ndr_pull_flags_fn_t) ndr_pull_netr_GetAnyDCName,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonControl2",
		sizeof(struct netr_LogonControl2),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonControl2,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonControl2,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerAuthenticate2",
		sizeof(struct netr_ServerAuthenticate2),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerAuthenticate2,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerAuthenticate2,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DatabaseSync2",
		sizeof(struct netr_DatabaseSync2),
		(ndr_push_flags_fn_t) ndr_push_netr_DatabaseSync2,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DatabaseSync2,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DatabaseRedo",
		sizeof(struct netr_DatabaseRedo),
		(ndr_push_flags_fn_t) ndr_push_netr_DatabaseRedo,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DatabaseRedo,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonControl2Ex",
		sizeof(struct netr_LogonControl2Ex),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonControl2Ex,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonControl2Ex,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NetrEnumerateTrustedDomains",
		sizeof(struct netr_NetrEnumerateTrustedDomains),
		(ndr_push_flags_fn_t) ndr_push_netr_NetrEnumerateTrustedDomains,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NetrEnumerateTrustedDomains,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRGetDCName",
		sizeof(struct netr_DsRGetDCName),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRGetDCName,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRGetDCName,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonGetCapabilities",
		sizeof(struct netr_LogonGetCapabilities),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonGetCapabilities,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonGetCapabilities,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NETRLOGONSETSERVICEBITS",
		sizeof(struct netr_NETRLOGONSETSERVICEBITS),
		(ndr_push_flags_fn_t) ndr_push_netr_NETRLOGONSETSERVICEBITS,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NETRLOGONSETSERVICEBITS,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonGetTrustRid",
		sizeof(struct netr_LogonGetTrustRid),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonGetTrustRid,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonGetTrustRid,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NETRLOGONCOMPUTESERVERDIGEST",
		sizeof(struct netr_NETRLOGONCOMPUTESERVERDIGEST),
		(ndr_push_flags_fn_t) ndr_push_netr_NETRLOGONCOMPUTESERVERDIGEST,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NETRLOGONCOMPUTESERVERDIGEST,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NETRLOGONCOMPUTECLIENTDIGEST",
		sizeof(struct netr_NETRLOGONCOMPUTECLIENTDIGEST),
		(ndr_push_flags_fn_t) ndr_push_netr_NETRLOGONCOMPUTECLIENTDIGEST,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NETRLOGONCOMPUTECLIENTDIGEST,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerAuthenticate3",
		sizeof(struct netr_ServerAuthenticate3),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerAuthenticate3,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerAuthenticate3,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRGetDCNameEx",
		sizeof(struct netr_DsRGetDCNameEx),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRGetDCNameEx,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRGetDCNameEx,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRGetSiteName",
		sizeof(struct netr_DsRGetSiteName),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRGetSiteName,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRGetSiteName,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonGetDomainInfo",
		sizeof(struct netr_LogonGetDomainInfo),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonGetDomainInfo,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonGetDomainInfo,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerPasswordSet2",
		sizeof(struct netr_ServerPasswordSet2),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerPasswordSet2,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerPasswordSet2,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerPasswordGet",
		sizeof(struct netr_ServerPasswordGet),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerPasswordGet,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerPasswordGet,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NETRLOGONSENDTOSAM",
		sizeof(struct netr_NETRLOGONSENDTOSAM),
		(ndr_push_flags_fn_t) ndr_push_netr_NETRLOGONSENDTOSAM,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NETRLOGONSENDTOSAM,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRAddressToSitenamesW",
		sizeof(struct netr_DsRAddressToSitenamesW),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRAddressToSitenamesW,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRAddressToSitenamesW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRGetDCNameEx2",
		sizeof(struct netr_DsRGetDCNameEx2),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRGetDCNameEx2,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRGetDCNameEx2,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN",
		sizeof(struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN),
		(ndr_push_flags_fn_t) ndr_push_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_NetrEnumerateTrustedDomainsEx",
		sizeof(struct netr_NetrEnumerateTrustedDomainsEx),
		(ndr_push_flags_fn_t) ndr_push_netr_NetrEnumerateTrustedDomainsEx,
		(ndr_pull_flags_fn_t) ndr_pull_netr_NetrEnumerateTrustedDomainsEx,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRAddressToSitenamesExW",
		sizeof(struct netr_DsRAddressToSitenamesExW),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRAddressToSitenamesExW,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRAddressToSitenamesExW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsrGetDcSiteCoverageW",
		sizeof(struct netr_DsrGetDcSiteCoverageW),
		(ndr_push_flags_fn_t) ndr_push_netr_DsrGetDcSiteCoverageW,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsrGetDcSiteCoverageW,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonSamLogonEx",
		sizeof(struct netr_LogonSamLogonEx),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonSamLogonEx,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonSamLogonEx,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsrEnumerateDomainTrusts",
		sizeof(struct netr_DsrEnumerateDomainTrusts),
		(ndr_push_flags_fn_t) ndr_push_netr_DsrEnumerateDomainTrusts,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsrEnumerateDomainTrusts,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsrDeregisterDNSHostRecords",
		sizeof(struct netr_DsrDeregisterDNSHostRecords),
		(ndr_push_flags_fn_t) ndr_push_netr_DsrDeregisterDNSHostRecords,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsrDeregisterDNSHostRecords,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerTrustPasswordsGet",
		sizeof(struct netr_ServerTrustPasswordsGet),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerTrustPasswordsGet,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerTrustPasswordsGet,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsRGetForestTrustInformation",
		sizeof(struct netr_DsRGetForestTrustInformation),
		(ndr_push_flags_fn_t) ndr_push_netr_DsRGetForestTrustInformation,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsRGetForestTrustInformation,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_GetForestTrustInformation",
		sizeof(struct netr_GetForestTrustInformation),
		(ndr_push_flags_fn_t) ndr_push_netr_GetForestTrustInformation,
		(ndr_pull_flags_fn_t) ndr_pull_netr_GetForestTrustInformation,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_LogonSamLogonWithFlags",
		sizeof(struct netr_LogonSamLogonWithFlags),
		(ndr_push_flags_fn_t) ndr_push_netr_LogonSamLogonWithFlags,
		(ndr_pull_flags_fn_t) ndr_pull_netr_LogonSamLogonWithFlags,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_ServerGetTrustInfo",
		sizeof(struct netr_ServerGetTrustInfo),
		(ndr_push_flags_fn_t) ndr_push_netr_ServerGetTrustInfo,
		(ndr_pull_flags_fn_t) ndr_pull_netr_ServerGetTrustInfo,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_Unused47",
		sizeof(struct netr_Unused47),
		(ndr_push_flags_fn_t) ndr_push_netr_Unused47,
		(ndr_pull_flags_fn_t) ndr_pull_netr_Unused47,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"netr_DsrUpdateReadOnlyServerDnsRecords",
		sizeof(struct netr_DsrUpdateReadOnlyServerDnsRecords),
		(ndr_push_flags_fn_t) ndr_push_netr_DsrUpdateReadOnlyServerDnsRecords,
		(ndr_pull_flags_fn_t) ndr_pull_netr_DsrUpdateReadOnlyServerDnsRecords,
		(ndr_print_function_t) ndr_print_disabled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const netlogon_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\netlogon]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array netlogon_endpoints = {
	.count	= 3,
	.names	= netlogon_endpoint_strings
};

static const char * const netlogon_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array netlogon_authservices = {
	.count	= 1,
	.names	= netlogon_authservice_strings
};


const struct ndr_interface_table ndr_table_netlogon = {
	.name		= "netlogon",
	.syntax_id	= {
		{0x12345678,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0xcf,0xfb}},
		NDR_NETLOGON_VERSION
	},
	.helpstring	= NDR_NETLOGON_HELPSTRING,
	.num_calls	= 49,
	.calls		= netlogon_calls,
	.endpoints	= &netlogon_endpoints,
	.authservices	= &netlogon_authservices
};

